/*
 * Decompiled with CFR 0.152.
 */
package org.chronos.chronosphere.impl.query;

import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.function.Function;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.chronos.chronograph.api.structure.ChronoGraph;
import org.chronos.chronosphere.api.ChronoSphereTransaction;
import org.chronos.chronosphere.api.query.EObjectQueryStepBuilder;
import org.chronos.chronosphere.api.query.QueryStepBuilder;
import org.chronos.chronosphere.api.query.QueryStepBuilderInternal;
import org.chronos.chronosphere.emf.api.ChronoEObject;
import org.chronos.chronosphere.impl.query.steps.eobject.EObjectQueryAsEObjectStepBuilder;
import org.chronos.chronosphere.impl.query.steps.object.ObjectQueryEObjectReifyStepBuilder;
import org.chronos.chronosphere.impl.query.steps.object.ObjectQueryTerminalConverterStepBuilder;
import org.chronos.chronosphere.impl.query.traversal.TraversalBaseSource;
import org.chronos.chronosphere.impl.query.traversal.TraversalChainElement;
import org.chronos.chronosphere.impl.query.traversal.TraversalSource;
import org.chronos.chronosphere.impl.query.traversal.TraversalTransformer;
import org.chronos.chronosphere.internal.api.ChronoSphereTransactionInternal;
import org.eclipse.emf.ecore.EObject;

public class QueryUtils {
    public static QueryStepBuilderInternal<?, ?> getFirstBuilderInChain(QueryStepBuilder<?, ?> builder) {
        TraversalChainElement previous;
        QueryStepBuilderInternal current = (QueryStepBuilderInternal)builder;
        while ((previous = current.getPrevious()) instanceof QueryStepBuilderInternal) {
            current = (QueryStepBuilderInternal)((Object)previous);
        }
        return current;
    }

    public static ChronoSphereTransactionInternal getTransactionFromTraversalBaseSourceOf(QueryStepBuilder<?, ?> builder) {
        TraversalChainElement current = (TraversalChainElement)((Object)builder);
        while (current instanceof QueryStepBuilderInternal) {
            TraversalChainElement previous;
            current = previous = ((QueryStepBuilderInternal)((Object)current)).getPrevious();
        }
        if (current instanceof TraversalBaseSource) {
            TraversalBaseSource baseSource = (TraversalBaseSource)current;
            return baseSource.getTransaction();
        }
        throw new IllegalStateException("Calling a terminating method on a traversal which was created by a SubQuery method is invalid! Subqueries cannot be evaluated as standalone queries!");
    }

    public static <S, E> GraphTraversal<S, E> resolveTraversalChain(QueryStepBuilder<S, E> builder, ChronoSphereTransactionInternal tx, boolean forceReifyEObjectsAtEnd) {
        TraversalChainElement last;
        List<TraversalChainElement> chainElements = Lists.newArrayList();
        TraversalChainElement currentBuilder = (TraversalChainElement)((Object)builder);
        while (currentBuilder != null) {
            chainElements.add(currentBuilder);
            if (currentBuilder instanceof QueryStepBuilderInternal) {
                QueryStepBuilderInternal stepBuilder = (QueryStepBuilderInternal)((Object)currentBuilder);
                currentBuilder = stepBuilder.getPrevious();
                continue;
            }
            currentBuilder = null;
        }
        if ((chainElements = Lists.reverse((List)chainElements)).isEmpty()) {
            throw new IllegalStateException("At least one element must be on the query chain!");
        }
        TraversalChainElement first = (TraversalChainElement)chainElements.get(0);
        if (!(first instanceof TraversalSource)) {
            throw new IllegalStateException("There is no traversal source for this query chain!");
        }
        TraversalSource source = (TraversalSource)first;
        QueryUtils.optimizeTraversalChain(chainElements);
        if (forceReifyEObjectsAtEnd && (last = (TraversalChainElement)Iterables.getLast(chainElements)) instanceof EObjectQueryStepBuilder) {
            chainElements.add(new ObjectQueryTerminalConverterStepBuilder(last));
        }
        GraphTraversal traversal = source.createTraversal();
        for (int i = 1; i < chainElements.size(); ++i) {
            TraversalChainElement element = chainElements.get(i);
            if (!(element instanceof TraversalTransformer)) {
                throw new IllegalStateException("Illegal traversal chain: there are multiple traversal sources!");
            }
            TraversalTransformer transformer = (TraversalTransformer)element;
            traversal = transformer.transformTraversal(tx, traversal);
        }
        return traversal;
    }

    private static void optimizeTraversalChain(List<TraversalChainElement> chainElements) {
        ListIterator<TraversalChainElement> listIterator = chainElements.listIterator();
        while (listIterator.hasNext()) {
            TraversalChainElement current = listIterator.next();
            if (!listIterator.hasNext()) break;
            TraversalChainElement next = listIterator.next();
            listIterator.previous();
            if (current instanceof ObjectQueryEObjectReifyStepBuilder && next instanceof EObjectQueryAsEObjectStepBuilder) {
                listIterator.previous();
                listIterator.remove();
                listIterator.next();
                listIterator.remove();
                continue;
            }
            if (!(current instanceof EObjectQueryAsEObjectStepBuilder) || !(next instanceof ObjectQueryEObjectReifyStepBuilder)) continue;
            listIterator.previous();
            listIterator.remove();
            listIterator.next();
            listIterator.remove();
        }
    }

    public static GraphTraversal<Vertex, Object>[] subQueriesToVertexTraversals(ChronoSphereTransactionInternal tx, QueryStepBuilder<?, ?>[] subqueries, boolean forceReifyEObjectsAtEnd) {
        ArrayList innerTraversals = Lists.newArrayList();
        for (QueryStepBuilder<?, ?> subquery : subqueries) {
            QueryStepBuilderInternal<?, ?> firstBuilder = QueryUtils.getFirstBuilderInChain(subquery);
            if (!(firstBuilder instanceof EObjectQueryStepBuilder)) {
                TraversalSource source = (TraversalSource)firstBuilder.getPrevious();
                ObjectQueryEObjectReifyStepBuilder reifyStep = new ObjectQueryEObjectReifyStepBuilder(source);
                firstBuilder.setPrevious(reifyStep);
            }
            GraphTraversal<?, ?> traversal = QueryUtils.resolveTraversalChain(subquery, tx, forceReifyEObjectsAtEnd);
            innerTraversals.add(traversal);
        }
        return innerTraversals.toArray(new GraphTraversal[innerTraversals.size()]);
    }

    public static GraphTraversal<Object, Object>[] subQueriesToObjectTraversals(ChronoSphereTransactionInternal tx, QueryStepBuilder<?, ?>[] subqueries, boolean forceReifyEObjectsAtEnd) {
        ArrayList innerTraversals = Lists.newArrayList();
        for (QueryStepBuilder<?, ?> subquery : subqueries) {
            QueryStepBuilderInternal<?, ?> firstBuilder = QueryUtils.getFirstBuilderInChain(subquery);
            if (firstBuilder instanceof EObjectQueryStepBuilder) {
                TraversalSource source = (TraversalSource)firstBuilder.getPrevious();
                EObjectQueryAsEObjectStepBuilder transformStep = new EObjectQueryAsEObjectStepBuilder(source);
                firstBuilder.setPrevious(transformStep);
            }
            GraphTraversal<?, ?> traversal = QueryUtils.resolveTraversalChain(subquery, tx, forceReifyEObjectsAtEnd);
            innerTraversals.add(traversal);
        }
        return innerTraversals.toArray(new GraphTraversal[innerTraversals.size()]);
    }

    public static <S, C> GraphTraversal<S, C> castTraversalTo(GraphTraversal<S, ?> traversal, Class<C> clazz) {
        return traversal.filter(t -> clazz.isInstance(t.get())).map(t -> clazz.cast(t.get()));
    }

    public static <S, C> GraphTraversal<S, C> castTraversalToNumeric(GraphTraversal<S, ?> traversal, Function<Number, C> conversion) {
        return traversal.filter(t -> t.get() instanceof Number).map(t -> conversion.apply((Number)t.get()));
    }

    public static <S, E> GraphTraversal<S, E> prepareTerminalOperation(QueryStepBuilderInternal<S, E> builder, boolean forceReifyEObjectsAtEnd) {
        ChronoSphereTransactionInternal tx = QueryUtils.getTransactionFromTraversalBaseSourceOf(builder);
        return QueryUtils.resolveTraversalChain(builder, tx, forceReifyEObjectsAtEnd);
    }

    public static EObject mapVertexToEObject(ChronoSphereTransaction tx, Traverser<Vertex> traverser) {
        return QueryUtils.mapVertexToEObject(tx, (Vertex)traverser.get());
    }

    public static EObject mapVertexToEObject(ChronoSphereTransaction tx, Vertex vertex) {
        if (vertex == null) {
            return null;
        }
        return tx.getEObjectById((String)vertex.id());
    }

    public static Vertex mapEObjectToVertex(ChronoSphereTransaction tx, EObject eObject) {
        ChronoGraph graph = ((ChronoSphereTransactionInternal)tx).getGraph();
        return QueryUtils.mapEObjectToVertex(graph, eObject);
    }

    public static Vertex mapEObjectToVertex(ChronoGraph graph, EObject eObject) {
        if (eObject == null) {
            return null;
        }
        ChronoEObject cEObject = (ChronoEObject)eObject;
        if (graph == null) {
            throw new IllegalStateException("Graph is NULL!");
        }
        return (Vertex)Iterators.getOnlyElement((Iterator)graph.vertices(new Object[]{cEObject.getId()}), null);
    }
}

