/*
 * Decompiled with CFR 0.152.
 */
package org.chronos.chronosphere.impl.query.steps.eobject;

import com.google.common.base.Objects;
import com.google.common.collect.Iterators;
import java.util.Collections;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.chronos.chronosphere.impl.query.EObjectQueryStepBuilderImpl;
import org.chronos.chronosphere.impl.query.QueryUtils;
import org.chronos.chronosphere.impl.query.traversal.TraversalChainElement;
import org.chronos.chronosphere.internal.api.ChronoSphereTransactionInternal;
import org.chronos.chronosphere.internal.ogm.api.ChronoSphereGraphFormat;
import org.chronos.chronosphere.internal.ogm.api.VertexKind;
import org.eclipse.emf.ecore.EObject;

public class EObjectQueryAsEObjectStepBuilder<S, I>
extends EObjectQueryStepBuilderImpl<S, I> {
    public EObjectQueryAsEObjectStepBuilder(TraversalChainElement previous) {
        super(previous);
    }

    @Override
    public GraphTraversal<S, Vertex> transformTraversal(ChronoSphereTransactionInternal tx, GraphTraversal<S, I> traversal) {
        return traversal.flatMap(traverser -> {
            Object value = traverser.get();
            if (value instanceof EObject) {
                return Iterators.singletonIterator((Object)QueryUtils.mapEObjectToVertex(tx, (EObject)value));
            }
            if (value instanceof Vertex) {
                Vertex vertex = (Vertex)value;
                VertexKind kind = ChronoSphereGraphFormat.getVertexKind(vertex);
                if (Objects.equal((Object)((Object)kind), (Object)((Object)VertexKind.EOBJECT))) {
                    return Iterators.singletonIterator((Object)vertex);
                }
                return Collections.emptyIterator();
            }
            return Collections.emptyIterator();
        });
    }
}

