/*
 * Decompiled with CFR 0.152.
 */
package org.chronos.chronosphere.impl.query.steps.eobject;

import com.google.common.base.Preconditions;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.__;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.chronos.chronosphere.api.query.Direction;
import org.chronos.chronosphere.impl.query.EObjectQueryStepBuilderImpl;
import org.chronos.chronosphere.impl.query.traversal.TraversalChainElement;
import org.chronos.chronosphere.internal.api.ChronoSphereTransactionInternal;
import org.chronos.chronosphere.internal.ogm.api.ChronoEPackageRegistry;
import org.chronos.chronosphere.internal.ogm.api.ChronoSphereGraphFormat;
import org.chronos.common.exceptions.UnknownEnumLiteralException;
import org.eclipse.emf.ecore.EReference;

public class EObjectQueryClosureStepBuilder<S>
extends EObjectQueryStepBuilderImpl<S, Vertex> {
    private final EReference eReference;
    private final Direction direction;

    public EObjectQueryClosureStepBuilder(TraversalChainElement previous, EReference eReference, Direction direction) {
        super(previous);
        Preconditions.checkNotNull((Object)eReference, (Object)"Precondition violation - argument 'eReference' must not be NULL!");
        Preconditions.checkNotNull((Object)((Object)direction), (Object)"Precondition violation - argument 'direction' must not be NULL!");
        this.eReference = eReference;
        this.direction = direction;
    }

    @Override
    public GraphTraversal<S, Vertex> transformTraversal(ChronoSphereTransactionInternal tx, GraphTraversal<S, Vertex> traversal) {
        GraphTraversal closureTraversal;
        ChronoEPackageRegistry registry = tx.getEPackageRegistry();
        String label = ChronoSphereGraphFormat.createReferenceEdgeLabel(registry, this.eReference);
        switch (this.direction) {
            case INCOMING: {
                closureTraversal = __.in((String[])new String[]{label});
                break;
            }
            case OUTGOING: {
                closureTraversal = __.out((String[])new String[]{label});
                break;
            }
            case BOTH: {
                closureTraversal = __.both((String[])new String[]{label});
                break;
            }
            default: {
                throw new UnknownEnumLiteralException((Object)this.direction);
            }
        }
        return traversal.repeat((Traversal)closureTraversal.simplePath()).emit().until(t -> false).dedup(new String[0]);
    }
}

