/*
 * Decompiled with CFR 0.152.
 */
package org.chronos.chronosphere.impl.query.steps.eobject;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.SetMultimap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.chronos.chronosphere.emf.internal.util.EMFUtils;
import org.chronos.chronosphere.impl.query.EObjectQueryStepBuilderImpl;
import org.chronos.chronosphere.impl.query.traversal.TraversalChainElement;
import org.chronos.chronosphere.internal.api.ChronoSphereTransactionInternal;
import org.chronos.chronosphere.internal.ogm.api.ChronoEPackageRegistry;
import org.chronos.chronosphere.internal.ogm.api.ChronoSphereGraphFormat;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;

public class EObjectQueryEGetInverseByNameStepBuilder<S>
extends EObjectQueryStepBuilderImpl<S, Vertex> {
    private final String referenceName;

    public EObjectQueryEGetInverseByNameStepBuilder(TraversalChainElement previous, String referenceName) {
        super(previous);
        Preconditions.checkNotNull((Object)referenceName, (Object)"Precondition violation - argument 'referenceName' must not be NULL!");
        this.referenceName = referenceName;
    }

    @Override
    public GraphTraversal<S, Vertex> transformTraversal(ChronoSphereTransactionInternal tx, GraphTraversal<S, Vertex> traversal) {
        ChronoEPackageRegistry registry = tx.getEPackageRegistry();
        SetMultimap<EClass, EReference> eClassToIncomingReferences = EMFUtils.eClassToIncomingEReferences(registry.getEPackages());
        Set eReferences = eClassToIncomingReferences.values().stream().filter((? super T ref) -> Objects.equal((Object)ref.getName(), (Object)this.referenceName)).collect(Collectors.toSet());
        List<String> labelList = eReferences.stream().map((? super T ref) -> ChronoSphereGraphFormat.createReferenceEdgeLabel(registry, ref)).collect(Collectors.toList());
        String[] labels = labelList.toArray(new String[labelList.size()]);
        return traversal.in(labels);
    }
}

