/*
 * Decompiled with CFR 0.152.
 */
package org.chronos.chronosphere.impl.query.steps.eobject;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.chronos.chronosphere.emf.api.ChronoEObject;
import org.chronos.chronosphere.impl.query.EObjectQueryStepBuilderImpl;
import org.chronos.chronosphere.impl.query.traversal.TraversalChainElement;
import org.chronos.chronosphere.internal.api.ChronoSphereTransactionInternal;

public class EObjectQueryExceptObjectsStepBuilder<S>
extends EObjectQueryStepBuilderImpl<S, Vertex> {
    private final Set<String> eObjectIDsToExclude;

    public EObjectQueryExceptObjectsStepBuilder(TraversalChainElement previous, Set<?> elementsToExclude) {
        super(previous);
        Preconditions.checkNotNull(elementsToExclude, (Object)"Precondition violation - argument 'elementsToExclude' must not be NULL!");
        this.eObjectIDsToExclude = Sets.newHashSet();
        for (Object element : elementsToExclude) {
            if (!(element instanceof ChronoEObject)) continue;
            ChronoEObject cEObject = (ChronoEObject)element;
            this.eObjectIDsToExclude.add(cEObject.getId());
        }
    }

    @Override
    public GraphTraversal<S, Vertex> transformTraversal(ChronoSphereTransactionInternal tx, GraphTraversal<S, Vertex> traversal) {
        return traversal.filter(t -> {
            Vertex vertex = (Vertex)t.get();
            if (vertex == null) {
                return false;
            }
            return !this.eObjectIDsToExclude.contains(vertex.id());
        });
    }
}

