/*
 * Decompiled with CFR 0.152.
 */
package org.chronos.chronosphere.impl.query.steps.eobject;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.chronos.chronosphere.api.ChronoSphereTransaction;
import org.chronos.chronosphere.impl.query.EObjectQueryStepBuilderImpl;
import org.chronos.chronosphere.impl.query.QueryUtils;
import org.chronos.chronosphere.impl.query.traversal.TraversalChainElement;
import org.chronos.chronosphere.internal.api.ChronoSphereTransactionInternal;
import org.chronos.chronosphere.internal.ogm.api.ChronoEPackageRegistry;
import org.chronos.chronosphere.internal.ogm.api.ChronoSphereGraphFormat;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class EObjectQueryHasFeatureValueStepBuilder<S>
extends EObjectQueryStepBuilderImpl<S, Vertex> {
    private final EStructuralFeature feature;
    private final Object value;

    public EObjectQueryHasFeatureValueStepBuilder(TraversalChainElement previous, EStructuralFeature feature, Object value) {
        super(previous);
        Preconditions.checkNotNull((Object)feature, (Object)"Precondition violation - argument 'feature' must not be NULL!");
        this.feature = feature;
        this.value = value;
    }

    @Override
    public GraphTraversal<S, Vertex> transformTraversal(ChronoSphereTransactionInternal tx, GraphTraversal<S, Vertex> traversal) {
        ChronoEPackageRegistry registry = tx.getEPackageRegistry();
        EStructuralFeature storedFeature = registry.getRegisteredEStructuralFeature(this.feature);
        if (storedFeature instanceof EAttribute) {
            String key = ChronoSphereGraphFormat.createVertexPropertyKey(registry, (EAttribute)storedFeature);
            return traversal.has(key, this.value);
        }
        return traversal.map(t -> QueryUtils.mapVertexToEObject((ChronoSphereTransaction)tx, (Traverser<Vertex>)t)).filter(t -> {
            EObject eObject = (EObject)t.get();
            if (eObject == null) {
                return false;
            }
            EClass eClass = eObject.eClass();
            if (!eClass.getEAllStructuralFeatures().contains((Object)storedFeature)) {
                return false;
            }
            return Objects.equal((Object)eObject.eGet(storedFeature), (Object)this.value);
        }).map(t -> QueryUtils.mapEObjectToVertex(tx.getGraph(), (EObject)t.get()));
    }
}

