/*
 * Decompiled with CFR 0.152.
 */
package org.chronos.chronosphere.impl.query.steps.eobject;

import com.google.common.base.Preconditions;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.chronos.chronosphere.api.ChronoSphereTransaction;
import org.chronos.chronosphere.impl.query.EObjectQueryStepBuilderImpl;
import org.chronos.chronosphere.impl.query.QueryUtils;
import org.chronos.chronosphere.impl.query.traversal.TraversalChainElement;
import org.chronos.chronosphere.internal.api.ChronoSphereTransactionInternal;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;

public class EObjectQueryInstanceOfEClassNameStepBuilder<S>
extends EObjectQueryStepBuilderImpl<S, Vertex> {
    private final String eClassName;
    private final boolean allowSubclasses;

    public EObjectQueryInstanceOfEClassNameStepBuilder(TraversalChainElement previous, String eClassName, boolean allowSubclasses) {
        super(previous);
        Preconditions.checkNotNull((Object)eClassName, (Object)"Precondition violation - argument 'eClassName' must not be NULL!");
        this.eClassName = eClassName;
        this.allowSubclasses = allowSubclasses;
    }

    @Override
    public GraphTraversal<S, Vertex> transformTraversal(ChronoSphereTransactionInternal tx, GraphTraversal<S, Vertex> traversal) {
        EClass eClass = tx.getEClassByQualifiedName(this.eClassName);
        if (eClass == null) {
            eClass = tx.getEClassBySimpleName(this.eClassName);
        }
        if (eClass == null) {
            throw new IllegalArgumentException("Could not find EClass with name '" + this.eClassName + "'!");
        }
        EClass finalClass = eClass;
        if (!this.allowSubclasses) {
            String eClassID = tx.getEPackageRegistry().getEClassID(finalClass);
            String key = "eClass";
            return traversal.has(key, (Object)eClassID);
        }
        return traversal.map(t -> QueryUtils.mapVertexToEObject((ChronoSphereTransaction)tx, (Traverser<Vertex>)t)).filter(t -> {
            EObject eObject = (EObject)t.get();
            if (eObject == null) {
                return false;
            }
            return finalClass.isInstance((Object)eObject);
        }).map(t -> QueryUtils.mapEObjectToVertex(tx.getGraph(), (EObject)t.get()));
    }
}

