/*
 * Decompiled with CFR 0.152.
 */
package org.chronos.chronosphere.impl.query.steps.eobject;

import com.google.common.base.Preconditions;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.chronos.chronosphere.api.ChronoSphereTransaction;
import org.chronos.chronosphere.impl.query.EObjectQueryStepBuilderImpl;
import org.chronos.chronosphere.impl.query.QueryUtils;
import org.chronos.chronosphere.impl.query.traversal.TraversalChainElement;
import org.chronos.chronosphere.internal.api.ChronoSphereTransactionInternal;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;

public class EObjectQueryInstanceOfEClassStepBuilder<S>
extends EObjectQueryStepBuilderImpl<S, Vertex> {
    private final EClass eClass;
    private final boolean allowSubclasses;

    public EObjectQueryInstanceOfEClassStepBuilder(TraversalChainElement previous, EClass eClass, boolean allowSubclasses) {
        super(previous);
        Preconditions.checkNotNull((Object)eClass, (Object)"Precondition violation - argument 'eClass' must not be NULL!");
        this.eClass = eClass;
        this.allowSubclasses = allowSubclasses;
    }

    @Override
    public GraphTraversal<S, Vertex> transformTraversal(ChronoSphereTransactionInternal tx, GraphTraversal<S, Vertex> traversal) {
        if (!this.allowSubclasses) {
            String eClassID = tx.getEPackageRegistry().getEClassID(this.eClass);
            String key = "eClass";
            return traversal.has(key, (Object)eClassID);
        }
        return traversal.map(t -> QueryUtils.mapVertexToEObject((ChronoSphereTransaction)tx, (Traverser<Vertex>)t)).filter(this::filterEObject).map(t -> QueryUtils.mapEObjectToVertex(tx.getGraph(), (EObject)t.get()));
    }

    private boolean filterEObject(Traverser<EObject> traverser) {
        EObject eObject = (EObject)traverser.get();
        if (eObject == null) {
            return false;
        }
        return this.eClass.isSuperTypeOf(eObject.eClass());
    }
}

