/*
 * Decompiled with CFR 0.152.
 */
package org.chronos.chronosphere.impl.query.steps.object;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.chronos.chronosphere.impl.query.ObjectQueryStepBuilderImpl;
import org.chronos.chronosphere.impl.query.traversal.TraversalChainElement;
import org.chronos.chronosphere.internal.api.ChronoSphereTransactionInternal;
import org.chronos.chronosphere.internal.ogm.api.ChronoEPackageRegistry;
import org.chronos.chronosphere.internal.ogm.api.ChronoSphereGraphFormat;
import org.eclipse.emf.ecore.EAttribute;

public class ObjectQueryEGetAttributeStepBuilder<S>
extends ObjectQueryStepBuilderImpl<S, Vertex, Object> {
    private final EAttribute eAttribute;

    public ObjectQueryEGetAttributeStepBuilder(TraversalChainElement previous, EAttribute eAttribute) {
        super(previous);
        Preconditions.checkNotNull((Object)eAttribute, (Object)"Precondition violation - argument 'eAttribute' must not be NULL!");
        this.eAttribute = eAttribute;
    }

    @Override
    public GraphTraversal<S, Object> transformTraversal(ChronoSphereTransactionInternal tx, GraphTraversal<S, Vertex> traversal) {
        ChronoEPackageRegistry registry = tx.getEPackageRegistry();
        return traversal.flatMap(this.eGetByEAttribute(this.eAttribute, registry));
    }

    private <E2> Function<Traverser<Vertex>, Iterator<E2>> eGetByEAttribute(EAttribute eAttribute, ChronoEPackageRegistry registry) {
        return traverser -> {
            String key;
            if (traverser == null || traverser.get() == null) {
                return Collections.emptyIterator();
            }
            Vertex vertex = (Vertex)traverser.get();
            Object value = vertex.property(key = ChronoSphereGraphFormat.createVertexPropertyKey(registry, eAttribute)).orElse(null);
            if (value == null) {
                return Collections.emptyIterator();
            }
            if (value instanceof Collection) {
                return ((Collection)value).iterator();
            }
            return Iterators.singletonIterator((Object)value);
        };
    }
}

