/*
 * Decompiled with CFR 0.152.
 */
package org.chronos.chronosphere.impl.query.steps.object;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.chronos.chronosphere.api.ChronoSphereTransaction;
import org.chronos.chronosphere.impl.query.ObjectQueryStepBuilderImpl;
import org.chronos.chronosphere.impl.query.QueryUtils;
import org.chronos.chronosphere.impl.query.traversal.TraversalChainElement;
import org.chronos.chronosphere.internal.api.ChronoSphereTransactionInternal;
import org.chronos.chronosphere.internal.ogm.api.ChronoEPackageRegistry;
import org.chronos.chronosphere.internal.ogm.api.ChronoSphereGraphFormat;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;

public class ObjectQueryEGetByNameStepBuilder<S>
extends ObjectQueryStepBuilderImpl<S, Vertex, Object> {
    private final String eStructuralFeatureName;

    public ObjectQueryEGetByNameStepBuilder(TraversalChainElement previous, String eStructuralFeatureName) {
        super(previous);
        Preconditions.checkNotNull((Object)eStructuralFeatureName, (Object)"Precondition violation - argument 'eStructuralFeatureName' must not be NULL!");
        this.eStructuralFeatureName = eStructuralFeatureName;
    }

    @Override
    public GraphTraversal<S, Object> transformTraversal(ChronoSphereTransactionInternal tx, GraphTraversal<S, Vertex> traversal) {
        return traversal.flatMap(this.eGetByName(this.eStructuralFeatureName, tx));
    }

    private <E2> Function<Traverser<Vertex>, Iterator<E2>> eGetByName(String eStructuralFeatureName, ChronoSphereTransactionInternal tx) {
        return traverser -> {
            if (traverser == null || traverser.get() == null) {
                return Collections.emptyIterator();
            }
            Vertex vertex = (Vertex)traverser.get();
            String eClassID = (String)vertex.property("eClass").orElse(null);
            if (eClassID == null) {
                return Collections.emptyIterator();
            }
            ChronoEPackageRegistry registry = tx.getEPackageRegistry();
            EClass eClass = registry.getEClassByID(eClassID);
            if (eClass == null) {
                return Collections.emptyIterator();
            }
            EStructuralFeature feature = eClass.getEStructuralFeature(eStructuralFeatureName);
            if (feature == null) {
                return Collections.emptyIterator();
            }
            if (feature instanceof EAttribute) {
                EAttribute eAttribute = (EAttribute)feature;
                String key = ChronoSphereGraphFormat.createVertexPropertyKey(registry, eAttribute);
                Object value = vertex.property(key).orElse(null);
                if (value == null) {
                    return Collections.emptyIterator();
                }
                if (value instanceof Collection) {
                    return ((Collection)value).iterator();
                }
                return Iterators.singletonIterator((Object)value);
            }
            if (feature instanceof EReference) {
                EReference eReference = (EReference)feature;
                String label = ChronoSphereGraphFormat.createReferenceEdgeLabel(registry, eReference);
                Iterator targets = vertex.vertices(Direction.OUT, new String[]{label});
                Iterator eObjectIterator = Iterators.transform((Iterator)targets, v -> QueryUtils.mapVertexToEObject((ChronoSphereTransaction)tx, v));
                return eObjectIterator;
            }
            throw new IllegalStateException("Unknown subclass of EStructuralFeature: " + feature.getClass().getName());
        };
    }
}

