/*
 * Decompiled with CFR 0.152.
 */
package org.chronos.chronosphere.impl.query.steps.object;

import com.google.common.base.Preconditions;
import java.util.function.Predicate;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.chronos.chronosphere.impl.query.ObjectQueryStepBuilderImpl;
import org.chronos.chronosphere.impl.query.traversal.TraversalChainElement;
import org.chronos.chronosphere.internal.api.ChronoSphereTransactionInternal;

public class ObjectQueryFilterStepBuilder<S, E>
extends ObjectQueryStepBuilderImpl<S, E, E> {
    private final Predicate<E> predicate;

    public ObjectQueryFilterStepBuilder(TraversalChainElement previous, Predicate<E> predicate) {
        super(previous);
        Preconditions.checkNotNull(predicate, (Object)"Precondition violation - argument 'predicate' must not be NULL!");
        this.predicate = predicate;
    }

    @Override
    public GraphTraversal<S, E> transformTraversal(ChronoSphereTransactionInternal tx, GraphTraversal<S, E> traversal) {
        return traversal.filter(traverser -> {
            Object object = traverser.get();
            return this.predicate.test(object);
        });
    }
}

