/*
 * Decompiled with CFR 0.152.
 */
package org.chronos.chronosphere.impl.transaction;

import com.google.common.base.Preconditions;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.chronos.chronodb.internal.util.IteratorUtils;
import org.chronos.chronograph.api.structure.ChronoGraph;
import org.chronos.chronograph.api.transaction.ChronoGraphTransaction;
import org.chronos.chronosphere.api.SphereBranch;
import org.chronos.chronosphere.api.query.QueryStepBuilderStarter;
import org.chronos.chronosphere.emf.api.ChronoEObject;
import org.chronos.chronosphere.emf.impl.ChronoEFactory;
import org.chronos.chronosphere.emf.impl.ChronoEObjectImpl;
import org.chronos.chronosphere.emf.internal.api.ChronoEObjectInternal;
import org.chronos.chronosphere.emf.internal.impl.store.ChronoGraphEStore;
import org.chronos.chronosphere.emf.internal.util.EMFUtils;
import org.chronos.chronosphere.impl.query.QueryStepBuilderStarterImpl;
import org.chronos.chronosphere.internal.api.ChronoSphereInternal;
import org.chronos.chronosphere.internal.api.ChronoSphereTransactionInternal;
import org.chronos.chronosphere.internal.ogm.api.ChronoEPackageRegistry;
import org.chronos.chronosphere.internal.ogm.api.ChronoSphereGraphFormat;
import org.chronos.chronosphere.internal.ogm.api.VertexKind;
import org.chronos.common.util.CacheUtils;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class ChronoSphereTransactionImpl
implements ChronoSphereTransactionInternal {
    private ChronoEPackageRegistry ePackageRegistry;
    private final ChronoSphereInternal owningSphere;
    private final ChronoGraph txGraph;
    private final ChronoGraphTransaction tx;
    private final ChronoGraphEStore graphEStore;
    private boolean closed;
    private final LoadingCache<String, ChronoEObject> eObjectCache;

    public ChronoSphereTransactionImpl(ChronoSphereInternal owningSphere, ChronoGraph txGraph) {
        Preconditions.checkNotNull((Object)owningSphere, (Object)"Precondition violation - argument 'owningSphere' must not be NULL!");
        Preconditions.checkNotNull((Object)txGraph, (Object)"Precondition violation - argument 'txGraph' must not be NULL!");
        this.owningSphere = owningSphere;
        this.txGraph = txGraph;
        this.tx = txGraph.tx().getCurrentTransaction();
        this.eObjectCache = CacheUtils.buildWeak(this::loadEObjectById);
        this.ePackageRegistry = this.owningSphere.getEPackageToGraphMapper().readChronoEPackageRegistryFromGraph(txGraph);
        this.graphEStore = new ChronoGraphEStore(this);
    }

    @Override
    public long getTimestamp() {
        return this.tx.getTimestamp();
    }

    @Override
    public SphereBranch getBranch() {
        return this.owningSphere.getBranchManager().getBranch(this.tx.getBranchName());
    }

    @Override
    public EObject createAndAttach(EClass eClass) {
        Preconditions.checkArgument((this.getEPackageRegistry().getEClassID(eClass) != null ? 1 : 0) != 0, (Object)"Precondition violation - the given EClass is not known in the repository!");
        Preconditions.checkArgument((boolean)(eClass.getEPackage().getEFactoryInstance() instanceof ChronoEFactory), (Object)"Precondition violation - the given EClass is not known in the repository!");
        EObject eObject = EcoreUtil.create((EClass)eClass);
        this.attach(eObject);
        return eObject;
    }

    @Override
    public EObject createAndAttach(EClass eClass, String eObjectID) {
        Preconditions.checkArgument((this.getEPackageRegistry().getEClassID(eClass) != null ? 1 : 0) != 0, (Object)"Precondition violation - the given EClass is not known in the repository!");
        Preconditions.checkArgument((boolean)(eClass.getEPackage().getEFactoryInstance() instanceof ChronoEFactory), (Object)"Precondition violation - the given EClass is not known in the repository!");
        Preconditions.checkNotNull((Object)eObjectID, (Object)"Precondition violation - argument 'eObjectID' must not be NULL!");
        ChronoEObjectImpl eObject = new ChronoEObjectImpl(eObjectID, eClass);
        this.attach((EObject)eObject);
        return eObject;
    }

    @Override
    public void attach(EObject eObject) {
        ChronoEObjectInternal eObjectInternal = this.assertIsChronoEObject(eObject);
        if (eObjectInternal.isAttached()) {
            return;
        }
        this.attach(Collections.singleton(eObject));
    }

    @Override
    public void attach(Iterable<? extends EObject> eObjects) {
        Preconditions.checkNotNull(eObjects, (Object)"Precondition violation - argument 'eObjects' must not be NULL!");
        this.attach(eObjects.iterator());
    }

    @Override
    public void attach(Iterator<? extends EObject> eObjects) {
        Preconditions.checkNotNull(eObjects, (Object)"Precondition violation - argument 'eObjects' must not be NULL!");
        this.attach(eObjects, false);
    }

    @Override
    public void delete(EObject eObject) {
        Preconditions.checkNotNull((Object)eObject, (Object)"Precondition violation - argument 'eObject' must not be NULL!");
        this.delete(Collections.singleton(eObject));
    }

    @Override
    public void delete(Iterator<? extends EObject> eObjects, boolean cascadeDeletionToEContents) {
        Preconditions.checkNotNull(eObjects, (Object)"Precondition violation - argument 'eObjects' must not be NULL!");
        if (!eObjects.hasNext()) {
            return;
        }
        Set<ChronoEObjectInternal> eObjectsToDelete = IteratorUtils.stream(eObjects).filter(eObject -> eObject instanceof ChronoEObjectInternal).map(eObject -> (ChronoEObjectInternal)eObject).filter(eObject -> eObject.isAttached()).collect(Collectors.toSet());
        if (eObjectsToDelete.isEmpty()) {
            return;
        }
        Set idsToInvalidate = eObjectsToDelete.stream().map(ChronoEObject::getId).collect(Collectors.toSet());
        this.getGraphEStore().deepDelete(eObjectsToDelete, cascadeDeletionToEContents);
        this.eObjectCache.invalidateAll(idsToInvalidate);
    }

    @Override
    public EPackage getEPackageByNsURI(String namespaceURI) {
        Preconditions.checkNotNull((Object)namespaceURI, (Object)"Precondition violation - argument 'namespaceURI' must not be NULL!");
        this.assertNotClosed();
        return this.getEPackageRegistry().getEPackage(namespaceURI);
    }

    @Override
    public Set<EPackage> getEPackages() {
        this.assertNotClosed();
        return Collections.unmodifiableSet(this.getEPackageRegistry().getEPackages());
    }

    @Override
    public EPackage getEPackageByQualifiedName(String qualifiedName) {
        Preconditions.checkNotNull((Object)qualifiedName, (Object)"Precondition violation - argument 'qualifiedName' must not be NULL!");
        return EMFUtils.getEPackageByQualifiedName(this.getEPackages(), qualifiedName);
    }

    @Override
    public EClassifier getEClassifierByQualifiedName(String qualifiedName) {
        Preconditions.checkNotNull((Object)qualifiedName, (Object)"Precondition violation - argument 'qualifiedName' must not be NULL!");
        return EMFUtils.getEClassifierByQualifiedName(this.getEPackages(), qualifiedName);
    }

    @Override
    public EClass getEClassByQualifiedName(String qualifiedName) {
        Preconditions.checkNotNull((Object)qualifiedName, (Object)"Precondition violation - argument 'qualifiedName' must not be NULL!");
        return EMFUtils.getEClassByQualifiedName(this.getEPackages(), qualifiedName);
    }

    @Override
    public EStructuralFeature getFeatureByQualifiedName(String qualifiedName) {
        Preconditions.checkNotNull((Object)qualifiedName, (Object)"Precondition violation - argument 'qualifiedName' must not be NULL!");
        return EMFUtils.getFeatureByQualifiedName(this.getEPackages(), qualifiedName);
    }

    @Override
    public EAttribute getEAttributeByQualifiedName(String qualifiedName) {
        Preconditions.checkNotNull((Object)qualifiedName, (Object)"Precondition violation - argument 'qualifiedName' must not be NULL!");
        return EMFUtils.getEAttributeByQualifiedName(this.getEPackages(), qualifiedName);
    }

    @Override
    public EReference getEReferenceByQualifiedName(String qualifiedName) {
        Preconditions.checkNotNull((Object)qualifiedName, (Object)"Precondition violation - argument 'qualifiedName' must not be NULL!");
        return EMFUtils.getEReferenceByQualifiedName(this.getEPackages(), qualifiedName);
    }

    @Override
    public EPackage getEPackageBySimpleName(String simpleName) {
        Preconditions.checkNotNull((Object)simpleName, (Object)"Precondition violation - argument 'simpleName' must not be NULL!");
        return EMFUtils.getEPackageBySimpleName(this.getEPackages(), simpleName);
    }

    @Override
    public EClassifier getEClassifierBySimpleName(String simpleName) {
        Preconditions.checkNotNull((Object)simpleName, (Object)"Precondition violation - argument 'simpleName' must not be NULL!");
        return EMFUtils.getEClassifierBySimpleName(this.getEPackages(), simpleName);
    }

    @Override
    public EClass getEClassBySimpleName(String simpleName) {
        Preconditions.checkNotNull((Object)simpleName, (Object)"Precondition violation - argument 'simpleName' must not be NULL!");
        return EMFUtils.getEClassBySimpleName(this.getEPackages(), simpleName);
    }

    @Override
    public ChronoEObject getEObjectById(String eObjectID) {
        Preconditions.checkNotNull((Object)eObjectID, (Object)"Precondition violation - argument 'eObjectID' must not be NULL!");
        try {
            return (ChronoEObject)this.eObjectCache.get((Object)eObjectID);
        }
        catch (ExecutionException e) {
            throw new RuntimeException("Failed to load EObject with ID '" + eObjectID + "'!", e);
        }
    }

    @Override
    public Map<String, ChronoEObject> getEObjectById(Iterable<String> eObjectIDs) {
        Preconditions.checkNotNull(eObjectIDs, (Object)"Precondition violation - argument 'eObjectIDs' must not be NULL!");
        return this.getEObjectById(eObjectIDs.iterator());
    }

    @Override
    public Map<String, ChronoEObject> getEObjectById(Iterator<String> eObjectIDs) {
        Preconditions.checkNotNull(eObjectIDs, (Object)"Precondition violation - argument 'eObjectIDs' must not be NULL!");
        HashMap resultMap = Maps.newHashMap();
        eObjectIDs.forEachRemaining(id -> {
            ChronoEObject eObject = this.getEObjectById((String)id);
            resultMap.put(id, eObject);
        });
        return resultMap;
    }

    @Override
    public QueryStepBuilderStarter find() {
        return new QueryStepBuilderStarterImpl(this);
    }

    @Override
    public Iterator<Long> getEObjectHistory(EObject eObject) {
        Preconditions.checkNotNull((Object)eObject, (Object)"Precondition violation - argument 'eObject' must not be NULL!");
        if (!(eObject instanceof ChronoEObjectInternal)) {
            return Collections.emptyIterator();
        }
        ChronoEObjectInternal eObjectInternal = (ChronoEObjectInternal)eObject;
        String id = eObjectInternal.getId();
        return this.txGraph.getVertexHistory((Object)id);
    }

    @Override
    public Iterator<Pair<Long, String>> getEObjectModificationsBetween(long timestampLowerBound, long timestampUpperBound) {
        Preconditions.checkArgument((timestampLowerBound >= 0L ? 1 : 0) != 0, (Object)"Precondition violation - argument 'timestampLowerBound' must not be negative!");
        Preconditions.checkArgument((timestampUpperBound >= 0L ? 1 : 0) != 0, (Object)"Precondition violation - argument 'timestampUpperBound' must not be negative!");
        Preconditions.checkArgument((timestampLowerBound < timestampUpperBound ? 1 : 0) != 0, (Object)"Precondition violation - argument 'timestampLowerBound' must be strictly smaller than argument 'timestampUpperBound'!");
        return this.txGraph.getVertexModificationsBetween(timestampLowerBound, timestampUpperBound);
    }

    @Override
    public void commit() {
        this.assertNotClosed();
        this.tx.commit();
        this.eObjectCache.invalidateAll();
        this.closed = true;
    }

    @Override
    public void commit(Object commitMetadata) {
        this.assertNotClosed();
        this.tx.commit(commitMetadata);
        this.eObjectCache.invalidateAll();
        this.closed = true;
    }

    @Override
    public void commitIncremental() {
        this.assertNotClosed();
        this.eObjectCache.invalidateAll();
        this.tx.commitIncremental();
    }

    @Override
    public void rollback() {
        this.assertNotClosed();
        this.tx.rollback();
        this.eObjectCache.invalidateAll();
        this.closed = true;
    }

    @Override
    public boolean isClosed() {
        return this.closed || !this.tx.isOpen();
    }

    @Override
    public boolean isOpen() {
        return !this.isClosed();
    }

    @Override
    public void close() {
        if (this.isClosed()) {
            return;
        }
        this.rollback();
        this.txGraph.close();
        this.closed = true;
    }

    @Override
    public ChronoSphereInternal getOwningSphere() {
        return this.owningSphere;
    }

    @Override
    public ChronoGraph getGraph() {
        return this.txGraph;
    }

    @Override
    public ChronoGraphEStore getGraphEStore() {
        return this.graphEStore;
    }

    @Override
    public ChronoEPackageRegistry getEPackageRegistry() {
        this.assertNotClosed();
        return this.ePackageRegistry;
    }

    @Override
    public void batchInsert(Iterator<EObject> model) {
        Preconditions.checkNotNull(model, (Object)"Precondition violation - argument 'model' must not be NULL!");
        this.attach(model, true);
    }

    @Override
    public void reloadEPackageRegistryFromGraph() {
        this.ePackageRegistry = this.owningSphere.getEPackageToGraphMapper().readChronoEPackageRegistryFromGraph(this.txGraph);
    }

    private void assertNotClosed() {
        if (this.isClosed()) {
            throw new IllegalStateException("This ChronoSphereTransaction was already closed!");
        }
    }

    private ChronoEObjectInternal assertIsChronoEObject(EObject eObject) {
        Preconditions.checkNotNull((Object)eObject, (Object)"Precondition violation - argument 'eObject' must not be NULL!");
        Preconditions.checkArgument((boolean)(eObject instanceof ChronoEObject), (Object)"Precondition violation - argument 'eObject' is no ChronoEObject! Did you use the correct EFactory in your EPackage?");
        return (ChronoEObjectInternal)eObject;
    }

    private ChronoEObject createEObjectFromVertex(Vertex vertex) {
        Preconditions.checkNotNull((Object)vertex, (Object)"Precondition violation - argument 'vertex' must not be NULL!");
        Preconditions.checkArgument((boolean)VertexKind.EOBJECT.equals((Object)ChronoSphereGraphFormat.getVertexKind(vertex)), (Object)"Precondition violation - the given vertex does not represent an EObject!");
        EClass eClass = ChronoSphereGraphFormat.getEClassForEObjectVertex(this.getEPackageRegistry(), vertex);
        return new ChronoEObjectImpl((String)vertex.id(), eClass, this.getGraphEStore());
    }

    private void attach(Iterator<? extends EObject> eObjects, boolean useIncrementalCommits) {
        Preconditions.checkNotNull(eObjects, (Object)"Precondition violation - argument 'eObjects' must not be NULL!");
        ArrayList mergeObjects = Lists.newArrayList();
        eObjects.forEachRemaining(eObject -> {
            ChronoEObjectInternal eObjectInternal = this.assertIsChronoEObject((EObject)eObject);
            if (eObjectInternal.isAttached()) {
                return;
            }
            mergeObjects.add(eObjectInternal);
        });
        if (useIncrementalCommits) {
            int batchSize = this.getOwningSphere().getConfiguration().getBatchInsertBatchSize();
            this.getGraphEStore().deepMergeIncremental(mergeObjects, this, batchSize);
        } else {
            this.getGraphEStore().deepMerge(mergeObjects);
        }
    }

    private ChronoEObject loadEObjectById(String eObjectID) {
        Vertex vertex = ChronoSphereGraphFormat.getVertexForEObject(this.getGraph(), eObjectID);
        if (vertex == null) {
            return null;
        }
        return this.createEObjectFromVertex(vertex);
    }
}

