/*
 * Decompiled with CFR 0.152.
 */
package org.chronos.chronosphere.internal.builder.repository.impl;

import com.google.common.base.Preconditions;
import java.io.File;
import java.util.Properties;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.MapConfiguration;
import org.chronos.chronosphere.api.builder.repository.ChronoSphereBaseBuilder;
import org.chronos.chronosphere.api.builder.repository.ChronoSphereInMemoryBuilder;
import org.chronos.chronosphere.api.builder.repository.ChronoSpherePropertyFileBuilder;
import org.chronos.chronosphere.internal.builder.repository.impl.AbstractChronoSphereBuilder;
import org.chronos.chronosphere.internal.builder.repository.impl.ChronoSphereInMemoryBuilderImpl;
import org.chronos.chronosphere.internal.builder.repository.impl.ChronoSpherePropertyFileBuilderImpl;

public class ChronoSphereBaseBuilderImpl
extends AbstractChronoSphereBuilder<ChronoSphereBaseBuilderImpl>
implements ChronoSphereBaseBuilder {
    @Override
    public ChronoSphereInMemoryBuilder inMemoryRepository() {
        return new ChronoSphereInMemoryBuilderImpl();
    }

    @Override
    public ChronoSpherePropertyFileBuilder fromPropertiesFile(File file) {
        Preconditions.checkNotNull((Object)file, (Object)"Precondition violation - argument 'file' must not be NULL!");
        Preconditions.checkArgument((boolean)file.exists(), (Object)"Precondition violation - argument 'file' must refer to an existing file!");
        Preconditions.checkArgument((boolean)file.isFile(), (Object)"Precondition violation - argument 'file' must refer to a file (not a directory)!");
        return new ChronoSpherePropertyFileBuilderImpl(file);
    }

    @Override
    public ChronoSpherePropertyFileBuilder fromPropertiesFile(String filePath) {
        Preconditions.checkNotNull((Object)filePath, (Object)"Precondition violation - argument 'filePath' must not be NULL!");
        File file = new File(filePath);
        return this.fromPropertiesFile(file);
    }

    @Override
    public ChronoSpherePropertyFileBuilder fromConfiguration(Configuration configuration) {
        Preconditions.checkNotNull((Object)configuration, (Object)"Precondition violation - argument 'configuration' must not be NULL!");
        return new ChronoSpherePropertyFileBuilderImpl(configuration);
    }

    @Override
    public ChronoSpherePropertyFileBuilder fromProperties(Properties properties) {
        Preconditions.checkNotNull((Object)properties, (Object)"Precondition violation - argument 'properties' must not be NULL!");
        MapConfiguration configuration = new MapConfiguration(properties);
        return this.fromConfiguration((Configuration)configuration);
    }
}

