/*
 * Decompiled with CFR 0.152.
 */
package org.chronos.chronosphere.internal.builder.repository.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.chronos.chronosphere.api.builder.repository.ChronoSpherePropertyFileBuilder;
import org.chronos.chronosphere.api.exceptions.ChronoSphereConfigurationException;
import org.chronos.chronosphere.internal.builder.repository.impl.AbstractChronoSphereFinalizableBuilder;

public class ChronoSpherePropertyFileBuilderImpl
extends AbstractChronoSphereFinalizableBuilder<ChronoSpherePropertyFileBuilder>
implements ChronoSpherePropertyFileBuilder {
    public ChronoSpherePropertyFileBuilderImpl(File propertiesFile) {
        Preconditions.checkNotNull((Object)propertiesFile, (Object)"Precondition violation - argument 'propertiesFile' must not be NULL!");
        Preconditions.checkArgument((boolean)propertiesFile.exists(), (Object)"Precondition violation - argument 'propertiesFile' must refer to an existing file!");
        Preconditions.checkArgument((boolean)propertiesFile.isFile(), (Object)"Precondition violation - argument 'propertiesFile' must refer to a file (not a directory)!");
        try {
            PropertiesConfiguration configuration = new PropertiesConfiguration(propertiesFile);
            this.applyConfiguration((Configuration)configuration);
        }
        catch (ConfigurationException e) {
            throw new ChronoSphereConfigurationException("Failed to read properties file '" + propertiesFile.getAbsolutePath() + "'!", e);
        }
    }

    public ChronoSpherePropertyFileBuilderImpl(Configuration configuration) {
        Preconditions.checkNotNull((Object)configuration, (Object)"Precondition violation - argument 'configuration' must not be NULL!");
        try {
            this.applyConfiguration(configuration);
        }
        catch (Exception e) {
            throw new ChronoSphereConfigurationException("Failed to apply the given configuration'!", e);
        }
    }

    private void applyConfiguration(Configuration configuration) {
        HashSet keys = Sets.newHashSet((Iterator)configuration.getKeys());
        for (String key : keys) {
            this.withProperty(key, configuration.getProperty(key).toString());
        }
    }
}

