/*
 * Decompiled with CFR 0.152.
 */
package org.chronos.chronosphere.internal.ogm.api;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.chronos.chronograph.api.structure.ChronoGraph;
import org.chronos.chronosphere.api.exceptions.EObjectPersistenceException;
import org.chronos.chronosphere.api.exceptions.StorageBackendCorruptedException;
import org.chronos.chronosphere.emf.api.ChronoEObject;
import org.chronos.chronosphere.emf.internal.util.EMFUtils;
import org.chronos.chronosphere.internal.ogm.api.ChronoEPackageRegistry;
import org.chronos.chronosphere.internal.ogm.api.EPackageBundle;
import org.chronos.chronosphere.internal.ogm.api.VertexKind;
import org.chronos.chronosphere.internal.ogm.impl.GremlinUtils;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;

public class ChronoSphereGraphFormat {
    public static final String V_PROP__KIND = "kind";
    public static final String V_PROP__ECLASS_ID = "eClass";
    public static final String V_PROP_PREFIX__EATTRIBUTE_VALUE = "eAttr_";
    public static final String V_PROP__NS_URI = "nsURI";
    public static final String V_PROP__NS_PREFIX = "nsPrefix";
    public static final String V_PROP__NAME = "name";
    public static final String V_PROP__XMI_CONTENTS = "xmiContents";
    public static final String V_PROP__ECONTAININGFEATUREID = "eContainingFeatureID";
    public static final String E_LABEL__EPACKAGE_REGISTRY_OWNED_BUNDLE = "ownedBundle";
    public static final String E_LABEL__BUNDLE_OWNED_EPACKAGE = "ownedEPackage";
    public static final String E_LABEL__ECONTAINER = "eContainer";
    public static final String E_LABEL__EPACKAGE_OWNED_CLASSIFIERS = "classifier";
    public static final String E_LABEL__ECLASS_OWNED_EATTRIBUTE = "eAttribute";
    public static final String E_LABEL__ECLASS_OWNED_EREFERENCE = "eReference";
    public static final String E_LABEL__ECLASS_ESUPERTYPE = "eSuperType";
    public static final String E_LABEL__ESUBPACKAGE = "eSubPackage";
    public static final String E_LABEL_PREFIX__EREFERENCE = "eRef_";
    public static final String E_PROP__ORDER = "eRefOrder";
    public static final String V_ID__EPACKAGE_REGISTRY = "EPackageRegistry_ca68f96b-676c-49de-a260-ac6628a7c455";
    public static final String VARIABLES__GRAPH_FORMAT_VERSION = "chronosphere.graphformat.version";

    private ChronoSphereGraphFormat() {
        throw new UnsupportedOperationException("Do not instantiate this class!");
    }

    public static VertexKind getVertexKind(Vertex vertex) {
        Preconditions.checkNotNull((Object)vertex, (Object)"Precondition violation - argument 'vertex' must not be NULL!");
        String vertexKind = (String)vertex.property(V_PROP__KIND).orElse(null);
        return VertexKind.fromString(vertexKind);
    }

    public static void setVertexKind(Vertex vertex, VertexKind kind) {
        Preconditions.checkNotNull((Object)vertex, (Object)"Precondition violation - argument 'vertex' must not be NULL!");
        Preconditions.checkNotNull((Object)((Object)kind), (Object)"Precondition violation - argument 'kind' must not be NULL!");
        vertex.property(V_PROP__KIND, (Object)kind.toString());
    }

    public static String createVertexPropertyKey(ChronoEPackageRegistry registry, EAttribute eAttribute) {
        Preconditions.checkNotNull((Object)registry, (Object)"Precondition violation - argument 'registry' must not be NULL!");
        Preconditions.checkNotNull((Object)eAttribute, (Object)"Precondition violation - argument 'eAttribute' must not be NULL!");
        String featureID = registry.getEAttributeID(eAttribute);
        if (featureID == null) {
            throw new IllegalStateException("Could not generate Vertex Property Key for EAttribute '" + eAttribute.getName() + "'! Did you forget to register or update an EPackage?");
        }
        return V_PROP_PREFIX__EATTRIBUTE_VALUE + featureID;
    }

    public static String createReferenceEdgeLabel(ChronoEPackageRegistry registry, EReference eReference) {
        Preconditions.checkNotNull((Object)registry, (Object)"Precondition violation - argument 'registry' must not be NULL!");
        Preconditions.checkNotNull((Object)eReference, (Object)"Precondition violation - argument 'eReference' must not be NULL!");
        String eReferenceID = registry.getEReferenceID(eReference);
        if (eReferenceID == null) {
            throw new IllegalStateException("Could not generate Edge Label for EReference '" + eReference.getName() + "'! Did you forget to register or update an EPackage?");
        }
        return E_LABEL_PREFIX__EREFERENCE + eReferenceID;
    }

    public static String createEContainerReferenceEdgeLabel() {
        return E_LABEL__ECONTAINER;
    }

    public static Property<?> setEAttributeValues(ChronoEPackageRegistry registry, Vertex vertex, EAttribute attribute, Collection<?> values) {
        Preconditions.checkNotNull((Object)registry, (Object)"Precondition violation - argument 'registry' must not be NULL!");
        Preconditions.checkNotNull((Object)vertex, (Object)"Precondition violation - argument 'vertex' must not be NULL!");
        Preconditions.checkNotNull((Object)attribute, (Object)"Precondition violation - argument 'attribute' must not be NULL!");
        Preconditions.checkArgument((boolean)attribute.isMany(), (Object)"Precondition violation - argument 'attribute' is multiplicity-one!");
        String propertyKey = ChronoSphereGraphFormat.createVertexPropertyKey(registry, attribute);
        if (values == null || values.isEmpty()) {
            vertex.property(propertyKey).remove();
            return null;
        }
        Collection valueToStore = Lists.newArrayList(values).stream().map(value -> ChronoSphereGraphFormat.convertSingleEAttributeValueToPersistableObject(attribute, value)).collect(Collectors.toList());
        vertex.property(propertyKey, (Object)valueToStore);
        return vertex.property(propertyKey);
    }

    public static Collection<?> getEAttributeValues(ChronoEPackageRegistry registry, Vertex vertex, EAttribute attribute) {
        Preconditions.checkNotNull((Object)registry, (Object)"Precondition violation - argument 'registry' must not be NULL!");
        Preconditions.checkNotNull((Object)vertex, (Object)"Precondition violation - argument 'vertex' must not be NULL!");
        Preconditions.checkNotNull((Object)attribute, (Object)"Precondition violation - argument 'attribute' must not be NULL!");
        Preconditions.checkArgument((boolean)attribute.isMany(), (Object)"Precondition violation - argument 'attribute' is multiplicity-one!");
        String propertyKey = ChronoSphereGraphFormat.createVertexPropertyKey(registry, attribute);
        Collection storedValue = (Collection)vertex.property(propertyKey).orElse((Object)Lists.newArrayList());
        List resultList = storedValue.stream().map(value -> ChronoSphereGraphFormat.convertSinglePersistableObjectToEAttributeValue(attribute, attribute)).collect(Collectors.toList());
        return Collections.unmodifiableCollection(resultList);
    }

    public static Property<?> setEAttributeValue(ChronoEPackageRegistry registry, Vertex vertex, EAttribute attribute, Object value) {
        Preconditions.checkNotNull((Object)registry, (Object)"Precondition violation - argument 'registry' must not be NULL!");
        Preconditions.checkNotNull((Object)vertex, (Object)"Precondition violation - argument 'vertex' must not be NULL!");
        Preconditions.checkNotNull((Object)attribute, (Object)"Precondition violation - argument 'attribute' must not be NULL!");
        Preconditions.checkArgument((!attribute.isMany() ? 1 : 0) != 0, (Object)"Precondition violation - argument 'attribute' is multiplicity-many!");
        String propertyKey = ChronoSphereGraphFormat.createVertexPropertyKey(registry, attribute);
        if (value != null) {
            Object persistentValue = ChronoSphereGraphFormat.convertSingleEAttributeValueToPersistableObject(attribute, value);
            vertex.property(propertyKey, persistentValue);
            return vertex.property(propertyKey);
        }
        vertex.property(propertyKey).remove();
        return null;
    }

    public static Object getEAttributeValue(ChronoEPackageRegistry registry, Vertex vertex, EAttribute attribute) {
        Preconditions.checkNotNull((Object)registry, (Object)"Precondition violation - argument 'registry' must not be NULL!");
        Preconditions.checkNotNull((Object)vertex, (Object)"Precondition violation - argument 'vertex' must not be NULL!");
        Preconditions.checkNotNull((Object)attribute, (Object)"Precondition violation - argument 'attribute' must not be NULL!");
        Preconditions.checkArgument((!attribute.isMany() ? 1 : 0) != 0, (Object)"Precondition violation - argument 'attribute' is multiplicity-many!");
        String propertyKey = ChronoSphereGraphFormat.createVertexPropertyKey(registry, attribute);
        Object persistentValue = vertex.property(propertyKey).orElse(null);
        return ChronoSphereGraphFormat.convertSinglePersistableObjectToEAttributeValue(attribute, persistentValue);
    }

    public static void setEReferenceEdgeOrder(Edge edge, int orderIndex) {
        Preconditions.checkNotNull((Object)edge, (Object)"Precondition violation - argument 'edge' must not be NULL!");
        Preconditions.checkArgument((orderIndex >= 0 ? 1 : 0) != 0, (Object)"Precondition violation - argument 'orderIndex' must not be negative!");
        edge.property(E_PROP__ORDER, (Object)orderIndex);
    }

    public static int getEReferenceEdgeOrder(Edge edge) {
        Preconditions.checkNotNull((Object)edge, (Object)"Precondition violation - argument 'edge' must not be NULL!");
        return (Integer)edge.property(E_PROP__ORDER).orElse((Object)-1);
    }

    public static Vertex getEReferenceTarget(ChronoEPackageRegistry registry, Vertex eObjectVertex, EReference eReference) {
        Preconditions.checkNotNull((Object)registry, (Object)"Precondition violation - argument 'registry' must not be NULL!");
        Preconditions.checkNotNull((Object)eObjectVertex, (Object)"Precondition violation - argument 'eObjectVertex' must not be NULL!");
        Preconditions.checkNotNull((Object)eReference, (Object)"Precondition violation - argument 'eReference' must not be NULL!");
        Preconditions.checkArgument((!eReference.isMany() ? 1 : 0) != 0, (Object)"Precondition violation - argument 'eReference' must not be many-valued!");
        String edgeLabel = ChronoSphereGraphFormat.createReferenceEdgeLabel(registry, eReference);
        Iterator targets = eObjectVertex.vertices(Direction.OUT, new String[]{edgeLabel});
        if (!targets.hasNext()) {
            return null;
        }
        Vertex target = (Vertex)targets.next();
        if (targets.hasNext()) {
            throw new IllegalStateException("Found multiple targets for EObject '" + eObjectVertex.id() + "#" + eReference.getName() + " (multiplicity one)!");
        }
        return target;
    }

    public static List<Vertex> getEReferenceTargets(ChronoEPackageRegistry registry, Vertex eObjectVertex, EReference eReference) {
        Preconditions.checkNotNull((Object)registry, (Object)"Precondition violation - argument 'registry' must not be NULL!");
        Preconditions.checkNotNull((Object)eObjectVertex, (Object)"Precondition violation - argument 'eObjectVertex' must not be NULL!");
        Preconditions.checkNotNull((Object)eReference, (Object)"Precondition violation - argument 'eReference' must not be NULL!");
        Preconditions.checkArgument((boolean)eReference.isMany(), (Object)"Precondition violation - argument 'eReference' must be many-valued!");
        String edgeLabel = ChronoSphereGraphFormat.createReferenceEdgeLabel(registry, eReference);
        if (eReference.isOrdered()) {
            ArrayList edges = Lists.newArrayList((Iterator)eObjectVertex.edges(Direction.OUT, new String[]{edgeLabel}));
            edges.sort((e1, e2) -> {
                int order1 = ChronoSphereGraphFormat.getEReferenceEdgeOrder(e1);
                int order2 = ChronoSphereGraphFormat.getEReferenceEdgeOrder(e2);
                return Integer.compare(order1, order2);
            });
            return edges.stream().map(edge -> edge.inVertex()).collect(Collectors.toList());
        }
        return Lists.newArrayList((Iterator)eObjectVertex.vertices(Direction.OUT, new String[]{edgeLabel}));
    }

    public static void setEReferenceTarget(ChronoEPackageRegistry registry, Vertex eObjectVertex, EReference eReference, Vertex target) {
        Preconditions.checkNotNull((Object)registry, (Object)"Precondition violation - argument 'registry' must not be NULL!");
        Preconditions.checkNotNull((Object)eObjectVertex, (Object)"Precondition violation - argument 'eObjectVertex' must not be NULL!");
        Preconditions.checkNotNull((Object)eReference, (Object)"Precondition violation - argument 'eReference' must not be NULL!");
        Preconditions.checkArgument((!eReference.isMany() ? 1 : 0) != 0, (Object)"Precondition violation - argument 'eReference' must not be many-valued!");
        String edgeLabel = ChronoSphereGraphFormat.createReferenceEdgeLabel(registry, eReference);
        if (target == null) {
            eObjectVertex.edges(Direction.OUT, new String[]{edgeLabel}).forEachRemaining(Element::remove);
        } else {
            GremlinUtils.setEdgeTarget(eObjectVertex, edgeLabel, target);
        }
    }

    public static void setEReferenceTargets(ChronoEPackageRegistry registry, Vertex eObjectVertex, EReference eReference, List<Vertex> targets) {
        Preconditions.checkNotNull((Object)registry, (Object)"Precondition violation - argument 'registry' must not be NULL!");
        Preconditions.checkNotNull((Object)eObjectVertex, (Object)"Precondition violation - argument 'eObjectVertex' must not be NULL!");
        Preconditions.checkNotNull((Object)eReference, (Object)"Precondition violation - argument 'eReference' must not be NULL!");
        Preconditions.checkArgument((boolean)eReference.isMany(), (Object)"Precondition violation - argument 'eReference' must be many-valued!");
        String edgeLabel = ChronoSphereGraphFormat.createReferenceEdgeLabel(registry, eReference);
        if (targets == null || targets.isEmpty()) {
            eObjectVertex.edges(Direction.OUT, new String[]{edgeLabel}).forEachRemaining(Element::remove);
        } else {
            List<Edge> edges = GremlinUtils.setEdgeTargets(eObjectVertex, edgeLabel, targets);
            int order = 0;
            for (Edge edge : edges) {
                ChronoSphereGraphFormat.setEReferenceEdgeOrder(edge, order);
                ++order;
            }
        }
    }

    public static Vertex getVertexForEClass(ChronoEPackageRegistry registry, ChronoGraph graph, EClass eClass) {
        Preconditions.checkNotNull((Object)registry, (Object)"Precondition violation - argument 'registry' must not be NULL!");
        Preconditions.checkNotNull((Object)graph, (Object)"Precondition violation - argument 'graph' must not be NULL!");
        Preconditions.checkNotNull((Object)eClass, (Object)"Precondition violation - argument 'eClass' must not be NULL!");
        String id = registry.getEClassID(eClass);
        if (id == null) {
            throw new IllegalStateException("There is no ID for EClass '" + eClass.getName() + "'! Did you forget to register an EPackage?");
        }
        Iterator vertices = graph.vertices(new Object[]{id});
        if (vertices == null || !vertices.hasNext()) {
            return null;
        }
        return (Vertex)Iterators.getOnlyElement((Iterator)vertices);
    }

    public static Vertex getVertexForEClassRaw(ChronoGraph graph, EClass eClass) {
        Preconditions.checkNotNull((Object)graph, (Object)"Precondition violation - argument 'graph' must not be NULL!");
        Preconditions.checkNotNull((Object)eClass, (Object)"Precondition violation - argument 'eClass' must not be NULL!");
        Vertex ePackageVertex = ChronoSphereGraphFormat.getVertexForEPackage(graph, eClass.getEPackage());
        if (ePackageVertex == null) {
            return null;
        }
        GraphTraversal eClassVertices = graph.traversal().V(new Object[]{ePackageVertex}).out(new String[]{E_LABEL__EPACKAGE_OWNED_CLASSIFIERS}).has(V_PROP__KIND, (Object)VertexKind.ECLASS.toString()).has(V_PROP__NAME, (Object)eClass.getName());
        if (!eClassVertices.hasNext()) {
            return null;
        }
        return (Vertex)Iterators.getOnlyElement((Iterator)eClassVertices);
    }

    public static Vertex getVertexForEObject(ChronoGraph graph, ChronoEObject eObject) {
        Preconditions.checkNotNull((Object)graph, (Object)"Precondition violation - argument 'graph' must not be NULL!");
        Preconditions.checkNotNull((Object)eObject, (Object)"Precondition violation - argument 'eObject' must not be NULL!");
        Iterator vertices = graph.vertices(new Object[]{eObject.getId()});
        if (vertices == null || !vertices.hasNext()) {
            return null;
        }
        return (Vertex)Iterators.getOnlyElement((Iterator)vertices);
    }

    public static Vertex getVertexForEObject(ChronoGraph graph, String eObjectId) {
        Preconditions.checkNotNull((Object)graph, (Object)"Precondition violation - argument 'graph' must not be NULL!");
        Preconditions.checkNotNull((Object)eObjectId, (Object)"Precondition violation - argument 'eObjectId' must not be NULL!");
        Iterator iterator = graph.vertices(new Object[]{eObjectId});
        if (iterator == null || !iterator.hasNext()) {
            return null;
        }
        return (Vertex)Iterators.getOnlyElement((Iterator)iterator);
    }

    private static Vertex getOrCreateEPackageRegistryVertex(ChronoGraph graph) {
        Preconditions.checkNotNull((Object)graph, (Object)"Precondition violation - argument 'graph' must not be NULL!");
        Iterator vertices = graph.vertices(new Object[]{V_ID__EPACKAGE_REGISTRY});
        if (vertices == null || !vertices.hasNext()) {
            Vertex vertex = graph.addVertex(new Object[]{T.id, V_ID__EPACKAGE_REGISTRY});
            ChronoSphereGraphFormat.setVertexKind(vertex, VertexKind.EPACKAGE_REGISTRY);
            return vertex;
        }
        return (Vertex)Iterators.getOnlyElement((Iterator)vertices);
    }

    public static Vertex getVertexForEPackage(ChronoGraph graph, EPackage ePackage) {
        Preconditions.checkNotNull((Object)ePackage, (Object)"Precondition violation - argument 'ePackage' must not be NULL!");
        Vertex ePackageRegistryVertex = ChronoSphereGraphFormat.getOrCreateEPackageRegistryVertex(graph);
        GraphTraversal vertices = graph.traversal().V(new Object[]{ePackageRegistryVertex}).out(new String[]{E_LABEL__EPACKAGE_REGISTRY_OWNED_BUNDLE}).out(new String[]{E_LABEL__BUNDLE_OWNED_EPACKAGE}).has(V_PROP__KIND, (Object)VertexKind.EPACKAGE.toString()).has(V_PROP__NS_URI, (Object)ePackage.getNsURI()).has(V_PROP__NS_PREFIX, (Object)ePackage.getNsPrefix()).has(V_PROP__NAME, (Object)ePackage.getName());
        if (!vertices.hasNext()) {
            return null;
        }
        return (Vertex)Iterators.getOnlyElement((Iterator)vertices);
    }

    public static Vertex createVertexForEPackage(ChronoGraph graph, EPackage ePackage) {
        Preconditions.checkNotNull((Object)graph, (Object)"Precondition violation - argument 'graph' must not be NULL!");
        Preconditions.checkNotNull((Object)ePackage, (Object)"Precondition violation - argument 'ePackage' must not be NULL!");
        if (ChronoSphereGraphFormat.getVertexForEPackage(graph, ePackage) != null) {
            throw new IllegalStateException("There already is a vertex for Root EPackage '" + ePackage.getName() + "' (URI: '" + ePackage.getNsURI() + "')!");
        }
        Vertex ePackageVertex = graph.addVertex(new Object[]{T.id, UUID.randomUUID().toString()});
        ChronoSphereGraphFormat.setVertexKind(ePackageVertex, VertexKind.EPACKAGE);
        ChronoSphereGraphFormat.setVertexName(ePackageVertex, ePackage.getName());
        ChronoSphereGraphFormat.setNsURI(ePackageVertex, ePackage.getNsURI());
        ChronoSphereGraphFormat.setNsPrefix(ePackageVertex, ePackage.getNsPrefix());
        if (ePackage.getESuperPackage() != null) {
            Vertex superPackageVertex = ChronoSphereGraphFormat.getVertexForEPackage(graph, ePackage.getESuperPackage());
            if (superPackageVertex == null) {
                throw new IllegalArgumentException("EPackage '" + ePackage.getName() + "' (URI: '" + ePackage.getNsURI() + "') has no Vertex representation of its super EPackage!");
            }
            superPackageVertex.addEdge(E_LABEL__ESUBPACKAGE, ePackageVertex, new Object[0]);
        }
        return ePackageVertex;
    }

    public static Vertex createVertexForEPackageBundle(ChronoGraph graph, EPackageBundle bundle) {
        Preconditions.checkNotNull((Object)graph, (Object)"Precondition violation - argument 'graph' must not be NULL!");
        Preconditions.checkNotNull((Object)bundle, (Object)"Precondition violation - argument 'bundle' must not be NULL!");
        Vertex bundleVertex = graph.addVertex(new Object[0]);
        ChronoSphereGraphFormat.setVertexKind(bundleVertex, VertexKind.EPACKAGE_BUNDLE);
        String xmi = EMFUtils.writeEPackagesToXMI(bundle);
        ChronoSphereGraphFormat.setXMIContents(bundleVertex, xmi);
        Vertex ePackageRegistryVertex = ChronoSphereGraphFormat.getOrCreateEPackageRegistryVertex(graph);
        ePackageRegistryVertex.addEdge(E_LABEL__EPACKAGE_REGISTRY_OWNED_BUNDLE, bundleVertex, new Object[0]);
        return bundleVertex;
    }

    public static void updateEPackageBundleVertex(Vertex bundleVertex, EPackageBundle bundle) {
        Preconditions.checkNotNull((Object)bundleVertex, (Object)"Precondition violation - argument 'bundleVertex' must not be NULL!");
        Preconditions.checkNotNull((Object)bundle, (Object)"Precondition violation - argument 'bundle' must not be NULL!");
        Preconditions.checkArgument((boolean)VertexKind.EPACKAGE_BUNDLE.equals((Object)ChronoSphereGraphFormat.getVertexKind(bundleVertex)), (Object)"Precondition violation - argument 'bundleVertex' is not an EPackageBundle vertex!");
        String xmi = EMFUtils.writeEPackagesToXMI(bundle);
        ChronoSphereGraphFormat.setXMIContents(bundleVertex, xmi);
    }

    public static void setVertexName(Vertex vertex, String name) {
        Preconditions.checkNotNull((Object)vertex, (Object)"Precondition violation - argument 'vertex' must not be NULL!");
        if (name == null) {
            vertex.property(V_PROP__NAME).remove();
        } else {
            vertex.property(V_PROP__NAME, (Object)name);
        }
    }

    public static void setNsURI(Vertex ePackageVertex, String nsURI) {
        Preconditions.checkNotNull((Object)ePackageVertex, (Object)"Precondition violation - argument 'ePackageVertex' must not be NULL!");
        if (nsURI == null) {
            ePackageVertex.property(V_PROP__NS_URI).remove();
        } else {
            ePackageVertex.property(V_PROP__NS_URI, (Object)nsURI);
        }
    }

    public static String getNsURI(Vertex ePackageVertex) {
        Preconditions.checkNotNull((Object)ePackageVertex, (Object)"Precondition violation - argument 'ePackageVertex' must not be NULL!");
        return (String)ePackageVertex.property(V_PROP__NS_URI).orElse(null);
    }

    public static void setNsPrefix(Vertex ePackageVertex, String nsPrefix) {
        Preconditions.checkNotNull((Object)ePackageVertex, (Object)"Precondition violation - argument 'ePackageVertex' must not be NULL!");
        if (nsPrefix == null) {
            ePackageVertex.property(V_PROP__NS_PREFIX).remove();
        } else {
            ePackageVertex.property(V_PROP__NS_PREFIX, (Object)nsPrefix);
        }
    }

    public static String getNsPrefix(Vertex ePackageVertex) {
        Preconditions.checkNotNull((Object)ePackageVertex, (Object)"Precondition violation - argument 'ePackageVertex' must not be NULL!");
        return (String)ePackageVertex.property(V_PROP__NS_PREFIX).orElse(null);
    }

    public static String getVertexName(Vertex vertex) {
        Preconditions.checkNotNull((Object)vertex, (Object)"Precondition violation - argument 'vertex' must not be NULL!");
        return (String)vertex.property(V_PROP__NAME).orElse(null);
    }

    public static void setXMIContents(Vertex vertex, String xmiContents) {
        Preconditions.checkNotNull((Object)vertex, (Object)"Precondition violation - argument 'vertex' must not be NULL!");
        if (xmiContents == null || xmiContents.trim().isEmpty()) {
            vertex.property(V_PROP__XMI_CONTENTS).remove();
        } else {
            vertex.property(V_PROP__XMI_CONTENTS, (Object)xmiContents);
        }
    }

    public static String getXMIContents(Vertex vertex) {
        Preconditions.checkNotNull((Object)vertex, (Object)"Precondition violation - argument 'vertex' must not be NULL!");
        return (String)vertex.property(V_PROP__XMI_CONTENTS).orElse(null);
    }

    public static Vertex getVertexForEAttributeRaw(Vertex eClassVertex, EAttribute eAttribute) {
        Preconditions.checkNotNull((Object)eClassVertex, (Object)"Precondition violation - argument 'eClassVertex' must not be NULL!");
        Preconditions.checkNotNull((Object)eAttribute, (Object)"Precondition violation - argument 'eAttribute' must not be NULL!");
        Graph graph = eClassVertex.graph();
        GraphTraversal eAttributeVertices = graph.traversal().V(new Object[]{eClassVertex}).out(new String[]{E_LABEL__ECLASS_OWNED_EATTRIBUTE}).has(V_PROP__KIND, (Object)VertexKind.EATTRIBUTE.toString()).has(V_PROP__NAME, (Object)eAttribute.getName());
        if (!eAttributeVertices.hasNext()) {
            return null;
        }
        return (Vertex)Iterators.getOnlyElement((Iterator)eAttributeVertices);
    }

    public static Vertex getVertexForEReferenceRaw(Vertex eClassVertex, EReference eReference) {
        Preconditions.checkNotNull((Object)eClassVertex, (Object)"Precondition violation - argument 'eClassVertex' must not be NULL!");
        Preconditions.checkNotNull((Object)eReference, (Object)"Precondition violation - argument 'eReference' must not be NULL!");
        Graph graph = eClassVertex.graph();
        GraphTraversal eReferenceVertices = graph.traversal().V(new Object[]{eClassVertex}).out(new String[]{E_LABEL__ECLASS_OWNED_EREFERENCE}).has(V_PROP__KIND, (Object)VertexKind.EREFERENCE.toString()).has(V_PROP__NAME, (Object)eReference.getName());
        if (!eReferenceVertices.hasNext()) {
            return null;
        }
        return (Vertex)Iterators.getOnlyElement((Iterator)eReferenceVertices);
    }

    public static EClass getEClassForEObjectVertex(ChronoEPackageRegistry registry, Vertex vertex) {
        Preconditions.checkNotNull((Object)registry, (Object)"Precondition violation - argument 'registry' must not be NULL!");
        Preconditions.checkNotNull((Object)vertex, (Object)"Precondition violation - argument 'vertex' must not be NULL!");
        String eClassID = (String)vertex.property(V_PROP__ECLASS_ID).orElse(null);
        EClass eClass = registry.getEClassByID(eClassID);
        return eClass;
    }

    public static void setEClassForEObjectVertex(ChronoEPackageRegistry registry, Vertex vertex, EClass eClass) {
        Preconditions.checkNotNull((Object)registry, (Object)"Precondition violation - argument 'registry' must not be NULL!");
        Preconditions.checkNotNull((Object)vertex, (Object)"Precondition violation - argument 'vertex' must not be NULL!");
        Preconditions.checkNotNull((Object)eClass, (Object)"Precondition violation - argument 'eClass' must not be NULL!");
        ChronoGraph graph = (ChronoGraph)vertex.graph();
        Vertex eClassVertex = ChronoSphereGraphFormat.getVertexForEClass(registry, graph, eClass);
        if (eClassVertex == null) {
            throw new IllegalStateException("There is no Vertex in the Graph representing EClass '" + eClass.getName() + "'!");
        }
        vertex.property(V_PROP__ECLASS_ID, (Object)((String)eClassVertex.id()));
    }

    public static void setEContainer(Vertex sourceVertex, Vertex targetVertex) {
        Preconditions.checkNotNull((Object)sourceVertex, (Object)"Precondition violation - argument 'sourceVertex' must not be NULL!");
        if (targetVertex == null) {
            sourceVertex.edges(Direction.OUT, new String[]{E_LABEL__ECONTAINER}).forEachRemaining(edge -> edge.remove());
        } else {
            GremlinUtils.setEdgeTarget(sourceVertex, E_LABEL__ECONTAINER, targetVertex);
        }
    }

    public static Vertex getEContainer(Vertex eObjectVertex) {
        Preconditions.checkNotNull((Object)eObjectVertex, (Object)"Precondition violation - argument 'eObjectVertex' must not be NULL!");
        return (Vertex)Iterators.getOnlyElement((Iterator)eObjectVertex.vertices(Direction.OUT, new String[]{E_LABEL__ECONTAINER}), null);
    }

    public static void setEContainingFeatureId(Vertex eObjectVertex, Integer containingFeatureId) {
        Preconditions.checkNotNull((Object)eObjectVertex, (Object)"Precondition violation - argument 'eObjectVertex' must not be NULL!");
        if (containingFeatureId == null) {
            eObjectVertex.property(V_PROP__ECONTAININGFEATUREID).remove();
        } else {
            eObjectVertex.property(V_PROP__ECONTAININGFEATUREID, (Object)containingFeatureId);
        }
    }

    public static Integer getEContainingFeatureId(Vertex eObjectVertex) {
        Preconditions.checkNotNull((Object)eObjectVertex, (Object)"Precondition violation - argument 'eObjectVertex' must not be NULL!");
        return (Integer)eObjectVertex.property(V_PROP__ECONTAININGFEATUREID).orElse(null);
    }

    public static Vertex getRootEPackageVertexForEClassVertex(Vertex eClassVertex) {
        Preconditions.checkNotNull((Object)eClassVertex, (Object)"Precondition violation - argument 'ePackageVertex' must not be NULL!");
        Preconditions.checkArgument((boolean)VertexKind.ECLASS.equals((Object)ChronoSphereGraphFormat.getVertexKind(eClassVertex)), (Object)"Precondition violation - argument 'ePackageVertex' must have a VertexKind of ECLASS!");
        Vertex ePackageVertex = ChronoSphereGraphFormat.getEPackageVertexForEClassVertex(eClassVertex);
        return ChronoSphereGraphFormat.getRootEPackageVertexForEPackageVertex(ePackageVertex);
    }

    public static Vertex getRootEPackageVertexForEPackageVertex(Vertex ePackageVertex) {
        Preconditions.checkNotNull((Object)ePackageVertex, (Object)"Precondition violation - argument 'ePackageVertex' must not be NULL!");
        Preconditions.checkArgument((boolean)VertexKind.EPACKAGE.equals((Object)ChronoSphereGraphFormat.getVertexKind(ePackageVertex)), (Object)"Precondition violation - argument 'ePackageVertex' must have a VertexKind of EPACKAGE!");
        Vertex v = ePackageVertex;
        Iterator superPackageVertices = v.vertices(Direction.IN, new String[]{E_LABEL__ESUBPACKAGE});
        while (superPackageVertices.hasNext()) {
            v = (Vertex)Iterators.getOnlyElement((Iterator)superPackageVertices);
            superPackageVertices = v.vertices(Direction.IN, new String[]{E_LABEL__ESUBPACKAGE});
        }
        return v;
    }

    public static Vertex getEPackageVertexForEClassVertex(Vertex eClassVertex) {
        Preconditions.checkNotNull((Object)eClassVertex, (Object)"Precondition violation - argument 'eClassVertex' must not be NULL!");
        Preconditions.checkArgument((boolean)VertexKind.ECLASS.equals((Object)ChronoSphereGraphFormat.getVertexKind(eClassVertex)), (Object)"Precondition violation - argument 'eClassVertex' must have a VertexKind of ECLASS!");
        Iterator owningEPackageVertices = eClassVertex.vertices(Direction.IN, new String[]{E_LABEL__EPACKAGE_OWNED_CLASSIFIERS});
        if (!owningEPackageVertices.hasNext()) {
            throw new StorageBackendCorruptedException("The vertex that represents EClass " + ChronoSphereGraphFormat.getVertexName(eClassVertex) + " has no owning EPackage!");
        }
        Vertex ePackageVertex = (Vertex)Iterators.getOnlyElement((Iterator)owningEPackageVertices);
        return ePackageVertex;
    }

    public static Set<Vertex> getEpackageBundleVertices(ChronoGraph graph) {
        Preconditions.checkNotNull((Object)graph, (Object)"Precondition violation - argument 'graph' must not be NULL!");
        Set vertices = graph.traversal().V(new Object[0]).has(V_PROP__KIND, (Object)VertexKind.EPACKAGE_BUNDLE.toString()).toSet();
        return vertices;
    }

    private static Object convertSingleEAttributeValueToPersistableObject(EAttribute eAttribute, Object value) {
        if (value instanceof EEnumLiteral) {
            EEnumLiteral enumLiteral = (EEnumLiteral)value;
            return enumLiteral.getLiteral();
        }
        return value;
    }

    private static Object convertSinglePersistableObjectToEAttributeValue(EAttribute eAttribute, Object value) {
        if (value == null) {
            return null;
        }
        if (eAttribute.getEAttributeType() instanceof EEnum) {
            EEnum eEnum = (EEnum)eAttribute.getEAttributeType();
            if (!(value instanceof String)) {
                throw new EObjectPersistenceException("Tried to deserialize value for EEnum-typed EAttribute '" + eAttribute.getEContainingClass().getName() + "#" + eAttribute.getName() + "', but the stored object (class: '" + value.getClass().getName() + "' is not a literal string: '" + value + "'!");
            }
            EEnumLiteral enumLiteral = eEnum.getEEnumLiteralByLiteral((String)value);
            if (enumLiteral == null) {
                throw new EObjectPersistenceException("Tried to deserialize a value for EEnum-typed EAttribute '" + eAttribute.getEContainingClass().getName() + "#" + eAttribute.getName() + "', but the stored literal '" + value + "' has no representation in the EEnum '" + eEnum.getName() + "'!");
            }
            return enumLiteral;
        }
        return value;
    }
}

