/*
 * Decompiled with CFR 0.152.
 */
package org.chronos.chronosphere.internal.ogm.api;

import com.google.common.base.Preconditions;

public enum VertexKind {
    EOBJECT("eObject"),
    ECLASS("eClass"),
    EATTRIBUTE("eAttribute"),
    EREFERENCE("eReference"),
    EPACKAGE("ePackage"),
    EPACKAGE_REGISTRY("ePackageRegistry"),
    EPACKAGE_BUNDLE("ePackageBundle");

    private final String literal;

    private VertexKind(String literal) {
        Preconditions.checkNotNull((Object)literal, (Object)"Precondition violation - argument 'literal' must not be NULL!");
        this.literal = literal;
    }

    public String toString() {
        return this.literal;
    }

    public static VertexKind fromString(String literal) {
        Preconditions.checkNotNull((Object)literal, (Object)"Precondition violation - argument 'literal' must not be NULL!");
        String string = literal.trim();
        for (VertexKind kind : VertexKind.values()) {
            if (!kind.literal.equalsIgnoreCase(string)) continue;
            return kind;
        }
        return null;
    }
}

