/*
 * Decompiled with CFR 0.152.
 */
package org.chronos.chronosphere.internal.ogm.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import org.chronos.chronosphere.emf.impl.ChronoEFactory;
import org.chronos.chronosphere.internal.ogm.api.ChronoEPackageRegistryInternal;
import org.chronos.common.logging.ChronoLogger;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;

public class ChronoEPackageRegistryImpl
implements ChronoEPackageRegistryInternal {
    private final BiMap<String, EPackage> nsURItoEPackage = HashBiMap.create();
    private final BiMap<EClass, String> eClassToID = HashBiMap.create();
    private final BiMap<EAttribute, String> eAttributeToID = HashBiMap.create();
    private final BiMap<EReference, String> eReferenceToID = HashBiMap.create();
    private boolean isSealed;

    @Override
    public boolean existsEPackage(String namespaceURI) {
        Preconditions.checkNotNull((Object)namespaceURI, (Object)"Precondition violation - argument 'namespaceURI' must not be NULL!");
        return this.getEPackage(namespaceURI) != null;
    }

    @Override
    public EPackage getEPackage(String namespaceURI) {
        Preconditions.checkNotNull((Object)namespaceURI, (Object)"Precondition violation - argument 'namespaceURI' must not be NULL!");
        return (EPackage)this.nsURItoEPackage.get((Object)namespaceURI);
    }

    @Override
    public EClass getEClassByID(String chronoEClassID) {
        Preconditions.checkNotNull((Object)chronoEClassID, (Object)"Precondition violation - argument 'chronoEClassID' must not be NULL!");
        return (EClass)this.eClassToID.inverse().get((Object)chronoEClassID);
    }

    @Override
    public String getEClassID(EClass eClass) {
        Preconditions.checkNotNull((Object)eClass, (Object)"Precondition violation - argument 'eClass' must not be NULL!");
        String eClassID = (String)this.eClassToID.get((Object)eClass);
        if (eClassID != null) {
            return eClassID;
        }
        EClass registeredClass = this.getRegisteredEClassforEClassViaEPackage(eClass);
        if (registeredClass != null) {
            return (String)this.eClassToID.get((Object)registeredClass);
        }
        return null;
    }

    @Override
    public Set<EClass> getEClasses() {
        return Collections.unmodifiableSet(this.eClassToID.keySet());
    }

    @Override
    public EAttribute getEAttributeByID(String chronoEAttributeID) {
        Preconditions.checkNotNull((Object)chronoEAttributeID, (Object)"Precondition violation - argument 'chronoEAttributeID' must not be NULL!");
        return (EAttribute)this.eAttributeToID.inverse().get((Object)chronoEAttributeID);
    }

    @Override
    public String getEAttributeID(EAttribute eAttribute) {
        Preconditions.checkNotNull((Object)eAttribute, (Object)"Precondition violation - argument 'eAttribute' must not be NULL!");
        String eAttributeID = (String)this.eAttributeToID.get((Object)eAttribute);
        if (eAttributeID != null) {
            return eAttributeID;
        }
        EClass eClass = this.getRegisteredEClassforEClassViaEPackage(eAttribute.getEContainingClass());
        if (eClass == null) {
            return null;
        }
        EStructuralFeature feature = eClass.getEStructuralFeature(eAttribute.getName());
        if (feature == null) {
            return null;
        }
        if (!(feature instanceof EAttribute)) {
            return null;
        }
        EAttribute registeredEAttribute = (EAttribute)feature;
        return (String)this.eAttributeToID.get((Object)registeredEAttribute);
    }

    @Override
    public EReference getEReferenceByID(String chronoEReferenceID) {
        Preconditions.checkNotNull((Object)chronoEReferenceID, (Object)"Precondition violation - argument 'chronoEReferenceID' must not be NULL!");
        return (EReference)this.eReferenceToID.inverse().get((Object)chronoEReferenceID);
    }

    @Override
    public String getEReferenceID(EReference eReference) {
        Preconditions.checkNotNull((Object)eReference, (Object)"Precondition violation - argument 'eReference' must not be NULL!");
        String eReferenceID = (String)this.eReferenceToID.get((Object)eReference);
        if (eReferenceID != null) {
            return eReferenceID;
        }
        EClass eClass = this.getRegisteredEClassforEClassViaEPackage(eReference.getEContainingClass());
        if (eClass == null) {
            return null;
        }
        EStructuralFeature feature = eClass.getEStructuralFeature(eReference.getName());
        if (feature == null) {
            return null;
        }
        if (!(feature instanceof EReference)) {
            return null;
        }
        EReference registeredReference = (EReference)feature;
        return (String)this.eReferenceToID.get((Object)registeredReference);
    }

    @Override
    public void registerEPackage(EPackage ePackage) {
        Preconditions.checkNotNull((Object)ePackage, (Object)"Precondition violation - argument 'ePackage' must not be NULL!");
        this.assertNotSealed();
        if (ePackage.getNsURI() == null || ePackage.getNsURI().trim().isEmpty()) {
            throw new IllegalArgumentException("Cannot store an EPackage that has no Namespace URI (NSURI)!");
        }
        EPackage existingEPackage = (EPackage)this.nsURItoEPackage.put((Object)ePackage.getNsURI(), (Object)ePackage);
        if (existingEPackage != null) {
            ChronoLogger.logWarning((String)("Registration of EPackage with Namespace URI '" + ePackage.getNsURI() + "' overrides an existing EPackage!"));
        }
    }

    @Override
    public void registerEClassID(EClass eClass, String chronoEClassID) {
        this.assertNotSealed();
        String previousID = (String)this.eClassToID.get((Object)eClass);
        if (previousID != null) {
            if (!previousID.equals(chronoEClassID)) {
                throw new IllegalStateException("EClass '" + eClass.getName() + "' already has an assigned ID of '" + previousID + "', can't assign ID '" + chronoEClassID + "'!");
            }
            return;
        }
        this.eClassToID.put((Object)eClass, (Object)chronoEClassID);
    }

    @Override
    public void registerEAttributeID(EAttribute eAttribute, String chronoEAttributeID) {
        this.assertNotSealed();
        String previousID = (String)this.eAttributeToID.get((Object)eAttribute);
        if (previousID != null) {
            if (!previousID.equals(chronoEAttributeID)) {
                throw new IllegalStateException("EAttribute '" + eAttribute.getName() + "' already has an assigned ID of '" + previousID + "', can't assign ID '" + chronoEAttributeID + "'!");
            }
            return;
        }
        this.eAttributeToID.put((Object)eAttribute, (Object)chronoEAttributeID);
    }

    @Override
    public void registerEReferenceID(EReference eReference, String chronoEReferenceID) {
        this.assertNotSealed();
        String previousID = (String)this.eReferenceToID.get((Object)eReference);
        if (previousID != null) {
            if (!previousID.equals(chronoEReferenceID)) {
                throw new IllegalStateException("EAttribute '" + eReference.getName() + "' already has an assigned ID of '" + previousID + "', can't assign ID '" + chronoEReferenceID + "'!");
            }
            return;
        }
        this.eReferenceToID.put((Object)eReference, (Object)chronoEReferenceID);
    }

    @Override
    public Set<EPackage> getEPackages() {
        return Sets.newHashSet((Iterable)this.nsURItoEPackage.values());
    }

    @Override
    public void seal() {
        if (this.isSealed) {
            return;
        }
        Stack<EPackage> ePackagesToVisit = new Stack<EPackage>();
        for (EPackage ePackage : this.nsURItoEPackage.values()) {
            ePackagesToVisit.push(ePackage);
        }
        HashSet visitedEPackages = Sets.newHashSet();
        while (!ePackagesToVisit.isEmpty()) {
            EPackage pack = (EPackage)ePackagesToVisit.pop();
            if (visitedEPackages.contains(pack)) continue;
            visitedEPackages.add(pack);
            pack.setEFactoryInstance((EFactory)new ChronoEFactory());
            for (EPackage subPackage : pack.getESubpackages()) {
                ePackagesToVisit.push(subPackage);
            }
        }
        this.isSealed = true;
    }

    private void assertNotSealed() {
        if (this.isSealed) {
            throw new IllegalStateException("ChronoEPackage is already sealed off! No modifications are allowed anymore.");
        }
    }

    private EClass getRegisteredEClassforEClassViaEPackage(EClass eClass) {
        EPackage registeredEPackage = this.getEPackage(eClass.getEPackage().getNsURI());
        if (registeredEPackage == null) {
            return null;
        }
        EClass registeredClass = (EClass)registeredEPackage.getEClassifier(eClass.getName());
        return registeredClass;
    }
}

