/*
 * Decompiled with CFR 0.152.
 */
package org.chronos.chronosphere.internal.ogm.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.chronos.chronograph.api.structure.ChronoGraph;
import org.chronos.chronosphere.emf.api.ChronoEObject;
import org.chronos.chronosphere.internal.api.SphereTransactionContext;
import org.chronos.chronosphere.internal.ogm.api.ChronoEPackageRegistry;
import org.chronos.chronosphere.internal.ogm.api.ChronoSphereGraphFormat;
import org.chronos.chronosphere.internal.ogm.api.EObjectToGraphMapper;
import org.chronos.chronosphere.internal.ogm.api.VertexKind;
import org.chronos.chronosphere.internal.ogm.impl.GremlinUtils;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;

public class EObjectToGraphMapperImpl
implements EObjectToGraphMapper {
    @Override
    public Vertex getOrCreatePlainVertexForEObject(SphereTransactionContext ctx, ChronoEObject eObject) {
        Preconditions.checkNotNull((Object)ctx, (Object)"Precondition violation - argument 'ctx' must not be NULL!");
        Preconditions.checkNotNull((Object)eObject, (Object)"Precondition violation - argument 'eObject' must not be NULL!");
        ChronoGraph graph = ctx.getGraph();
        Vertex vertex = (Vertex)Iterators.getOnlyElement((Iterator)graph.vertices(new Object[]{eObject.getId()}), null);
        if (vertex == null) {
            vertex = graph.addVertex(new Object[]{T.id, eObject.getId()});
            ChronoSphereGraphFormat.setVertexKind(vertex, VertexKind.EOBJECT);
            return vertex;
        }
        return vertex;
    }

    @Override
    public void mapAllEObjectPropertiesToGraph(SphereTransactionContext ctx, ChronoEObject eObject) {
        Preconditions.checkNotNull((Object)ctx, (Object)"Precondition violation - argument 'ctx' must not be NULL!");
        Preconditions.checkNotNull((Object)eObject, (Object)"Precondition violation - argument 'eObject' must not be NULL!");
        Preconditions.checkNotNull((Object)eObject.eClass(), (Object)"Precondition violation - argument 'eObject' has no 'eClass' assigned!");
        for (EAttribute attribute : eObject.eClass().getEAllAttributes()) {
            this.mapEAttributeToGraph(ctx, eObject, attribute);
        }
    }

    @Override
    public void mapAllEObjectReferencesToGraph(SphereTransactionContext session, ChronoEObject eObject) {
        Preconditions.checkNotNull((Object)session, (Object)"Precondition violation - argument 'ctx' must not be NULL!");
        Preconditions.checkNotNull((Object)eObject, (Object)"Precondition violation - argument 'eObject' must not be NULL!");
        Preconditions.checkNotNull((Object)eObject.eClass(), (Object)"Precondition violation - argument 'eObject' has no 'eClass' assigned!");
        this.getOrCreatePlainVertexForEObject(session, eObject);
        for (EReference reference : eObject.eClass().getEAllReferences()) {
            this.mapEReferenceToGraph(session, eObject, reference);
        }
    }

    @Override
    public void mapEAttributeToGraph(SphereTransactionContext ctx, ChronoEObject eObject, EAttribute attribute) {
        Preconditions.checkNotNull((Object)ctx, (Object)"Precondition violation - argument 'ctx' must not be NULL!");
        Preconditions.checkNotNull((Object)eObject, (Object)"Precondition violation - argument 'eObject' must not be NULL!");
        Preconditions.checkNotNull((Object)attribute, (Object)"Precondition violation - argument 'attribute' must not be NULL!");
        Vertex vertex = this.getOrCreatePlainVertexForEObject(ctx, eObject);
        ChronoEPackageRegistry cep = ctx.getChronoEPackage();
        if (attribute.isMany()) {
            Collection values = (Collection)eObject.eGet((EStructuralFeature)attribute);
            ChronoSphereGraphFormat.setEAttributeValues(cep, vertex, attribute, values);
        } else {
            Object value = eObject.eGet((EStructuralFeature)attribute);
            ChronoSphereGraphFormat.setEAttributeValue(cep, vertex, attribute, value);
        }
    }

    @Override
    public void mapEReferenceToGraph(SphereTransactionContext ctx, ChronoEObject eObject, EReference reference) {
        Preconditions.checkNotNull((Object)ctx, (Object)"Precondition violation - argument 'ctx' must not be NULL!");
        Preconditions.checkNotNull((Object)eObject, (Object)"Precondition violation - argument 'eObject' must not be NULL!");
        Preconditions.checkNotNull((Object)reference, (Object)"Precondition violation - argument 'reference' must not be NULL!");
        ChronoGraph graph = ctx.getGraph();
        Vertex vertex = this.getOrCreatePlainVertexForEObject(ctx, eObject);
        ChronoEPackageRegistry cep = ctx.getChronoEPackage();
        String label = ChronoSphereGraphFormat.createReferenceEdgeLabel(cep, reference);
        if (!reference.isMany()) {
            ChronoEObject target = (ChronoEObject)eObject.eGet((EStructuralFeature)reference, true);
            Vertex targetVertex = ChronoSphereGraphFormat.getVertexForEObject(graph, target);
            GremlinUtils.setEdgeTarget(vertex, label, targetVertex);
        } else {
            List targets = (List)eObject.eGet((EStructuralFeature)reference, true);
            HashMap targetEObjectToVertex = Maps.newHashMap();
            for (ChronoEObject target : targets) {
                Vertex targetVertex = ChronoSphereGraphFormat.getVertexForEObject(graph, target);
                targetEObjectToVertex.put(target, targetVertex);
            }
            GremlinUtils.setEdgeTargets(vertex, label, Sets.newHashSet(targetEObjectToVertex.values()));
            if (reference.isOrdered()) {
                int orderIndex = 0;
                for (ChronoEObject target : targets) {
                    Vertex targetVertex = (Vertex)targetEObjectToVertex.get(target);
                    Edge edge = GremlinUtils.getEdge(vertex, label, targetVertex);
                    ChronoSphereGraphFormat.setEReferenceEdgeOrder(edge, orderIndex);
                    ++orderIndex;
                }
            }
        }
    }

    @Override
    public void mapEContainerReferenceToGraph(SphereTransactionContext ctx, ChronoEObject eObject) {
        Preconditions.checkNotNull((Object)ctx, (Object)"Precondition violation - argument 'ctx' must not be NULL!");
        Preconditions.checkNotNull((Object)eObject, (Object)"Precondition violation - argument 'eObject' must not be NULL!");
        ChronoGraph graph = ctx.getGraph();
        Vertex vertex = this.getOrCreatePlainVertexForEObject(ctx, eObject);
        ChronoEObject eContainer = (ChronoEObject)eObject.eContainer();
        Vertex eContainerVertex = ChronoSphereGraphFormat.getVertexForEObject(graph, eContainer);
        String label = ChronoSphereGraphFormat.createEContainerReferenceEdgeLabel();
        GremlinUtils.setEdgeTarget(vertex, label, eContainerVertex);
    }

    @Override
    public void mapEClassReferenceToGraph(SphereTransactionContext ctx, ChronoEObject eObject) {
        Preconditions.checkNotNull((Object)ctx, (Object)"Precondition violation - argument 'ctx' must not be NULL!");
        Preconditions.checkNotNull((Object)eObject, (Object)"Precondition violation - argument 'eObject' must not be NULL!");
        Vertex vertex = this.getOrCreatePlainVertexForEObject(ctx, eObject);
        ChronoEPackageRegistry cep = ctx.getChronoEPackage();
        EClass eClass = eObject.eClass();
        String eClassId = cep.getEClassID(eClass);
        vertex.property("eClass", (Object)eClassId);
    }
}

