/*
 * Decompiled with CFR 0.152.
 */
package org.chronos.chronosphere.internal.ogm.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import org.chronos.chronosphere.emf.internal.util.EMFUtils;
import org.chronos.chronosphere.internal.ogm.api.EPackageBundle;
import org.eclipse.emf.ecore.EPackage;

public class EPackageBundleImpl
implements EPackageBundle {
    private final List<EPackage> ePackages;

    public EPackageBundleImpl(Iterable<? extends EPackage> ePackages) {
        Preconditions.checkNotNull(ePackages, (Object)"Precondition violation - argument 'ePackages' must not be NULL!");
        Preconditions.checkArgument((boolean)ePackages.iterator().hasNext(), (Object)"Precondition violation - argument 'EPackages' must not be empty!");
        for (EPackage ePackage : ePackages) {
            Preconditions.checkNotNull((Object)ePackage.getNsURI(), (Object)"Precondition violation - argument 'ePackages' contains an EPackage where 'ePackage.getNsURI()' == NULL!");
            Preconditions.checkNotNull((Object)ePackage.getNsPrefix(), (Object)"Precondition violation - argument 'ePackages' contains an EPackage where 'ePackage.getNsPrefix()' == NULL!");
            Preconditions.checkNotNull((Object)ePackage.getName(), (Object)"Precondition violation - argument 'ePackages' contains an EPackage where 'ePackage.getName()' ==  NULL!");
        }
        EMFUtils.assertEPackagesAreSelfContained(ePackages);
        LinkedHashSet ePackageSet = Sets.newLinkedHashSet(ePackages);
        this.ePackages = Collections.unmodifiableList(Lists.newArrayList((Iterable)ePackageSet));
    }

    @Override
    public Iterator<EPackage> iterator() {
        return this.ePackages.iterator();
    }

    @Override
    public List<EPackage> getContents() {
        return this.ePackages;
    }

    @Override
    public EPackage getEPackageByNsURI(String ePackageNsURI) {
        Preconditions.checkNotNull((Object)ePackageNsURI, (Object)"Precondition violation - argument 'ePackageNsURI' must not be NULL!");
        for (EPackage ePackage : this) {
            if (!ePackage.getNsURI().equals(ePackageNsURI)) continue;
            return ePackage;
        }
        return null;
    }
}

