/*
 * Decompiled with CFR 0.152.
 */
package org.chronos.chronosphere.internal.ogm.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.chronos.chronograph.api.structure.ChronoGraph;
import org.chronos.chronosphere.emf.impl.ChronoEFactory;
import org.chronos.chronosphere.emf.internal.util.EMFUtils;
import org.chronos.chronosphere.internal.ogm.api.ChronoEPackageRegistry;
import org.chronos.chronosphere.internal.ogm.api.ChronoEPackageRegistryInternal;
import org.chronos.chronosphere.internal.ogm.api.ChronoSphereGraphFormat;
import org.chronos.chronosphere.internal.ogm.api.EPackageBundle;
import org.chronos.chronosphere.internal.ogm.api.EPackageToGraphMapper;
import org.chronos.chronosphere.internal.ogm.api.VertexKind;
import org.chronos.chronosphere.internal.ogm.impl.ChronoEPackageRegistryImpl;
import org.chronos.chronosphere.internal.ogm.impl.GremlinUtils;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;

public class EPackageToGraphMapperImpl
implements EPackageToGraphMapper {
    @Override
    public void mapToGraph(ChronoGraph graph, EPackageBundle bundle) {
        Preconditions.checkNotNull((Object)graph, (Object)"Precondition violation - argument 'graph' must not be NULL!");
        Preconditions.checkNotNull((Object)bundle, (Object)"Precondition violation - argument 'bundle' must not be NULL!");
        this.mergeEPackageBundleIntoGraph(bundle, graph);
    }

    @Override
    public ChronoEPackageRegistry readChronoEPackageRegistryFromGraph(ChronoGraph graph) {
        Preconditions.checkNotNull((Object)graph, (Object)"Precondition violation - argument 'graph' must not be NULL!");
        ChronoEPackageRegistryImpl registry = new ChronoEPackageRegistryImpl();
        Set<Vertex> bundleVertices = ChronoSphereGraphFormat.getEpackageBundleVertices(graph);
        for (Vertex bundleVertex : bundleVertices) {
            String xmi = ChronoSphereGraphFormat.getXMIContents(bundleVertex);
            List<EPackage> ePackages = EMFUtils.readEPackagesFromXMI(xmi);
            EMFUtils.flattenEPackages(ePackages).forEach(ePackage -> ePackage.setEFactoryInstance((EFactory)new ChronoEFactory()));
            for (EPackage ePackage2 : ePackages) {
                this.registerPackageContentsRecursively(graph, ePackage2, registry);
            }
        }
        return registry;
    }

    @Override
    public void deleteInGraph(ChronoGraph graph, EPackageBundle bundle) {
        Preconditions.checkNotNull((Object)bundle, (Object)"Precondition violation - argument 'bundle' must not be NULL!");
        Vertex bundleVertex = this.getCommonBundleVertex(graph, bundle);
        if (bundleVertex == null) {
            return;
        }
        Iterator ePackageVertices = bundleVertex.vertices(Direction.OUT, new String[]{"ownedEPackage"});
        while (ePackageVertices.hasNext()) {
            Vertex ePackageVertex = (Vertex)ePackageVertices.next();
            this.deleteEPackageVertex(ePackageVertex);
        }
        bundleVertex.remove();
    }

    private void mergeEPackageBundleIntoGraph(EPackageBundle bundle, ChronoGraph graph) {
        ChronoEPackageRegistryImpl registry = new ChronoEPackageRegistryImpl();
        Vertex commonBundleVertex = null;
        for (EPackage ePackage : bundle) {
            Vertex packageVertex = ChronoSphereGraphFormat.getVertexForEPackage(graph, ePackage);
            if (packageVertex == null) continue;
            Iterator bundleVertices = packageVertex.vertices(Direction.IN, new String[]{"ownedEPackage"});
            Vertex bundleVertex = (Vertex)Iterators.getOnlyElement((Iterator)bundleVertices);
            if (commonBundleVertex != null && !commonBundleVertex.equals(bundleVertex)) {
                throw new IllegalStateException("The EPackage '" + ePackage.getName() + "' belongs to a different bundle of EPackages!");
            }
            commonBundleVertex = bundleVertex;
        }
        if (commonBundleVertex != null) {
            Iterator ePackageVertices = commonBundleVertex.vertices(Direction.OUT, new String[]{"ownedEPackage"});
            ePackageVertices.forEachRemaining(ePackageVertex -> {
                String nsURI = ChronoSphereGraphFormat.getNsURI(ePackageVertex);
                if (!bundle.containsEPackageWithNsURI(nsURI)) {
                    this.deleteEPackageVertex((Vertex)ePackageVertex);
                }
            });
            ChronoSphereGraphFormat.updateEPackageBundleVertex(commonBundleVertex, bundle);
        } else {
            commonBundleVertex = ChronoSphereGraphFormat.createVertexForEPackageBundle(graph, bundle);
        }
        for (EPackage ePackage : bundle) {
            this.mergeEPackageIntoGraphRecursive(commonBundleVertex, ePackage, graph);
        }
        registry.seal();
        this.mergeESuperTypeEdges(registry, graph);
    }

    private Vertex mergeEPackageIntoGraphRecursive(Vertex bundleVertex, EPackage ePackage, ChronoGraph graph) {
        Vertex ePackageVertex = ChronoSphereGraphFormat.getVertexForEPackage(graph, ePackage);
        if (ePackageVertex == null) {
            ePackageVertex = ChronoSphereGraphFormat.createVertexForEPackage(graph, ePackage);
        }
        if (bundleVertex != null) {
            GremlinUtils.ensureEdgeExists(bundleVertex, "ownedEPackage", ePackageVertex);
        }
        HashSet eClassVertices = Sets.newHashSet();
        for (EClassifier classifier : ePackage.getEClassifiers()) {
            if (!(classifier instanceof EClass)) continue;
            EClass eClass = (EClass)classifier;
            Vertex eClassVertex2 = this.mergeEClassIntoGraph(ePackageVertex, eClass);
            eClassVertices.add(eClassVertex2);
        }
        HashSet existingEClassVertices = Sets.newHashSet((Iterator)ePackageVertex.vertices(Direction.OUT, new String[]{"classifier"}));
        existingEClassVertices.removeAll(eClassVertices);
        existingEClassVertices.forEach(eClassVertex -> this.deleteEClassVertex((Vertex)eClassVertex));
        HashSet childEPackageVertices = Sets.newHashSet();
        for (EPackage childPackage : ePackage.getESubpackages()) {
            Vertex childPackageVertex = this.mergeEPackageIntoGraphRecursive(bundleVertex, childPackage, graph);
            childEPackageVertices.add(childPackageVertex);
        }
        HashSet allSubPackageVertices = Sets.newHashSet((Iterator)ePackageVertex.vertices(Direction.OUT, new String[]{"eSubPackage"}));
        allSubPackageVertices.removeAll(childEPackageVertices);
        for (Vertex subPackageVertex : allSubPackageVertices) {
            this.deleteEPackageVertex(subPackageVertex);
        }
        return ePackageVertex;
    }

    private Vertex mergeEClassIntoGraph(Vertex ePackageVertex, EClass eClass) {
        String id;
        ChronoGraph graph = (ChronoGraph)ePackageVertex.graph();
        Vertex eClassVertex = ChronoSphereGraphFormat.getVertexForEClassRaw(graph, eClass);
        if (eClassVertex == null) {
            String id2 = UUID.randomUUID().toString();
            eClassVertex = graph.addVertex(new Object[]{T.id, id2});
            ChronoSphereGraphFormat.setVertexKind(eClassVertex, VertexKind.ECLASS);
            ePackageVertex.addEdge("classifier", eClassVertex, new Object[0]);
            ChronoSphereGraphFormat.setVertexName(eClassVertex, eClass.getName());
        }
        HashSet eAttributeVertices = Sets.newHashSet();
        HashSet eReferenceVertices = Sets.newHashSet();
        for (EAttribute eAttribute : eClass.getEAttributes()) {
            Vertex eAttributeVertex = ChronoSphereGraphFormat.getVertexForEAttributeRaw(eClassVertex, eAttribute);
            if (eAttributeVertex == null) {
                id = UUID.randomUUID().toString();
                eAttributeVertex = graph.addVertex(new Object[]{T.id, id});
                ChronoSphereGraphFormat.setVertexKind(eAttributeVertex, VertexKind.EATTRIBUTE);
                eClassVertex.addEdge("eAttribute", eAttributeVertex, new Object[0]);
                ChronoSphereGraphFormat.setVertexName(eAttributeVertex, eAttribute.getName());
            }
            eAttributeVertices.add(eAttributeVertex);
        }
        for (Object eReference : eClass.getEReferences()) {
            Vertex eReferenceVertex = ChronoSphereGraphFormat.getVertexForEReferenceRaw(eClassVertex, (EReference)eReference);
            if (eReferenceVertex == null) {
                id = UUID.randomUUID().toString();
                eReferenceVertex = graph.addVertex(new Object[]{T.id, id});
                ChronoSphereGraphFormat.setVertexKind(eReferenceVertex, VertexKind.EREFERENCE);
                eClassVertex.addEdge("eReference", eReferenceVertex, new Object[0]);
                ChronoSphereGraphFormat.setVertexName(eReferenceVertex, eReference.getName());
            }
            eReferenceVertices.add(eReferenceVertex);
        }
        HashSet existingEAttributeVertices = Sets.newHashSet((Iterator)eClassVertex.vertices(Direction.OUT, new String[]{"eAttribute"}));
        existingEAttributeVertices.removeAll(eAttributeVertices);
        for (Vertex eAttributeVertex : existingEAttributeVertices) {
            eAttributeVertex.remove();
        }
        HashSet existingEReferenceVertices = Sets.newHashSet((Iterator)eClassVertex.vertices(Direction.OUT, new String[]{"eReference"}));
        existingEReferenceVertices.removeAll(eReferenceVertices);
        for (Vertex eReferenceVertex : existingEReferenceVertices) {
            eReferenceVertex.remove();
        }
        return eClassVertex;
    }

    private void mergeESuperTypeEdges(ChronoEPackageRegistry chronoEPackage, ChronoGraph graph) {
        Preconditions.checkNotNull((Object)chronoEPackage, (Object)"Precondition violation - argument 'chronoEPackage' must not be NULL!");
        Preconditions.checkNotNull((Object)graph, (Object)"Precondition violation - argument 'graph' must not be NULL!");
        for (EClass eClass : chronoEPackage.getEClasses()) {
            Vertex eClassVertex = ChronoSphereGraphFormat.getVertexForEClass(chronoEPackage, graph, eClass);
            EList superTypes = eClass.getESuperTypes();
            HashSet superTypeVertices = Sets.newHashSet();
            for (EClass superType : superTypes) {
                Vertex superTypeVertex = ChronoSphereGraphFormat.getVertexForEClass(chronoEPackage, graph, superType);
                if (superTypeVertex == null) {
                    throw new IllegalStateException("Could not find vertex for supertype '" + superType.getName() + "' of EClass '" + eClass.getName() + "'!");
                }
                superTypeVertices.add(superTypeVertex);
            }
            GremlinUtils.setEdgeTargets(eClassVertex, "eSuperType", superTypeVertices);
        }
    }

    private void deleteEPackageVertex(Vertex packageVertex) {
        Set<Vertex> verticesToRemove = this.deleteEPackageVertexRecursively(packageVertex);
        for (Vertex vertex : verticesToRemove) {
            vertex.remove();
        }
    }

    private Set<Vertex> deleteEPackageVertexRecursively(Vertex packageVertex) {
        HashSet verticesToRemove = Sets.newHashSet();
        verticesToRemove.add(packageVertex);
        HashSet eClassVertices = Sets.newHashSet((Iterator)packageVertex.vertices(Direction.OUT, new String[]{"classifier"}));
        verticesToRemove.addAll(eClassVertices);
        for (Vertex eClassVertex : eClassVertices) {
            verticesToRemove.addAll(this.deleteEClassVertexRecursively(eClassVertex));
        }
        HashSet subPackageVertices = Sets.newHashSet((Iterator)packageVertex.vertices(Direction.OUT, new String[]{"eSubPackage"}));
        for (Vertex subPackageVertex : subPackageVertices) {
            verticesToRemove.addAll(this.deleteEPackageVertexRecursively(subPackageVertex));
        }
        return verticesToRemove;
    }

    private void deleteEClassVertex(Vertex vertex) {
        this.deleteEClassVertexRecursively(vertex).forEach(v -> v.remove());
    }

    private Set<Vertex> deleteEClassVertexRecursively(Vertex eClassVertex) {
        HashSet verticesToRemove = Sets.newHashSet();
        verticesToRemove.add(eClassVertex);
        Iterator eAttributeVertices = eClassVertex.vertices(Direction.OUT, new String[]{"eAttribute"});
        eAttributeVertices.forEachRemaining(v -> verticesToRemove.add(v));
        Iterator eReferenceVertices = eClassVertex.vertices(Direction.OUT, new String[]{"eReference"});
        eReferenceVertices.forEachRemaining(v -> verticesToRemove.add(v));
        GraphTraversal eObjectVertices = eClassVertex.graph().traversal().V(new Object[0]).has("kind", (Object)VertexKind.EOBJECT.toString()).has("eClass", eClassVertex.id());
        eObjectVertices.forEachRemaining(v -> verticesToRemove.add(v));
        return verticesToRemove;
    }

    private void registerPackageContentsRecursively(ChronoGraph graph, EPackage ePackage, ChronoEPackageRegistryInternal chronoEPackage) {
        Preconditions.checkNotNull((Object)graph, (Object)"Precondition violation - argument 'graph' must not be NULL!");
        Preconditions.checkNotNull((Object)ePackage, (Object)"Precondition violation - argument 'ePackage' must not be NULL!");
        Preconditions.checkNotNull((Object)chronoEPackage, (Object)"Precondition violation - argument 'chronoEPackage' must not be NULL!");
        chronoEPackage.registerEPackage(ePackage);
        Vertex ePackageVertex = ChronoSphereGraphFormat.getVertexForEPackage(graph, ePackage);
        if (ePackageVertex == null) {
            throw new IllegalArgumentException("Could not find EPackage '" + ePackage.getName() + "' (NS URI: '" + ePackage.getNsURI() + "') in data store! Was it registered before?");
        }
        for (EClassifier eClassifier : ePackage.getEClassifiers()) {
            if (!(eClassifier instanceof EClass)) continue;
            EClass eClass = (EClass)eClassifier;
            Vertex eClassVertex = ChronoSphereGraphFormat.getVertexForEClassRaw(graph, eClass);
            if (eClassVertex == null) {
                throw new IllegalArgumentException("Could not find EClass '" + eClass.getName() + "' in data store! Did the EPackage contents change?");
            }
            chronoEPackage.registerEClassID(eClass, (String)eClassVertex.id());
            for (EAttribute eAttribute : eClass.getEAttributes()) {
                Vertex eAttributeVertex = ChronoSphereGraphFormat.getVertexForEAttributeRaw(eClassVertex, eAttribute);
                if (eAttributeVertex == null) {
                    throw new IllegalArgumentException("Could not find EAttribute '" + eClass.getName() + "#" + eAttribute.getName() + "' in data store! Did the EPackage contents change?");
                }
                chronoEPackage.registerEAttributeID(eAttribute, (String)eAttributeVertex.id());
            }
            for (EReference eReference : eClass.getEReferences()) {
                Vertex eReferenceVertex = ChronoSphereGraphFormat.getVertexForEReferenceRaw(eClassVertex, eReference);
                if (eReferenceVertex == null) {
                    throw new IllegalArgumentException("Could not find EReference '" + eClass.getName() + "#" + eReference.getName() + "' in data store! Did the EPackage contents change?");
                }
                chronoEPackage.registerEReferenceID(eReference, (String)eReferenceVertex.id());
            }
        }
        for (EPackage subPackage : ePackage.getESubpackages()) {
            this.registerPackageContentsRecursively(graph, subPackage, chronoEPackage);
        }
    }

    private Vertex getCommonBundleVertex(ChronoGraph graph, EPackageBundle bundle) {
        Vertex commonBundleVertex = null;
        for (EPackage ePackage : bundle) {
            Vertex packageVertex = ChronoSphereGraphFormat.getVertexForEPackage(graph, ePackage);
            if (packageVertex == null) continue;
            Iterator bundleVertices = packageVertex.vertices(Direction.IN, new String[]{"ownedEPackage"});
            Vertex bundleVertex = (Vertex)Iterators.getOnlyElement((Iterator)bundleVertices);
            if (commonBundleVertex != null && !commonBundleVertex.equals(bundleVertex)) {
                throw new IllegalStateException("The EPackage '" + ePackage.getName() + "' belongs to a different bundle of EPackages!");
            }
            commonBundleVertex = bundleVertex;
        }
        return commonBundleVertex;
    }
}

