/*
 * Decompiled with CFR 0.152.
 */
package org.chronos.chronosphere.internal.ogm.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Vertex;

public class GremlinUtils {
    public static Edge setEdgeTarget(Vertex source, String label, Vertex target) {
        Preconditions.checkNotNull((Object)source, (Object)"Precondition violation - argument 'source' must not be NULL!");
        Preconditions.checkNotNull((Object)target, (Object)"Precondition violation - argument 'target' must not be NULL!");
        Preconditions.checkNotNull((Object)label, (Object)"Precondition violation - argument 'label' must not be NULL!");
        HashSet edges = Sets.newHashSet((Iterator)source.edges(Direction.OUT, new String[]{label}));
        if (edges.isEmpty()) {
            return source.addEdge(label, target, new Object[0]);
        }
        Edge edgeToKeep = null;
        for (Edge edge : edges) {
            if (edge.inVertex().equals(target)) {
                edgeToKeep = edge;
                continue;
            }
            edge.remove();
        }
        if (edgeToKeep != null) {
            return edgeToKeep;
        }
        return source.addEdge(label, target, new Object[0]);
    }

    public static Set<Edge> setEdgeTargets(Vertex source, String label, Set<Vertex> targets) {
        Preconditions.checkNotNull((Object)source, (Object)"Precondition violation - argument 'source' must not be NULL!");
        Preconditions.checkNotNull((Object)label, (Object)"Precondition violation - argument 'label' must not be NULL!");
        Preconditions.checkNotNull(targets, (Object)"Precondition violation - argument 'targets' must not be NULL!");
        HashSet resultSet = Sets.newHashSet();
        HashSet verticesToConnectTo = Sets.newHashSet(targets);
        HashSet existingEdges = Sets.newHashSet((Iterator)source.edges(Direction.OUT, new String[]{label}));
        for (Edge edge : existingEdges) {
            Vertex target = edge.inVertex();
            if (targets.contains(target)) {
                verticesToConnectTo.remove(target);
                resultSet.add(edge);
                continue;
            }
            edge.remove();
        }
        for (Vertex target : verticesToConnectTo) {
            Edge newEdge = source.addEdge(label, target, new Object[0]);
            resultSet.add(newEdge);
        }
        return resultSet;
    }

    public static List<Edge> setEdgeTargets(Vertex source, String label, List<Vertex> targets) {
        Preconditions.checkNotNull((Object)source, (Object)"Precondition violation - argument 'source' must not be NULL!");
        Preconditions.checkNotNull((Object)label, (Object)"Precondition violation - argument 'label' must not be NULL!");
        Preconditions.checkNotNull(targets, (Object)"Precondition violation - argument 'targets' must not be NULL!");
        ArrayList resultList = Lists.newArrayList();
        HashSet existingEdges = Sets.newHashSet((Iterator)source.edges(Direction.OUT, new String[]{label}));
        for (Vertex targetVertex : targets) {
            Optional<Edge> maybeEdge = existingEdges.stream().filter(edge -> edge.inVertex().equals(targetVertex)).findAny();
            if (maybeEdge.isPresent()) {
                Edge edge2 = maybeEdge.get();
                resultList.add(edge2);
                existingEdges.remove(edge2);
                continue;
            }
            resultList.add(source.addEdge(label, targetVertex, new Object[0]));
        }
        existingEdges.forEach(edge -> edge.remove());
        return resultList;
    }

    public static Edge getEdge(Vertex source, String label, Vertex target) {
        Set<Edge> edges = GremlinUtils.getEdges(source, label, target);
        if (edges.isEmpty()) {
            return null;
        }
        if (edges.size() > 1) {
            throw new IllegalArgumentException("Multiple edges (" + edges.size() + ") with label '" + label + "'connect the source vertex " + source + " with target vertex " + target + "!");
        }
        return (Edge)Iterables.getOnlyElement(edges);
    }

    public static Set<Edge> getEdges(Vertex source, String label, Vertex target) {
        Preconditions.checkNotNull((Object)source, (Object)"Precondition violation - argument 'source' must not be NULL!");
        Preconditions.checkNotNull((Object)label, (Object)"Precondition violation - argument 'label' must not be NULL!");
        Preconditions.checkNotNull((Object)target, (Object)"Precondition violation - argument 'target' must not be NULL!");
        HashSet resultSet = Sets.newHashSet();
        source.edges(Direction.OUT, new String[]{label}).forEachRemaining(edge -> {
            if (edge.inVertex().equals(target)) {
                resultSet.add(edge);
            }
        });
        return resultSet;
    }

    public static Edge ensureEdgeExists(Vertex source, String label, Vertex target) {
        Preconditions.checkNotNull((Object)source, (Object)"Precondition violation - argument 'source' must not be NULL!");
        Preconditions.checkNotNull((Object)label, (Object)"Precondition violation - argument 'label' must not be NULL!");
        Preconditions.checkNotNull((Object)target, (Object)"Precondition violation - argument 'target' must not be NULL!");
        Iterator edges = source.edges(Direction.OUT, new String[]{label});
        while (edges.hasNext()) {
            Edge edge = (Edge)edges.next();
            if (!edge.inVertex().equals(target)) continue;
            return edge;
        }
        return source.addEdge(label, target, new Object[0]);
    }
}

