/*
 * Decompiled with CFR 0.152.
 */
package org.encryptor4j;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.SecretKeyFactory;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.IvParameterSpec;

public class Encryptor {
    private static final String DEFAULT_ALGORITHM = "AES";
    private String algorithm;
    private String algorithmProvider;
    private int ivLength;
    private byte[] iv;
    private int tLen;
    private Key key;
    private KeySpec keySpec;
    private SecretKeyFactory secretKeyFactory;
    private boolean prependIV;
    private boolean generateIV;

    public Encryptor(Key key) {
        this(key, DEFAULT_ALGORITHM);
    }

    public Encryptor(Key key, String algorithm) {
        this(key, algorithm, 0);
    }

    public Encryptor(Key key, String algorithm, int ivLength) {
        this(key, algorithm, ivLength, 0);
    }

    public Encryptor(Key key, String algorithm, int ivLength, int tLen) {
        this.key = key;
        this.algorithm = algorithm;
        this.ivLength = ivLength;
        this.tLen = tLen;
        this.generateIV = true;
        this.prependIV = true;
    }

    public Encryptor(Key key, String algorithm, byte[] iv) {
        this(key, algorithm, iv, 0);
    }

    public Encryptor(Key key, String algorithm, byte[] iv, int tLen) {
        this.key = key;
        this.algorithm = algorithm;
        this.iv = iv;
        this.tLen = tLen;
        this.generateIV = false;
        this.prependIV = false;
    }

    public Encryptor(KeySpec keySpec, SecretKeyFactory secretKeyFactory) {
        this(keySpec, secretKeyFactory, DEFAULT_ALGORITHM, 0);
    }

    public Encryptor(KeySpec keySpec, SecretKeyFactory secretKeyFactory, String algorithm, int ivLength) {
        this(keySpec, secretKeyFactory, DEFAULT_ALGORITHM, ivLength, 0);
    }

    public Encryptor(KeySpec keySpec, SecretKeyFactory secretKeyFactory, String algorithm, int ivLength, int tLen) {
        this.keySpec = keySpec;
        this.secretKeyFactory = secretKeyFactory;
        this.algorithm = algorithm;
        this.ivLength = ivLength;
        this.tLen = tLen;
        this.generateIV = true;
        this.prependIV = true;
    }

    public Encryptor(KeySpec keySpec, SecretKeyFactory secretKeyFactory, String algorithm, byte[] iv) {
        this(keySpec, secretKeyFactory, DEFAULT_ALGORITHM, iv, 0);
    }

    public Encryptor(KeySpec keySpec, SecretKeyFactory secretKeyFactory, String algorithm, byte[] iv, int tLen) {
        this.keySpec = keySpec;
        this.secretKeyFactory = secretKeyFactory;
        this.algorithm = algorithm;
        this.iv = iv;
        this.tLen = tLen;
        this.generateIV = false;
        this.prependIV = false;
    }

    public byte[] encrypt(byte[] message) throws GeneralSecurityException {
        byte[] encrypted;
        Cipher cipher = this.getCipher();
        if (!this.generateIV) {
            this.iv = null;
        } else if (this.iv == null && this.ivLength > 0) {
            this.generateIV();
        }
        if (this.iv != null) {
            cipher.init(1, this.getKey(), this.getAlgorithmParameterSpec(this.iv));
        } else {
            cipher.init(1, this.getKey());
            this.iv = cipher.getIV();
        }
        if (this.prependIV && this.iv != null) {
            int outputSize = cipher.getOutputSize(message.length);
            encrypted = new byte[this.iv.length + outputSize];
            System.arraycopy(this.iv, 0, encrypted, 0, this.iv.length);
            try {
                cipher.doFinal(message, 0, message.length, encrypted, this.iv.length);
            }
            catch (ShortBufferException e) {
                throw new RuntimeException(e);
            }
        } else {
            encrypted = cipher.doFinal(message);
        }
        return encrypted;
    }

    public byte[] decrypt(byte[] message) throws GeneralSecurityException {
        Cipher cipher = this.getCipher();
        if (this.ivLength > 0) {
            if (this.prependIV) {
                cipher.init(2, this.getKey(), this.getAlgorithmParameterSpec(message));
                return cipher.doFinal(message, this.ivLength, message.length - this.ivLength);
            }
            throw new IllegalStateException("Could not obtain IV");
        }
        if (this.iv != null) {
            cipher.init(2, this.getKey(), this.getAlgorithmParameterSpec(this.iv));
        } else {
            cipher.init(2, this.getKey());
        }
        return cipher.doFinal(message);
    }

    public byte[] getIV() {
        return this.iv;
    }

    public void setPrependIV(boolean prependIV) {
        this.prependIV = prependIV;
    }

    public void setGenerateIV(boolean generateIV) {
        this.generateIV = generateIV;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithmProvider(String algorithmProvider) {
        this.algorithmProvider = algorithmProvider;
    }

    public Key getKey() {
        if (this.key != null) {
            return this.key;
        }
        if (this.keySpec != null && this.secretKeyFactory != null) {
            try {
                this.key = this.secretKeyFactory.generateSecret(this.keySpec);
                return this.key;
            }
            catch (InvalidKeySpecException e) {
                throw new RuntimeException(e);
            }
        }
        throw new IllegalStateException("Cannot produce key");
    }

    public CipherInputStream wrapInputStream(InputStream is) throws GeneralSecurityException, IOException {
        Cipher cipher = this.getCipher();
        if (this.ivLength > 0) {
            if (this.prependIV) {
                this.iv = new byte[this.ivLength];
                is.read(this.iv);
            } else if (this.iv == null) {
                throw new IllegalStateException("Could not obtain IV");
            }
        }
        if (this.iv != null) {
            cipher.init(2, this.getKey(), this.getAlgorithmParameterSpec(this.iv));
        } else {
            cipher.init(2, this.getKey());
        }
        return new CipherInputStream(is, cipher);
    }

    public CipherOutputStream wrapOutputStream(OutputStream os) throws GeneralSecurityException, IOException {
        Cipher cipher = this.getCipher();
        if (!this.generateIV) {
            this.iv = null;
        } else if (this.iv == null && this.ivLength > 0) {
            this.generateIV();
        }
        if (this.iv != null) {
            cipher.init(2, this.getKey(), this.getAlgorithmParameterSpec(this.iv));
        } else {
            cipher.init(2, this.getKey());
            this.iv = cipher.getIV();
        }
        if (this.prependIV && this.iv != null) {
            os.write(this.iv);
        }
        return new CipherOutputStream(os, cipher);
    }

    private Cipher getCipher() throws GeneralSecurityException {
        if (this.algorithmProvider != null) {
            return Cipher.getInstance(this.algorithm, this.algorithmProvider);
        }
        return Cipher.getInstance(this.algorithm);
    }

    private AlgorithmParameterSpec getAlgorithmParameterSpec(byte[] ivBuffer) {
        int length = this.ivLength == 0 && ivBuffer != null ? ivBuffer.length : this.ivLength;
        return this.tLen > 0 ? new GCMParameterSpec(this.tLen, ivBuffer, 0, length) : new IvParameterSpec(ivBuffer, 0, length);
    }

    private void generateIV() {
        SecureRandom random = new SecureRandom();
        this.iv = new byte[this.ivLength];
        random.nextBytes(this.iv);
    }
}

