/*
 * Decompiled with CFR 0.152.
 */
package org.encryptor4j.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.util.Base64;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.encryptor4j.Encryptor;
import org.encryptor4j.factory.EncryptorFactory;
import org.encryptor4j.factory.KeyFactory;

public class FileEncryptor {
    private Encryptor encryptor;
    private int bufferSize;

    public FileEncryptor() {
        this(KeyFactory.AES.randomKey());
    }

    public FileEncryptor(String password) {
        this(KeyFactory.AES.keyFromPassword(password.toCharArray()));
    }

    public FileEncryptor(Key key) {
        this(EncryptorFactory.AES.streamEncryptor(key));
    }

    public FileEncryptor(Encryptor encryptor) {
        this.encryptor = encryptor;
        this.bufferSize = 65536;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void encrypt(File src, File dest) throws FileNotFoundException, GeneralSecurityException, IOException {
        FileInputStream is = null;
        OutputStream os = null;
        try {
            is = new FileInputStream(src);
            os = this.encryptor.wrapOutputStream(new FileOutputStream(dest));
            this.copy(is, os);
        }
        finally {
            if (is != null) {
                ((InputStream)is).close();
            }
            if (os != null) {
                os.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decrypt(File src, File dest) throws FileNotFoundException, GeneralSecurityException, IOException {
        InputStream is = null;
        OutputStream os = null;
        try {
            is = this.encryptor.wrapInputStream(new FileInputStream(src));
            os = new FileOutputStream(dest);
            this.copy(is, os);
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (os != null) {
                os.close();
            }
        }
    }

    private void copy(InputStream is, OutputStream os) throws IOException {
        int nRead;
        byte[] buffer = new byte[this.bufferSize];
        while ((nRead = is.read(buffer)) != -1) {
            os.write(buffer, 0, nRead);
        }
        os.flush();
    }

    public Encryptor getEncryptor() {
        return this.encryptor;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public static void main(String[] args) {
        block13: {
            Options options = new Options();
            options.addOption(Option.builder((String)"i").longOpt("in-file").hasArg().argName("file").desc("input file").required().build());
            options.addOption(Option.builder((String)"o").longOpt("out-file").hasArg().argName("file").desc("output file").required().build());
            options.addOption(Option.builder((String)"d").longOpt("decrypt").desc("decrypt").build());
            options.addOption(Option.builder((String)"p").longOpt("password").hasArg().argName("password").desc("password").build());
            options.addOption(Option.builder((String)"k").longOpt("key").hasArg().argName("key").desc("Base64 encoded key").build());
            if (args != null && args.length > 0) {
                FileEncryptor fe;
                CommandLine cmd;
                DefaultParser parser = new DefaultParser();
                try {
                    cmd = parser.parse(options, args);
                }
                catch (ParseException e) {
                    throw new RuntimeException("Could not parse args", e);
                }
                File inFile = new File(cmd.getOptionValue("i"));
                File outFile = new File(cmd.getOptionValue("o"));
                if (cmd.hasOption("p")) {
                    fe = new FileEncryptor(cmd.getOptionValue("p"));
                } else if (cmd.hasOption("k")) {
                    String encodedKey = cmd.getOptionValue("k");
                    byte[] keyBytes = Base64.getDecoder().decode(encodedKey);
                    SecretKeySpec key = new SecretKeySpec(keyBytes, "AES");
                    fe = new FileEncryptor(key);
                } else {
                    fe = new FileEncryptor();
                    byte[] keyBytes = fe.getEncryptor().getKey().getEncoded();
                    String encodedKey = Base64.getEncoder().encodeToString(keyBytes);
                    System.out.println("Base64 encoded key: " + encodedKey);
                }
                try {
                    if (cmd.hasOption("d")) {
                        fe.decrypt(inFile, outFile);
                        break block13;
                    }
                    fe.encrypt(inFile, outFile);
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                catch (GeneralSecurityException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                HelpFormatter formatter = new HelpFormatter();
                formatter.printHelp(FileEncryptor.class.getSimpleName(), options);
            }
        }
        System.exit(0);
    }
}

