/*
 * This Kotlin source file was generated by the Gradle 'init' task.
 */
package com.github.masahitojp.bqdatamapper4k

import com.google.api.services.bigquery.model.TableRow
import java.text.SimpleDateFormat
import java.util.TimeZone
import java.util.Date


inline fun <reified T> TableRow.toDataClass(): T {
    return this.toMap().toDataClass()
}

fun toTableRow(json: String): TableRow {
    val sourceDateFormat = SimpleDateFormat("yyyy-MM-dd HH:mm:ss")
    sourceDateFormat.timeZone = TimeZone.getTimeZone("UTC")

    val outputRow = gson.fromJson(json, TableRow::class.java)
    if (outputRow.containsKey("timestamp")) {
        outputRow["timestamp"] = sourceDateFormat.format(Date())
    }
    return outputRow
}