/*
 * Decompiled with CFR 0.152.
 */
package com.github.masahitojp.nineteen;

import com.github.masahitojp.nineteen.Token;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class Scanner {
    private int count = 0;
    private final List<Integer> rule = Arrays.asList(5, 7, 5);
    private final int ruleFullCount = this.rule.stream().mapToInt(s -> s).sum();
    private final List<Integer> rulePhraseLengths = IntStream.rangeClosed(1, this.rule.size()).map(i -> this.rule.subList(0, i).stream().mapToInt(Integer::intValue).sum()).boxed().collect(Collectors.toList());
    final List<Token> tokens;
    final boolean exactly;

    public Scanner(List<Token> tokens, boolean exactly) {
        this.tokens = tokens;
        this.exactly = exactly;
    }

    public List<List<Token>> scan() {
        ArrayList<List<Token>> phrases = new ArrayList<List<Token>>();
        if (this.hasValidFirstNode()) {
            for (Token token : this.tokens) {
                if (this.consume(token, phrases)) {
                    if (this.exactly || !this.satisfied(phrases)) continue;
                    return phrases;
                }
                return null;
            }
            if (this.satisfied(phrases)) {
                return phrases;
            }
            return null;
        }
        return null;
    }

    private boolean consume(Token token, List<List<Token>> phrases) {
        if (token.getPronunciationLength() > this.maxConsumableLength()) {
            return false;
        }
        if (!token.elementOfIkku()) {
            return false;
        }
        if (this.rulePhraseLengths.contains(this.count) && !token.firstOfPhrase()) {
            return false;
        }
        if (token.getPronunciationLength() == this.maxConsumableLength() && !token.lastOfPhrase()) {
            return false;
        }
        if (phrases.size() <= this.phraseIndex()) {
            phrases.add(new ArrayList());
        }
        phrases.get(this.phraseIndex()).add(token);
        this.count += token.getPronunciationLength();
        return true;
    }

    private int maxConsumableLength() {
        return this.rule.subList(0, this.phraseIndex() + 1).stream().mapToInt(z -> z).sum() - this.count;
    }

    private int phraseIndex() {
        int result = this.rule.size() - 1;
        for (int i = 0; i < this.rule.size(); ++i) {
            if (this.count >= this.rule.subList(0, i + 1).stream().mapToInt(z -> z).sum()) continue;
            result = i;
            break;
        }
        return result;
    }

    boolean satisfied(List<List<Token>> phrases) {
        return this.hasFullCount() && this.hasValidLastNode(phrases);
    }

    private boolean hasFullCount() {
        return this.count == this.ruleFullCount;
    }

    private boolean hasValidFirstNode() {
        return this.tokens.size() > 0 && this.tokens.get(0).firstOfIkku();
    }

    private boolean hasValidLastNode(List<List<Token>> phrases) {
        if (phrases.size() > 0) {
            int size = Math.max(0, phrases.size() - 1);
            int last = Math.max(0, phrases.get(size).size() - 1);
            return phrases.get(size).get(last).lastOfIkku();
        }
        return false;
    }
}

