/*
 * Decompiled with CFR 0.152.
 */
package com.github.masahitojp.nineteen;

import com.github.masahitojp.nineteen.utils.StringUtils;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Token {
    private final org.atilika.kuromoji.Token token;
    private final String[] feature;
    private Integer pronunciationLength;
    private static List<String> types = Arrays.asList("\u52a9\u8a5e", "\u52a9\u52d5\u8a5e");
    private static List<String> subtype1s = Arrays.asList("\u975e\u81ea\u7acb", "\u63a5\u5c3e");
    private static List<String> rootForms = Arrays.asList("\u3059\u308b", "\u3067\u304d\u308b");
    private List<String> lastOfIkkuTypes = Arrays.asList("\u540d\u8a5e\u63a5\u7d9a", "\u683c\u52a9\u8a5e", "\u4fc2\u52a9\u8a5e", "\u9023\u4f53\u5316", "\u63a5\u7d9a\u52a9\u8a5e", "\u4e26\u7acb\u52a9\u8a5e", "\u526f\u8a5e\u5316", "\u6570\u63a5\u7d9a", "\u9023\u4f53\u8a5e");

    public Token(org.atilika.kuromoji.Token token) {
        this.token = token;
        this.feature = token.getAllFeaturesArray();
    }

    public final synchronized int getPronunciationLength() {
        if (this.pronunciationLength == null) {
            String surfaceForm;
            String reading = this.pronunciation();
            if (reading.equals("") && (surfaceForm = this.token.getSurfaceForm()) != null && !StringUtils.isPureAscii(surfaceForm)) {
                reading = this.zenkakuHiraganaToZenkakuKatakana(this.token.getSurfaceForm());
            }
            Pattern p = Pattern.compile("[^\u30a2\u30a4\u30a6\u30a8\u30aa\u30ab-\u30e2\u30e4\u30e6\u30e8\u30e9-\u30ed\u30ef\u30f2\u30f3\u30f4\u30fc]");
            Matcher m = p.matcher(reading);
            this.pronunciationLength = m.replaceAll("").length();
        }
        return this.pronunciationLength;
    }

    boolean firstOfPhrase() {
        if (types.contains(this.type())) {
            return false;
        }
        if (subtype1s.contains(this.subtype1())) {
            return false;
        }
        return !this.subtype1().equals("\u81ea\u7acb") || !rootForms.contains(this.rootForm());
    }

    boolean firstOfIkku() {
        if (!this.firstOfPhrase()) {
            return false;
        }
        return !this.type().equals("\u8a18\u53f7") || Arrays.asList("\u62ec\u5f27\u958b", "\u62ec\u5f27\u9589").contains(this.subtype1());
    }

    boolean elementOfIkku() {
        return this.token.isKnown();
    }

    boolean notElementOfIkku() {
        return this.token.isUnknown();
    }

    boolean lastOfPhrase() {
        return !this.type().equals("\u63a5\u982d\u8a5e");
    }

    boolean lastOfIkku() {
        if (this.lastOfIkkuTypes.contains(this.type())) {
            return false;
        }
        if (this.conjugation2().equals("\u9023\u7528\u30bf\u63a5\u7d9a")) {
            return false;
        }
        if (this.conjugation1().equals("\u30b5\u5909\u30fb\u30b9\u30eb") && this.conjugation2().equals("\u9023\u7528\u5f62")) {
            return false;
        }
        if (this.type().equals("\u52d5\u8a5e") && Arrays.asList("\u4eee\u5b9a\u5f62", "\u672a\u7136\u5f62").contains(this.conjugation2())) {
            return false;
        }
        return !this.type().equals("\u540d\u8a5e") || !this.subtype1().equals("\u975e\u81ea\u7acb") || !this.pronunciation().equals("\u30f3");
    }

    private String type() {
        return this.feature[0];
    }

    private String subtype1() {
        return this.feature[1];
    }

    private String conjugation1() {
        return this.feature[4];
    }

    private String conjugation2() {
        return this.feature[5];
    }

    private String rootForm() {
        return this.feature[6];
    }

    private String pronunciation() {
        if (this.feature.length >= 9) {
            return this.feature[8];
        }
        return "";
    }

    private String zenkakuHiraganaToZenkakuKatakana(String s) {
        StringBuilder sb = new StringBuilder(s);
        for (int i = 0; i < sb.length(); ++i) {
            char c = sb.charAt(i);
            if (c < '\u3041' || c > '\u3093') continue;
            sb.setCharAt(i, (char)(c - 12353 + 12449));
        }
        return sb.toString();
    }

    public String toString() {
        return this.token.getSurfaceForm();
    }
}

