/*
 * Decompiled with CFR 0.152.
 */
package com.github.masonm;

import com.github.masonm.com.fasterxml.jackson.databind.JsonNode;
import com.github.masonm.com.fasterxml.jackson.databind.ObjectMapper;
import com.github.masonm.com.fasterxml.jackson.databind.node.MissingNode;
import java.io.IOException;
import org.apache.commons.codec.binary.Base64;

public class Jwt {
    private final JsonNode header;
    private final JsonNode payload;

    public Jwt(String token) {
        String[] parts = token.split("\\.");
        if (parts.length < 2) {
            this.header = MissingNode.getInstance();
            this.payload = MissingNode.getInstance();
        } else {
            this.header = this.parsePart(parts[0]);
            this.payload = this.parsePart(parts[1]);
        }
    }

    public static Jwt fromAuthHeader(String authHeader) {
        int separatorIndex = authHeader.indexOf(" ");
        if (separatorIndex == -1) {
            return new Jwt(authHeader);
        }
        return new Jwt(authHeader.substring(separatorIndex + 1));
    }

    private JsonNode parsePart(String part) {
        byte[] decodedJwtBody;
        try {
            decodedJwtBody = Base64.decodeBase64(part);
        }
        catch (IllegalArgumentException ex) {
            return MissingNode.getInstance();
        }
        try {
            ObjectMapper mapper = new ObjectMapper();
            return mapper.readValue(decodedJwtBody, JsonNode.class);
        }
        catch (IOException ioe) {
            return MissingNode.getInstance();
        }
    }

    public JsonNode getPayload() {
        return this.payload;
    }

    public JsonNode getHeader() {
        return this.header;
    }
}

