/*
 * Decompiled with CFR 0.152.
 */
package com.github.masonm;

import com.github.masonm.Jwt;
import com.github.masonm.com.fasterxml.jackson.core.type.TypeReference;
import com.github.masonm.com.fasterxml.jackson.databind.JsonNode;
import com.github.masonm.com.fasterxml.jackson.databind.ObjectMapper;
import com.github.tomakehurst.wiremock.extension.Parameters;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.matching.MatchResult;
import com.github.tomakehurst.wiremock.matching.RequestMatcherExtension;
import com.github.tomakehurst.wiremock.matching.RequestPattern;
import com.github.tomakehurst.wiremock.stubbing.SubEvent;
import java.util.Map;
import java.util.Objects;

public class JwtMatcherExtension
extends RequestMatcherExtension {
    public static final String NAME = "jwt-matcher";
    public static final String PARAM_NAME_PAYLOAD = "payload";
    public static final String PARAM_NAME_HEADER = "header";
    public static final String PARAM_NAME_REQUEST = "request";

    public String getName() {
        return NAME;
    }

    public MatchResult match(Request request, Parameters parameters) {
        Parameters requestParameters;
        RequestPattern requestPattern;
        if (!parameters.containsKey((Object)PARAM_NAME_PAYLOAD) && !parameters.containsKey((Object)PARAM_NAME_HEADER)) {
            return MatchResult.noMatch((SubEvent[])new SubEvent[0]);
        }
        if (parameters.containsKey((Object)PARAM_NAME_REQUEST) && !(requestPattern = (RequestPattern)(requestParameters = Parameters.of((Object)parameters.get((Object)PARAM_NAME_REQUEST))).as(RequestPattern.class)).match(request).isExactMatch()) {
            return MatchResult.noMatch((SubEvent[])new SubEvent[0]);
        }
        String authString = request.getHeader("Authorization");
        if (authString == null || authString.isEmpty()) {
            return MatchResult.noMatch((SubEvent[])new SubEvent[0]);
        }
        Jwt token = Jwt.fromAuthHeader(authString);
        if (parameters.containsKey((Object)PARAM_NAME_HEADER) && !this.matchParams(token.getHeader(), parameters.get((Object)PARAM_NAME_HEADER))) {
            return MatchResult.noMatch((SubEvent[])new SubEvent[0]);
        }
        if (parameters.containsKey((Object)PARAM_NAME_PAYLOAD) && !this.matchParams(token.getPayload(), parameters.get((Object)PARAM_NAME_PAYLOAD))) {
            return MatchResult.noMatch((SubEvent[])new SubEvent[0]);
        }
        return MatchResult.exactMatch((SubEvent[])new SubEvent[0]);
    }

    private boolean matchParams(JsonNode tokenValues, Object parameters) {
        Map<String, JsonNode> parameterMap = new ObjectMapper().convertValue(parameters, new TypeReference<Map<String, JsonNode>>(){});
        for (Map.Entry<String, JsonNode> entry : parameterMap.entrySet()) {
            JsonNode tokenValue = tokenValues.path(entry.getKey());
            if (Objects.equals(tokenValue, entry.getValue())) continue;
            return false;
        }
        return true;
    }
}

