/*
 * Decompiled with CFR 0.152.
 */
package com.github.masonm;

import com.github.masonm.Jwt;
import com.github.masonm.com.fasterxml.jackson.core.type.TypeReference;
import com.github.masonm.com.fasterxml.jackson.databind.ObjectMapper;
import com.github.tomakehurst.wiremock.common.FileSource;
import com.github.tomakehurst.wiremock.extension.Parameters;
import com.github.tomakehurst.wiremock.extension.StubMappingTransformer;
import com.github.tomakehurst.wiremock.matching.CustomMatcherDefinition;
import com.github.tomakehurst.wiremock.matching.MultiValuePattern;
import com.github.tomakehurst.wiremock.matching.RequestPattern;
import com.github.tomakehurst.wiremock.stubbing.StubMapping;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class JwtStubMappingTransformer
extends StubMappingTransformer {
    public static final String PAYLOAD_FIELDS = "payloadFields";

    public String getName() {
        return "jwt-stub-mapping-transformer";
    }

    public boolean applyGlobally() {
        return false;
    }

    public StubMapping transform(StubMapping stubMapping, FileSource files, Parameters parameters) {
        if (!parameters.containsKey((Object)PAYLOAD_FIELDS)) {
            return stubMapping;
        }
        if (stubMapping.getRequest().getCustomMatcher() != null) {
            return stubMapping;
        }
        Map requestHeaders = stubMapping.getRequest().getHeaders();
        if (requestHeaders == null || !requestHeaders.containsKey("Authorization")) {
            return stubMapping;
        }
        String authHeader = ((MultiValuePattern)requestHeaders.get("Authorization")).getExpected();
        Parameters requestMatcherParameters = this.getRequestMatcherParameter(Jwt.fromAuthHeader(authHeader), parameters.get((Object)PAYLOAD_FIELDS));
        if (requestMatcherParameters == null) {
            return stubMapping;
        }
        CustomMatcherDefinition customMatcher = new CustomMatcherDefinition("jwt-matcher", requestMatcherParameters);
        RequestPattern newRequest = this.getRequestPattern(stubMapping.getRequest(), customMatcher);
        stubMapping.setRequest(newRequest);
        return stubMapping;
    }

    private RequestPattern getRequestPattern(RequestPattern outer, CustomMatcherDefinition customMatcher) {
        LinkedHashMap newHeaders = null;
        if (outer.getHeaders() != null) {
            newHeaders = new LinkedHashMap(outer.getHeaders());
            newHeaders.remove("Authorization");
            if (newHeaders.isEmpty()) {
                newHeaders = null;
            }
        }
        return new RequestPattern(outer.getScheme(), outer.getHost(), outer.getPort(), outer.getUrlMatcher(), outer.getMethod(), newHeaders, outer.getPathParameters(), outer.getQueryParameters(), outer.getFormParameters(), outer.getCookies(), outer.getBasicAuthCredentials(), outer.getBodyPatterns(), customMatcher, null, outer.getMultipartPatterns());
    }

    private Parameters getRequestMatcherParameter(Jwt token, Object payloadParamValue) {
        if (token.getPayload().isMissingNode()) {
            return null;
        }
        Iterable<String> payloadFields = new ObjectMapper().convertValue(payloadParamValue, new TypeReference<Iterable<String>>(){});
        Parameters params = new Parameters();
        HashMap<String, String> payload = new HashMap<String, String>();
        for (String field : payloadFields) {
            payload.put(field, token.getPayload().path(field).asText());
        }
        params.put((Object)"payload", payload);
        return params;
    }
}

