/*
 * Decompiled with CFR 0.152.
 */
package com.github.mathieudebrito.translator;

import java.util.ArrayList;
import java.util.List;

public enum Language {
    AUTO_DETECT(""),
    AFRIKAANS("af"),
    ALBANIAN("sq"),
    ARABIC("ar"),
    ARMENIAN("hy"),
    AZERBAIJANI("az"),
    BASQUE("eu"),
    BELARUSIAN("be"),
    BENGALI("bn"),
    BULGARIAN("bg"),
    BURMESE("my"),
    CATALAN("ca"),
    CHINESE("zh"),
    CHINESE_SIMPLIFIED("zh-CN"),
    CHINESE_TRADITIONAL("zh-TW"),
    CROATIAN("hr"),
    CZECH("cs"),
    DANISH("da"),
    DUTCH("nl"),
    ENGLISH("en"),
    ESPERANTO("eo"),
    ESTONIAN("et"),
    FILIPINO("tl"),
    FINNISH("fi"),
    FRENCH("fr"),
    GALICIAN("gl"),
    GEORGIAN("ka"),
    GERMAN("de"),
    GREEK("el"),
    GUJARATI("gu"),
    HEBREW("iw"),
    HINDI("hi"),
    HUNGARIAN("hu"),
    ICELANDIC("is"),
    INDONESIAN("id"),
    IRISH("ga"),
    ITALIAN("it"),
    JAPANESE("ja"),
    KANNADA("kn"),
    KAZAKH("kk"),
    KHMER("km"),
    KOREAN("ko"),
    LAOTHIAN("lo"),
    LATVIAN("lv"),
    LITHUANIAN("lt"),
    MACEDONIAN("mk"),
    MALAY("ms"),
    MALAYALAM("ml"),
    MALTESE("mt"),
    MARATHI("mr"),
    MONGOLIAN("mn"),
    NEPALI("ne"),
    NORWEGIAN("no"),
    PERSIAN("fa"),
    POLISH("pl"),
    PORTUGUESE("pt"),
    PUNJABI("pa"),
    ROMANIAN("ro"),
    RUSSIAN("ru"),
    SERBIAN("sr"),
    SINHALESE("si"),
    SLOVAK("sk"),
    SLOVENIAN("sl"),
    SPANISH("es"),
    SWAHILI("sw"),
    SWEDISH("sv"),
    TAJIK("tg"),
    TAMIL("ta"),
    TAGALOG("tl"),
    TELUGU("te"),
    THAI("th"),
    TURKISH("tr"),
    UKRANIAN("uk"),
    URDU("ur"),
    UZBEK("uz"),
    VIETNAMESE("vi"),
    WELSH("cy"),
    YIDDISH("yi");

    private final String language;

    private Language(String pLanguage) {
        this.language = pLanguage;
    }

    public static Language fromString(String pLanguage) {
        for (Language l : Language.values()) {
            if (!l.toString().equals(pLanguage)) continue;
            return l;
        }
        return null;
    }

    public String toString() {
        return this.language;
    }

    public static List<Language> all() {
        ArrayList<Language> languageList = new ArrayList<Language>();
        Language[] possibleValues = Language.values();
        for (int numLanguage = 0; numLanguage < possibleValues.length; ++numLanguage) {
            if (possibleValues[numLanguage].toString().isEmpty()) continue;
            languageList.add(possibleValues[numLanguage]);
        }
        return languageList;
    }

    public static List<Language> toList(Language ... languages) {
        ArrayList<Language> languageList = new ArrayList<Language>();
        for (int numLanguage = 0; numLanguage < languages.length; ++numLanguage) {
            languageList.add(languages[numLanguage]);
        }
        return languageList;
    }

    public static List<Language> getGooglePlayCompliantLanguages() {
        ArrayList<Language> languageList = new ArrayList<Language>();
        languageList.add(AFRIKAANS);
        languageList.add(GERMAN);
        languageList.add(ENGLISH);
        languageList.add(BELARUSIAN);
        languageList.add(BULGARIAN);
        languageList.add(CATALAN);
        languageList.add(CHINESE_SIMPLIFIED);
        languageList.add(CHINESE_TRADITIONAL);
        languageList.add(KOREAN);
        languageList.add(CROATIAN);
        languageList.add(DANISH);
        languageList.add(SPANISH);
        languageList.add(ESTONIAN);
        languageList.add(FILIPINO);
        languageList.add(FINNISH);
        languageList.add(FRENCH);
        languageList.add(GREEK);
        languageList.add(HEBREW);
        languageList.add(HINDI);
        languageList.add(HUNGARIAN);
        languageList.add(INDONESIAN);
        languageList.add(ITALIAN);
        languageList.add(JAPANESE);
        languageList.add(LITHUANIAN);
        languageList.add(MALAY);
        languageList.add(NORWEGIAN);
        languageList.add(PERSIAN);
        languageList.add(POLISH);
        languageList.add(PORTUGUESE);
        languageList.add(ROMANIAN);
        languageList.add(SERBIAN);
        languageList.add(SLOVAK);
        languageList.add(SLOVENIAN);
        languageList.add(SWEDISH);
        languageList.add(SWAHILI);
        languageList.add(CZECH);
        languageList.add(THAI);
        languageList.add(TURKISH);
        languageList.add(UKRANIAN);
        languageList.add(VIETNAMESE);
        return languageList;
    }
}

