/*
 * Decompiled with CFR 0.152.
 */
package com.github.mathieudebrito.translator.generators.android;

import com.github.mathieudebrito.translator.Language;
import com.github.mathieudebrito.translator.generators.FileGenerator;
import com.github.mathieudebrito.translator.utils.Files;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ResourcesStringsFileGenerator
implements FileGenerator {
    @Override
    public void writeEntries(String path, Language language, Map<String, String> translations) {
        StringBuilder content = new StringBuilder();
        content = content.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n");
        content = content.append("<resources>\n");
        for (String key : translations.keySet()) {
            String value = translations.get(key);
            content = content.append("\t<string name=\"" + key + "\">" + value + "</string>" + "\n");
        }
        content = content.append("</resources>");
        Files.write(this.getFileNames(path, language), content.toString());
    }

    @Override
    public String encode(String text) {
        if (text.contains("'") || text.contains("\"")) {
            text = "<![CDATA[" + text.trim() + "]]>";
        }
        return text;
    }

    @Override
    public List<String> getFileNames(String path, Language language) {
        ArrayList<String> fileNames = new ArrayList<String>();
        String fileName = path + "/values-";
        fileName = language.toString().equalsIgnoreCase(Language.CHINESE_SIMPLIFIED.toString()) ? fileName.concat("zh-rCN") : (language.toString().equalsIgnoreCase(Language.CHINESE_TRADITIONAL.toString()) ? fileName.concat("zh-rTW") : fileName.concat(language.toString()));
        fileName = fileName.concat("/strings.xml");
        fileNames.add(fileName);
        return fileNames;
    }
}

