/*
 * Decompiled with CFR 0.152.
 */
package com.github.mathieudebrito.translator;

import com.github.mathieudebrito.translator.generators.FileGenerator;
import com.github.mathieudebrito.translator.parsers.FileParser;
import com.google.common.base.Strings;
import java.util.Arrays;
import java.util.List;

public class FileToTranslate {
    public String pathFrom;
    public String pathTo;
    public List<String> fileNamesFrom;
    public String fileNameTo;
    public List<String> fileNameOfEntriesToExclude;
    public FileParser parser;
    public FileGenerator generator;

    private FileToTranslate() {
    }

    public static class Builder {
        public FileToTranslate fileToTranslate = new FileToTranslate();

        public Builder path(String path) {
            this.fileToTranslate.pathFrom = path;
            if (Strings.isNullOrEmpty((String)this.fileToTranslate.pathTo)) {
                this.fileToTranslate.pathTo = path;
            }
            return this;
        }

        public Builder pathTranslated(String pathTranslated) {
            this.fileToTranslate.pathTo = pathTranslated;
            return this;
        }

        public Builder from(String fileNameFrom) {
            this.fileToTranslate.fileNamesFrom = Arrays.asList(fileNameFrom);
            return this;
        }

        public Builder from(String ... fileNamesFrom) {
            this.fileToTranslate.fileNamesFrom = Arrays.asList(fileNamesFrom);
            return this;
        }

        public Builder from(List<String> fileNamesFrom) {
            this.fileToTranslate.fileNamesFrom = fileNamesFrom;
            return this;
        }

        public Builder fileNameOfEntriesToExclude(String fileNameOfEntriesToExclude) {
            this.fileToTranslate.fileNameOfEntriesToExclude = Arrays.asList(fileNameOfEntriesToExclude);
            return this;
        }

        public Builder fileNameOfEntriesToExclude(String ... fileNameOfEntriesToExclude) {
            this.fileToTranslate.fileNameOfEntriesToExclude = Arrays.asList(fileNameOfEntriesToExclude);
            return this;
        }

        public Builder fileNameOfEntriesToExclude(List<String> fileNameOfEntriesToExclude) {
            this.fileToTranslate.fileNameOfEntriesToExclude = fileNameOfEntriesToExclude;
            return this;
        }

        public Builder to(String fileNameTo) {
            this.fileToTranslate.fileNameTo = fileNameTo;
            return this;
        }

        public Builder parser(FileParser parser) {
            this.fileToTranslate.parser = parser;
            return this;
        }

        public Builder generator(FileGenerator generator) {
            this.fileToTranslate.generator = generator;
            return this;
        }

        public FileToTranslate build() {
            return this.fileToTranslate;
        }
    }
}

