/*
 * Decompiled with CFR 0.152.
 */
package com.github.mathieudebrito.translator.generators.android;

import com.github.mathieudebrito.translator.Language;
import com.github.mathieudebrito.translator.generators.FileGenerator;
import com.github.mathieudebrito.translator.utils.Files;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ResourcesStringsFileGenerator
implements FileGenerator {
    public static String[] specialCharacters = new String[]{"'", "\"", "<", ">"};

    @Override
    public void writeEntries(String pathTo, String fileNameTo, Language language, Map<String, String> translations) {
        StringBuilder content = new StringBuilder();
        content = content.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n");
        content = content.append("<resources>\n");
        for (String key : translations.keySet()) {
            String value = translations.get(key);
            content = content.append("\t<string name=\"" + key + "\">" + value + "</string>" + "\n");
        }
        content = content.append("</resources>");
        Files.write(this.getFileNames(pathTo, fileNameTo, language), content.toString());
    }

    @Override
    public String encode(String text) {
        boolean contains = false;
        for (String specialCharacter : specialCharacters) {
            if (!text.contains(specialCharacter)) continue;
            contains = true;
            break;
        }
        if (contains) {
            text = "<![CDATA[" + text.trim() + "]]>";
        }
        if (text.contains("'")) {
            text = text.replace("'", "\\'");
        }
        return text;
    }

    @Override
    public List<String> getFileNames(String pathTo, String fileNameTo, Language language) {
        ArrayList<String> fileNames = new ArrayList<String>();
        String fileName = pathTo + "/values-";
        fileName = language.toString().equalsIgnoreCase(Language.CHINESE_SIMPLIFIED.toString()) ? fileName.concat("zh-rCN") : (language.toString().equalsIgnoreCase(Language.CHINESE_TRADITIONAL.toString()) ? fileName.concat("zh-rTW") : fileName.concat(language.toString()));
        fileName = fileName.concat("/" + fileNameTo);
        fileNames.add(fileName);
        return fileNames;
    }
}

