/*
 * Decompiled with CFR 0.152.
 */
package com.github.mathieudebrito.translator.parsers.ios;

import com.github.mathieudebrito.translator.Language;
import com.github.mathieudebrito.translator.parsers.FileParser;
import com.google.common.base.Strings;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class IOSLocalizedStringsFileParser
implements FileParser {
    public static final boolean LOG_ENABLED = true;

    @Override
    public Map<String, String> readEntries(String path, List<String> fileNamesFrom, Language languageFrom) {
        TreeMap<String, String> entries = new TreeMap<String, String>();
        for (String fileName : fileNamesFrom) {
            entries.putAll(this.readEntries(path, fileName, languageFrom));
        }
        return entries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<String, String> readEntries(String path, String fileNameFrom, Language languageFrom) {
        TreeMap<String, String> entries = new TreeMap<String, String>();
        try {
            BufferedReader br = null;
            StringBuilder sb = new StringBuilder();
            try {
                File file = new File(this.getFilename(path, fileNameFrom, languageFrom));
                br = new BufferedReader(new FileReader(file));
                String line = br.readLine();
                while (line != null) {
                    line = line.trim();
                    boolean isEmpty = Strings.isNullOrEmpty((String)line);
                    boolean beginWithQuote = line.startsWith("\"");
                    boolean containsEqual = line.contains("=");
                    boolean endsWithSemiColon = line.endsWith(";");
                    if (!isEmpty && beginWithQuote && containsEqual && endsWithSemiColon) {
                        String[] keyValue = line.trim().replace("\"", "").replace(";", "").split("=");
                        String key = keyValue[0].trim();
                        String value = keyValue[1].trim();
                        System.out.println(key + " = " + value);
                        entries.put(key, value);
                    } else {
                        System.out.println("[SKIPPED] line : '" + line + "'");
                    }
                    line = br.readLine();
                }
                return entries;
            }
            catch (Exception e) {
                e.printStackTrace();
                Map<String, String> map = null;
                return map;
            }
            finally {
                try {
                    br.close();
                }
                catch (Exception e4) {
                    e4.printStackTrace();
                    return null;
                }
            }
        }
        catch (Exception e3) {
            e3.printStackTrace();
            System.out.println("[ERROR] file may not be found : " + this.getFilename(path, fileNameFrom, languageFrom));
            return null;
        }
    }

    @Override
    public String decode(String text) {
        return text.trim();
    }

    @Override
    public String getFilename(String path, String fileNameFrom, Language language) {
        return path + "/Base.lproj/Localizable.strings";
    }
}

