/*
 * Decompiled with CFR 0.152.
 */
package com.github.matsluni.akkahttpspi;

import akka.http.scaladsl.model.ContentType;
import akka.http.scaladsl.model.ContentType$;
import akka.http.scaladsl.model.ContentTypes$;
import akka.http.scaladsl.model.HttpCharset$;
import akka.http.scaladsl.model.HttpEntity;
import akka.http.scaladsl.model.HttpEntity$;
import akka.http.scaladsl.model.HttpHeader;
import akka.http.scaladsl.model.HttpHeader$;
import akka.http.scaladsl.model.HttpMethod;
import akka.http.scaladsl.model.HttpMethods$;
import akka.http.scaladsl.model.HttpProtocols$;
import akka.http.scaladsl.model.HttpRequest;
import akka.http.scaladsl.model.HttpRequest$;
import akka.http.scaladsl.model.MediaType;
import akka.http.scaladsl.model.MediaType$;
import akka.http.scaladsl.model.RequestEntity;
import akka.http.scaladsl.model.RequestEntityAcceptance;
import akka.http.scaladsl.model.Uri$;
import akka.http.scaladsl.model.headers.Content$minusLength$;
import akka.http.scaladsl.model.headers.Content$minusType$;
import akka.stream.scaladsl.Source;
import akka.stream.scaladsl.Source$;
import akka.util.ByteString;
import akka.util.ByteString$;
import com.github.matsluni.akkahttpspi.AkkaHttpClient;
import com.github.matsluni.akkahttpspi.AkkaHttpClient$AkkaHttpClientBuilder$;
import java.nio.ByteBuffer;
import java.util.Map;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map$;
import scala.collection.immutable.StringOps;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.jdk.CollectionConverters$;
import scala.runtime.Nothing$;
import software.amazon.awssdk.http.SdkHttpRequest;
import software.amazon.awssdk.http.async.SdkHttpContentPublisher;

public final class AkkaHttpClient$ {
    public static final AkkaHttpClient$ MODULE$;
    private final Logger logger;
    private ContentType.Binary xAmzJson;
    private ContentType.Binary xAmzJson11;
    private ContentType.Binary xAmzCbor11;
    private ContentType.WithCharset formUrlEncoded;
    private ContentType.Binary applicationXml;
    private scala.collection.immutable.Map<String, ContentType> contentTypeMap;
    private volatile byte bitmap$0;

    static {
        new AkkaHttpClient$();
    }

    private ContentType.Binary xAmzJson$lzycompute() {
        AkkaHttpClient$ akkaHttpClient$ = this;
        synchronized (akkaHttpClient$) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.xAmzJson = ContentType$.MODULE$.apply(MediaType$.MODULE$.customBinary("application", "x-amz-json-1.0", (MediaType.Compressibility)MediaType.Compressible$.MODULE$, MediaType$.MODULE$.customBinary$default$4(), MediaType$.MODULE$.customBinary$default$5(), MediaType$.MODULE$.customBinary$default$6()));
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.xAmzJson;
        }
    }

    private ContentType.Binary xAmzJson11$lzycompute() {
        AkkaHttpClient$ akkaHttpClient$ = this;
        synchronized (akkaHttpClient$) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.xAmzJson11 = ContentType$.MODULE$.apply(MediaType$.MODULE$.customBinary("application", "x-amz-json-1.1", (MediaType.Compressibility)MediaType.Compressible$.MODULE$, MediaType$.MODULE$.customBinary$default$4(), MediaType$.MODULE$.customBinary$default$5(), MediaType$.MODULE$.customBinary$default$6()));
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.xAmzJson11;
        }
    }

    private ContentType.Binary xAmzCbor11$lzycompute() {
        AkkaHttpClient$ akkaHttpClient$ = this;
        synchronized (akkaHttpClient$) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.xAmzCbor11 = ContentType$.MODULE$.apply(MediaType$.MODULE$.customBinary("application", "x-amz-cbor-1.1", (MediaType.Compressibility)MediaType.Compressible$.MODULE$, MediaType$.MODULE$.customBinary$default$4(), MediaType$.MODULE$.customBinary$default$5(), MediaType$.MODULE$.customBinary$default$6()));
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
            return this.xAmzCbor11;
        }
    }

    private ContentType.WithCharset formUrlEncoded$lzycompute() {
        AkkaHttpClient$ akkaHttpClient$ = this;
        synchronized (akkaHttpClient$) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.formUrlEncoded = ContentType$.MODULE$.apply(MediaType$.MODULE$.applicationWithOpenCharset("x-www-form-urlencoded", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])), HttpCharset$.MODULE$.custom("utf-8", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])));
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
            return this.formUrlEncoded;
        }
    }

    private ContentType.Binary applicationXml$lzycompute() {
        AkkaHttpClient$ akkaHttpClient$ = this;
        synchronized (akkaHttpClient$) {
            if ((byte)(this.bitmap$0 & 0x10) == 0) {
                this.applicationXml = ContentType$.MODULE$.apply(MediaType$.MODULE$.customBinary("application", "xml", (MediaType.Compressibility)MediaType.Compressible$.MODULE$, MediaType$.MODULE$.customBinary$default$4(), MediaType$.MODULE$.customBinary$default$5(), MediaType$.MODULE$.customBinary$default$6()));
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
            }
            return this.applicationXml;
        }
    }

    private scala.collection.immutable.Map contentTypeMap$lzycompute() {
        AkkaHttpClient$ akkaHttpClient$ = this;
        synchronized (akkaHttpClient$) {
            if ((byte)(this.bitmap$0 & 0x20) == 0) {
                this.contentTypeMap = (scala.collection.immutable.Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"application/x-amz-json-1.0"), (Object)this.xAmzJson()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"application/x-amz-json-1.1"), (Object)this.xAmzJson11()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"application/x-amz-cbor-1.1"), (Object)this.xAmzCbor11()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"application/x-www-form-urlencoded; charset-UTF-8"), (Object)this.formUrlEncoded()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"application/x-www-form-urlencoded"), (Object)this.formUrlEncoded()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"application/xml"), (Object)this.applicationXml())}));
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x20);
            }
            return this.contentTypeMap;
        }
    }

    public Logger logger() {
        return this.logger;
    }

    public HttpRequest toAkkaRequest(SdkHttpRequest request, SdkHttpContentPublisher contentPublisher) {
        Tuple2<Option<HttpHeader>, scala.collection.immutable.Seq<HttpHeader>> tuple2 = this.convertHeaders(request.headers());
        if (tuple2 != null) {
            Tuple2 tuple22;
            Option contentTypeHeader = (Option)tuple2._1();
            scala.collection.immutable.Seq reqheaders = (scala.collection.immutable.Seq)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)contentTypeHeader, (Object)reqheaders);
            Option contentTypeHeader2 = (Option)tuple23._1();
            scala.collection.immutable.Seq reqheaders2 = (scala.collection.immutable.Seq)tuple23._2();
            HttpMethod method = this.convertMethod(request.method().name());
            return HttpRequest$.MODULE$.apply(method, Uri$.MODULE$.apply(request.getUri().toString()), reqheaders2, this.entityForMethodAndContentType(method, this.contentTypeHeaderToContentType((Option<HttpHeader>)contentTypeHeader2), contentPublisher), HttpProtocols$.MODULE$.HTTP$div1$u002E1());
        }
        throw new MatchError(tuple2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public RequestEntity entityForMethodAndContentType(HttpMethod method, ContentType contentType, SdkHttpContentPublisher contentPublisher) {
        HttpEntity.Chunked chunked;
        RequestEntityAcceptance requestEntityAcceptance = method.requestEntityAcceptance();
        if (!RequestEntityAcceptance.Expected$.MODULE$.equals(requestEntityAcceptance)) return HttpEntity$.MODULE$.Empty();
        Option option = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(contentPublisher.contentLength()));
        if (option instanceof Some) {
            Some some = (Some)option;
            Long length = (Long)some.x();
            chunked = HttpEntity$.MODULE$.apply(contentType, Predef$.MODULE$.Long2long(length), (Source)Source$.MODULE$.fromPublisher((Publisher)contentPublisher).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final ByteString apply(ByteBuffer x$2) {
                    return ByteString$.MODULE$.apply(x$2);
                }
            }));
            return chunked;
        } else {
            if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
            chunked = HttpEntity$.MODULE$.apply(contentType, (Source)Source$.MODULE$.fromPublisher((Publisher)contentPublisher).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final ByteString apply(ByteBuffer x$3) {
                    return ByteString$.MODULE$.apply(x$3);
                }
            }));
        }
        return chunked;
    }

    public HttpMethod convertMethod(String method) {
        return (HttpMethod)HttpMethods$.MODULE$.getForKeyCaseInsensitive(method, Predef$.MODULE$.$conforms()).getOrElse((Function0)new Serializable(method){
            public static final long serialVersionUID = 0L;
            private final String method$1;

            public final Nothing$ apply() {
                throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Method not configured: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.method$1})));
            }
            {
                this.method$1 = method$1;
            }
        });
    }

    public ContentType contentTypeHeaderToContentType(Option<HttpHeader> contentTypeHeader) {
        return (ContentType)contentTypeHeader.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(HttpHeader x$4) {
                return x$4.value();
            }
        }).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final ContentType apply(String v) {
                return (ContentType)AkkaHttpClient$.MODULE$.contentTypeMap().getOrElse((Object)v, (Function0)new Serializable(this, v){
                    public static final long serialVersionUID = 0L;
                    private final String v$1;

                    public final ContentType apply() {
                        return AkkaHttpClient$.MODULE$.tryCreateCustomContentType(this.v$1);
                    }
                    {
                        this.v$1 = v$1;
                    }
                });
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final ContentType.Binary apply() {
                return ContentTypes$.MODULE$.NoContentType();
            }
        });
    }

    public Tuple2<Option<HttpHeader>, scala.collection.immutable.Seq<HttpHeader>> convertHeaders(Map<String, java.util.List<String>> headers) {
        return (Tuple2)((TraversableOnce)CollectionConverters$.MODULE$.mapAsScalaMapConverter(headers).asScala()).foldLeft((Object)new Tuple2((Object)Option$.MODULE$.empty(), (Object)List$.MODULE$.empty()), (Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Option<HttpHeader>, List<HttpHeader>> apply(Tuple2<Option<HttpHeader>, List<HttpHeader>> x0$1, Tuple2<String, java.util.List<String>> x1$1) {
                Tuple2 tuple2;
                block5: {
                    Tuple2 tuple22;
                    block6: {
                        HttpHeader.ParsingResult parsingResult;
                        block9: {
                            Tuple2 tuple23;
                            block8: {
                                Tuple2 tuple24;
                                java.util.List headerValue;
                                String headerName;
                                List hdrs;
                                Option ctHeader;
                                block7: {
                                    Tuple2 tuple25;
                                    tuple2 = new Tuple2(x0$1, x1$1);
                                    if (tuple2 == null) break block5;
                                    Tuple2 tuple26 = (Tuple2)tuple2._1();
                                    Tuple2 header = (Tuple2)tuple2._2();
                                    if (tuple26 == null) break block5;
                                    ctHeader = (Option)tuple26._1();
                                    hdrs = (List)tuple26._2();
                                    tuple22 = header;
                                    if (tuple22 == null) break block6;
                                    String headerName2 = (String)tuple22._1();
                                    java.util.List headerValue2 = (java.util.List)tuple22._2();
                                    Tuple2 tuple27 = tuple25 = new Tuple2((Object)headerName2, (Object)headerValue2);
                                    headerName = (String)tuple27._1();
                                    headerValue = (java.util.List)tuple27._2();
                                    if (headerValue.size() != 1) {
                                        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Found invalid header: key: ", ", Value: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{headerName, ((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter(headerValue).asScala()).toList()})));
                                    }
                                    String string = Content$minusLength$.MODULE$.lowercaseName();
                                    String string2 = headerName.toLowerCase();
                                    if (string != null ? !string.equals(string2) : string2 != null) break block7;
                                    tuple23 = new Tuple2((Object)ctHeader, (Object)hdrs);
                                    break block8;
                                }
                                parsingResult = HttpHeader$.MODULE$.parse(headerName, (String)headerValue.get(0), HttpHeader$.MODULE$.parse$default$3());
                                if (!(parsingResult instanceof HttpHeader.ParsingResult$.Ok)) break block9;
                                HttpHeader.ParsingResult$.Ok ok = (HttpHeader.ParsingResult$.Ok)parsingResult;
                                String string = ok.header().lowercaseName();
                                String string3 = Content$minusType$.MODULE$.lowercaseName();
                                tuple23 = tuple24 = !(string != null ? !string.equals(string3) : string3 != null) ? new Tuple2((Object)new Some((Object)ok.header()), (Object)hdrs) : new Tuple2((Object)ctHeader, hdrs.$colon$plus((Object)ok.header(), List$.MODULE$.canBuildFrom()));
                            }
                            Tuple2 tuple28 = tuple23;
                            return tuple28;
                        }
                        if (parsingResult instanceof HttpHeader.ParsingResult$.Error) {
                            HttpHeader.ParsingResult$.Error error = (HttpHeader.ParsingResult$.Error)parsingResult;
                            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Found invalid header: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{error.errors()})));
                        }
                        throw new MatchError((Object)parsingResult);
                    }
                    throw new MatchError((Object)tuple22);
                }
                throw new MatchError((Object)tuple2);
            }
        });
    }

    public ContentType tryCreateCustomContentType(String contentTypeStr) {
        this.logger().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Try to parse content type from ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{contentTypeStr})));
        String[] mainAndsubType = new StringOps(Predef$.MODULE$.augmentString(contentTypeStr)).split('/');
        if (mainAndsubType.length == 2) {
            return ContentType$.MODULE$.apply(MediaType$.MODULE$.customBinary(mainAndsubType[0], mainAndsubType[1], (MediaType.Compressibility)MediaType.Compressible$.MODULE$, MediaType$.MODULE$.customBinary$default$4(), MediaType$.MODULE$.customBinary$default$5(), MediaType$.MODULE$.customBinary$default$6()));
        }
        throw new RuntimeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not parse custom content type '", "'."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{contentTypeStr})));
    }

    public AkkaHttpClient.AkkaHttpClientBuilder builder() {
        return new AkkaHttpClient.AkkaHttpClientBuilder(AkkaHttpClient$AkkaHttpClientBuilder$.MODULE$.apply$default$1(), AkkaHttpClient$AkkaHttpClientBuilder$.MODULE$.apply$default$2(), AkkaHttpClient$AkkaHttpClientBuilder$.MODULE$.apply$default$3());
    }

    public ContentType.Binary xAmzJson() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.xAmzJson$lzycompute() : this.xAmzJson;
    }

    public ContentType.Binary xAmzJson11() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.xAmzJson11$lzycompute() : this.xAmzJson11;
    }

    public ContentType.Binary xAmzCbor11() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.xAmzCbor11$lzycompute() : this.xAmzCbor11;
    }

    public ContentType.WithCharset formUrlEncoded() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.formUrlEncoded$lzycompute() : this.formUrlEncoded;
    }

    public ContentType.Binary applicationXml() {
        return (byte)(this.bitmap$0 & 0x10) == 0 ? this.applicationXml$lzycompute() : this.applicationXml;
    }

    public scala.collection.immutable.Map<String, ContentType> contentTypeMap() {
        return (byte)(this.bitmap$0 & 0x20) == 0 ? this.contentTypeMap$lzycompute() : this.contentTypeMap;
    }

    private AkkaHttpClient$() {
        MODULE$ = this;
        this.logger = LoggerFactory.getLogger(this.getClass());
    }
}

