/*
 * Decompiled with CFR 0.152.
 */
package com.github.matsluni.akkahttpspi;

import akka.http.scaladsl.model.ContentType;
import akka.http.scaladsl.model.ContentType$;
import akka.http.scaladsl.model.HttpCharset$;
import akka.http.scaladsl.model.HttpEntity;
import akka.http.scaladsl.model.HttpEntity$;
import akka.http.scaladsl.model.HttpHeader;
import akka.http.scaladsl.model.HttpHeader$;
import akka.http.scaladsl.model.HttpMethod;
import akka.http.scaladsl.model.HttpMethods$;
import akka.http.scaladsl.model.HttpProtocols$;
import akka.http.scaladsl.model.HttpRequest;
import akka.http.scaladsl.model.HttpRequest$;
import akka.http.scaladsl.model.MediaType;
import akka.http.scaladsl.model.MediaType$;
import akka.http.scaladsl.model.RequestEntity;
import akka.http.scaladsl.model.RequestEntityAcceptance;
import akka.http.scaladsl.model.Uri$;
import akka.stream.scaladsl.Source;
import akka.stream.scaladsl.Source$;
import akka.util.ByteString$;
import com.github.matsluni.akkahttpspi.AkkaHttpClient;
import com.github.matsluni.akkahttpspi.AkkaHttpClient$AkkaHttpClientBuilder$;
import java.io.Serializable;
import java.util.Map;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.JavaConverters$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import software.amazon.awssdk.http.SdkHttpRequest;
import software.amazon.awssdk.http.async.SdkHttpContentPublisher;

public final class AkkaHttpClient$ {
    public static AkkaHttpClient$ MODULE$;
    private ContentType.Binary xAmzJson;
    private ContentType.Binary xAmzJson11;
    private ContentType.WithCharset formUrlEncoded;
    private ContentType.Binary applicationXml;
    private final Logger logger;
    private volatile byte bitmap$0;

    static {
        new AkkaHttpClient$();
    }

    public Logger logger() {
        return this.logger;
    }

    public HttpRequest toAkkaRequest(SdkHttpRequest request, SdkHttpContentPublisher contentPublisher) {
        List<HttpHeader> headers = this.convertHeaders(request.headers());
        HttpMethod method = this.convertMethod(request.method().name());
        return HttpRequest$.MODULE$.apply(method, Uri$.MODULE$.apply(request.getUri().toString()), this.filterContentTypeAndContentLengthHeader((Seq<HttpHeader>)headers), this.entityForMethodAndContentType(method, this.contentTypeHeaderToContentType(headers), contentPublisher), HttpProtocols$.MODULE$.HTTP$div1$u002E1());
    }

    public RequestEntity entityForMethodAndContentType(HttpMethod method, ContentType contentType, SdkHttpContentPublisher contentPublisher) {
        HttpEntity.Strict strict;
        RequestEntityAcceptance requestEntityAcceptance = method.requestEntityAcceptance();
        if (RequestEntityAcceptance.Expected$.MODULE$.equals(requestEntityAcceptance)) {
            HttpEntity.Chunked chunked;
            Option option = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(contentPublisher.contentLength()));
            if (option instanceof Some) {
                Some some = (Some)option;
                Long length = (Long)some.value();
                chunked = HttpEntity$.MODULE$.apply(contentType, Predef$.MODULE$.Long2long(length), (Source)Source$.MODULE$.fromPublisher((Publisher)contentPublisher).map((Function1 & Serializable & scala.Serializable)x$1 -> ByteString$.MODULE$.apply(x$1)));
            } else if (None$.MODULE$.equals(option)) {
                chunked = HttpEntity$.MODULE$.apply(contentType, (Source)Source$.MODULE$.fromPublisher((Publisher)contentPublisher).map((Function1 & Serializable & scala.Serializable)x$2 -> ByteString$.MODULE$.apply(x$2)));
            } else {
                throw new MatchError((Object)option);
            }
            strict = chunked;
        } else {
            strict = HttpEntity$.MODULE$.empty(HttpEntity$.MODULE$.Empty().contentType());
        }
        return strict;
    }

    public HttpMethod convertMethod(String method) {
        return (HttpMethod)HttpMethods$.MODULE$.getForKeyCaseInsensitive(method, Predef$.MODULE$.$conforms()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalArgumentException(new StringBuilder(23).append("Method not configured: ").append(method).toString());
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ContentType contentTypeHeaderToContentType(List<HttpHeader> headers) {
        String string;
        String string2;
        String string3;
        String string4;
        boolean bl = false;
        Some some = null;
        Option option = headers.find((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)AkkaHttpClient$.$anonfun$contentTypeHeaderToContentType$1(x$3))).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.value());
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            String string5 = (String)some.value();
            if ("application/x-amz-json-1.0".equals(string5)) {
                return this.xAmzJson();
            }
        }
        if (bl && "application/x-amz-json-1.1".equals(string4 = (String)some.value())) {
            return this.xAmzJson11();
        }
        if (bl && "application/x-www-form-urlencoded; charset=UTF-8".equals(string3 = (String)some.value())) {
            return this.formUrlEncoded();
        }
        if (bl && "application/x-www-form-urlencoded".equals(string2 = (String)some.value())) {
            return this.formUrlEncoded();
        }
        if (bl && "application/xml".equals(string = (String)some.value())) {
            return this.applicationXml();
        }
        if (bl) {
            String s = (String)some.value();
            return this.tryCreateCustomContentType(s);
        }
        if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
        return this.formUrlEncoded();
    }

    public List<HttpHeader> convertHeaders(Map<String, java.util.List<String>> headers) {
        return ((IterableOnceOps)((IterableOps)JavaConverters$.MODULE$.mapAsScalaMapConverter(headers).asScala()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            HttpHeader httpHeader;
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String key = (String)tuple2._1();
                java.util.List value = (java.util.List)tuple2._2();
                if (value.size() > 1 || value.size() == 0) {
                    throw new IllegalArgumentException(new StringBuilder(36).append("found invalid header: key: ").append(key).append(", Value: ").append(((IterableOnceOps)JavaConverters$.MODULE$.asScalaBufferConverter(value).asScala()).toList()).toString());
                }
                HttpHeader.ParsingResult parsingResult = HttpHeader$.MODULE$.parse(key, (String)value.get(0), HttpHeader$.MODULE$.parse$default$3());
                if (!(parsingResult instanceof HttpHeader.ParsingResult$.Ok)) {
                    if (parsingResult instanceof HttpHeader.ParsingResult$.Error) {
                        HttpHeader.ParsingResult$.Error error = (HttpHeader.ParsingResult$.Error)parsingResult;
                        throw new IllegalArgumentException(new StringBuilder(22).append("found invalid header: ").append(error.errors()).toString());
                    }
                    throw new MatchError((Object)parsingResult);
                }
                HttpHeader.ParsingResult$.Ok ok = (HttpHeader.ParsingResult$.Ok)parsingResult;
                httpHeader = ok.header();
            } else {
                throw new MatchError((Object)tuple2);
            }
            HttpHeader httpHeader2 = httpHeader;
            return httpHeader2;
        })).toList();
    }

    public Seq<HttpHeader> filterContentTypeAndContentLengthHeader(Seq<HttpHeader> headers) {
        return ((IterableOnceOps)headers.filterNot((Function1 & Serializable & scala.Serializable)h -> BoxesRunTime.boxToBoolean((boolean)AkkaHttpClient$.$anonfun$filterContentTypeAndContentLengthHeader$1(h)))).toList();
    }

    public ContentType tryCreateCustomContentType(String contentTypeStr) {
        this.logger().info(new StringBuilder(31).append("Try to parse content type from ").append(contentTypeStr).toString());
        String[] mainAndsubType = StringOps$.MODULE$.split$extension0(Predef$.MODULE$.augmentString(contentTypeStr), '/');
        if (mainAndsubType.length != 2) {
            throw new RuntimeException(new StringBuilder(39).append("Could not parse custom content type '").append(contentTypeStr).append("'.").toString());
        }
        return ContentType$.MODULE$.apply(MediaType$.MODULE$.customBinary(mainAndsubType[0], mainAndsubType[1], (MediaType.Compressibility)MediaType.Compressible$.MODULE$, MediaType$.MODULE$.customBinary$default$4(), MediaType$.MODULE$.customBinary$default$5(), MediaType$.MODULE$.customBinary$default$6()));
    }

    public AkkaHttpClient.AkkaHttpClientBuilder builder() {
        return new AkkaHttpClient.AkkaHttpClientBuilder(AkkaHttpClient$AkkaHttpClientBuilder$.MODULE$.apply$default$1(), AkkaHttpClient$AkkaHttpClientBuilder$.MODULE$.apply$default$2());
    }

    private ContentType.Binary xAmzJson$lzycompute() {
        AkkaHttpClient$ akkaHttpClient$ = this;
        synchronized (akkaHttpClient$) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.xAmzJson = ContentType$.MODULE$.apply(MediaType$.MODULE$.customBinary("application", "x-amz-json-1.0", (MediaType.Compressibility)MediaType.Compressible$.MODULE$, MediaType$.MODULE$.customBinary$default$4(), MediaType$.MODULE$.customBinary$default$5(), MediaType$.MODULE$.customBinary$default$6()));
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.xAmzJson;
    }

    public ContentType.Binary xAmzJson() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.xAmzJson$lzycompute() : this.xAmzJson;
    }

    private ContentType.Binary xAmzJson11$lzycompute() {
        AkkaHttpClient$ akkaHttpClient$ = this;
        synchronized (akkaHttpClient$) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.xAmzJson11 = ContentType$.MODULE$.apply(MediaType$.MODULE$.customBinary("application", "x-amz-json-1.1", (MediaType.Compressibility)MediaType.Compressible$.MODULE$, MediaType$.MODULE$.customBinary$default$4(), MediaType$.MODULE$.customBinary$default$5(), MediaType$.MODULE$.customBinary$default$6()));
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.xAmzJson11;
    }

    public ContentType.Binary xAmzJson11() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.xAmzJson11$lzycompute() : this.xAmzJson11;
    }

    private ContentType.WithCharset formUrlEncoded$lzycompute() {
        AkkaHttpClient$ akkaHttpClient$ = this;
        synchronized (akkaHttpClient$) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.formUrlEncoded = ContentType$.MODULE$.apply(MediaType$.MODULE$.applicationWithOpenCharset("x-www-form-urlencoded", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0])), HttpCharset$.MODULE$.custom("utf-8", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0])));
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.formUrlEncoded;
    }

    public ContentType.WithCharset formUrlEncoded() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.formUrlEncoded$lzycompute() : this.formUrlEncoded;
    }

    private ContentType.Binary applicationXml$lzycompute() {
        AkkaHttpClient$ akkaHttpClient$ = this;
        synchronized (akkaHttpClient$) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.applicationXml = ContentType$.MODULE$.apply(MediaType$.MODULE$.customBinary("application", "xml", (MediaType.Compressibility)MediaType.Compressible$.MODULE$, MediaType$.MODULE$.customBinary$default$4(), MediaType$.MODULE$.customBinary$default$5(), MediaType$.MODULE$.customBinary$default$6()));
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.applicationXml;
    }

    public ContentType.Binary applicationXml() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.applicationXml$lzycompute() : this.applicationXml;
    }

    public static final /* synthetic */ boolean $anonfun$contentTypeHeaderToContentType$1(HttpHeader x$3) {
        String string = x$3.lowercaseName();
        String string2 = "content-type";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$filterContentTypeAndContentLengthHeader$1(HttpHeader h) {
        String string = h.lowercaseName();
        String string2 = "content-type";
        if (string == null) {
            if (string2 == null) return true;
        } else if (string.equals(string2)) return true;
        String string3 = h.lowercaseName();
        String string4 = "content-length";
        if (string3 != null) {
            if (!string3.equals(string4)) return false;
            return true;
        }
        if (string4 == null) return true;
        return false;
    }

    private AkkaHttpClient$() {
        MODULE$ = this;
        this.logger = LoggerFactory.getLogger(this.getClass());
    }
}

