/*
 * Decompiled with CFR 0.152.
 */
package com.github.matsluni.akkahttpspi;

import akka.http.scaladsl.model.ContentType;
import akka.http.scaladsl.model.ContentType$;
import akka.http.scaladsl.model.ContentTypes$;
import akka.http.scaladsl.model.HttpCharset$;
import akka.http.scaladsl.model.HttpEntity;
import akka.http.scaladsl.model.HttpEntity$;
import akka.http.scaladsl.model.HttpHeader;
import akka.http.scaladsl.model.HttpHeader$;
import akka.http.scaladsl.model.HttpMethod;
import akka.http.scaladsl.model.HttpMethods$;
import akka.http.scaladsl.model.HttpProtocols$;
import akka.http.scaladsl.model.HttpRequest;
import akka.http.scaladsl.model.HttpRequest$;
import akka.http.scaladsl.model.MediaType;
import akka.http.scaladsl.model.MediaType$;
import akka.http.scaladsl.model.RequestEntity;
import akka.http.scaladsl.model.RequestEntityAcceptance;
import akka.http.scaladsl.model.Uri$;
import akka.http.scaladsl.model.headers.Content$minusLength$;
import akka.http.scaladsl.model.headers.Content$minusType$;
import akka.stream.scaladsl.Source;
import akka.stream.scaladsl.Source$;
import akka.util.ByteString$;
import com.github.matsluni.akkahttpspi.AkkaHttpClient;
import com.github.matsluni.akkahttpspi.AkkaHttpClient$AkkaHttpClientBuilder$;
import java.io.Serializable;
import java.util.Map;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.runtime.ScalaRunTime$;
import software.amazon.awssdk.http.SdkHttpRequest;
import software.amazon.awssdk.http.async.SdkHttpContentPublisher;

public final class AkkaHttpClient$ {
    public static final AkkaHttpClient$ MODULE$ = new AkkaHttpClient$();
    private static ContentType.Binary xAmzJson;
    private static ContentType.Binary xAmzJson11;
    private static ContentType.Binary xAmzCbor11;
    private static ContentType.WithCharset formUrlEncoded;
    private static ContentType.Binary applicationXml;
    private static scala.collection.immutable.Map<String, ContentType> contentTypeMap;
    private static final Logger logger;
    private static volatile byte bitmap$0;

    static {
        logger = LoggerFactory.getLogger(MODULE$.getClass());
    }

    public Logger logger() {
        return logger;
    }

    public HttpRequest toAkkaRequest(SdkHttpRequest request, SdkHttpContentPublisher contentPublisher) {
        Tuple2<Option<HttpHeader>, Seq<HttpHeader>> tuple2 = this.convertHeaders(request.headers());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Option contentTypeHeader = (Option)tuple2._1();
        Seq reqheaders = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)contentTypeHeader, (Object)reqheaders);
        Tuple2 tuple23 = tuple22;
        Option contentTypeHeader2 = (Option)tuple23._1();
        Seq reqheaders2 = (Seq)tuple23._2();
        HttpMethod method = this.convertMethod(request.method().name());
        return HttpRequest$.MODULE$.apply(method, Uri$.MODULE$.apply(request.getUri().toString()), reqheaders2, this.entityForMethodAndContentType(method, this.contentTypeHeaderToContentType((Option<HttpHeader>)contentTypeHeader2), contentPublisher), HttpProtocols$.MODULE$.HTTP$div1$u002E1());
    }

    public RequestEntity entityForMethodAndContentType(HttpMethod method, ContentType contentType, SdkHttpContentPublisher contentPublisher) {
        HttpEntity.Strict strict;
        RequestEntityAcceptance requestEntityAcceptance = method.requestEntityAcceptance();
        if (RequestEntityAcceptance.Expected$.MODULE$.equals(requestEntityAcceptance)) {
            HttpEntity.Chunked chunked;
            Option option = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(contentPublisher.contentLength()));
            if (option instanceof Some) {
                Some some = (Some)option;
                Long length = (Long)some.value();
                chunked = HttpEntity$.MODULE$.apply(contentType, Predef$.MODULE$.Long2long(length), (Source)Source$.MODULE$.fromPublisher((Publisher)contentPublisher).map((Function1 & Serializable)x$2 -> ByteString$.MODULE$.apply(x$2)));
            } else if (None$.MODULE$.equals(option)) {
                chunked = HttpEntity$.MODULE$.apply(contentType, (Source)Source$.MODULE$.fromPublisher((Publisher)contentPublisher).map((Function1 & Serializable)x$3 -> ByteString$.MODULE$.apply(x$3)));
            } else {
                throw new MatchError((Object)option);
            }
            strict = chunked;
        } else {
            strict = HttpEntity$.MODULE$.Empty();
        }
        return strict;
    }

    public HttpMethod convertMethod(String method) {
        return (HttpMethod)HttpMethods$.MODULE$.getForKeyCaseInsensitive(method, (.less.colon.less)$less$colon$less$.MODULE$.refl()).getOrElse((Function0 & Serializable)() -> {
            throw new IllegalArgumentException(new StringBuilder(23).append("Method not configured: ").append(method).toString());
        });
    }

    public ContentType contentTypeHeaderToContentType(Option<HttpHeader> contentTypeHeader) {
        return (ContentType)contentTypeHeader.map((Function1 & Serializable)x$4 -> x$4.value()).map((Function1 & Serializable)v -> (ContentType)MODULE$.contentTypeMap().getOrElse(v, (Function0 & Serializable)() -> MODULE$.tryCreateCustomContentType((String)v))).getOrElse((Function0 & Serializable)() -> ContentTypes$.MODULE$.NoContentType());
    }

    public Tuple2<Option<HttpHeader>, Seq<HttpHeader>> convertHeaders(Map<String, java.util.List<String>> headers) {
        return (Tuple2)CollectionConverters$.MODULE$.MapHasAsScala(headers).asScala().foldLeft((Object)new Tuple2((Object)Option$.MODULE$.empty(), (Object)package$.MODULE$.List().empty()), (Function2 & Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2;
            Tuple2 tuple22 = new Tuple2(x0$1, x1$1);
            if (tuple22 == null) throw new MatchError((Object)tuple22);
            Tuple2 tuple23 = (Tuple2)tuple22._1();
            Tuple2 header = (Tuple2)tuple22._2();
            if (tuple23 == null) throw new MatchError((Object)tuple22);
            Option ctHeader = (Option)tuple23._1();
            List hdrs = (List)tuple23._2();
            Tuple2 tuple24 = header;
            if (tuple24 == null) throw new MatchError((Object)tuple24);
            String headerName = (String)tuple24._1();
            java.util.List headerValue = (java.util.List)tuple24._2();
            Tuple2 tuple25 = new Tuple2((Object)headerName, (Object)headerValue);
            Tuple2 tuple26 = tuple25;
            String headerName2 = (String)tuple26._1();
            java.util.List headerValue2 = (java.util.List)tuple26._2();
            if (headerValue2.size() != 1) {
                throw new IllegalArgumentException(new StringBuilder(37).append("Found invalid header: key: ").append(headerName2).append(", Value: ").append(CollectionConverters$.MODULE$.ListHasAsScala(headerValue2).asScala().toList()).append(".").toString());
            }
            String string = Content$minusLength$.MODULE$.lowercaseName();
            String string2 = headerName2.toLowerCase();
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                tuple2 = new Tuple2((Object)ctHeader, (Object)hdrs);
                return tuple2;
            } else {
                HttpHeader.ParsingResult parsingResult = HttpHeader$.MODULE$.parse(headerName2, (String)headerValue2.get(0), HttpHeader$.MODULE$.parse$default$3());
                if (!(parsingResult instanceof HttpHeader.ParsingResult$.Ok)) {
                    if (!(parsingResult instanceof HttpHeader.ParsingResult$.Error)) throw new MatchError((Object)parsingResult);
                    HttpHeader.ParsingResult$.Error error = (HttpHeader.ParsingResult$.Error)parsingResult;
                    throw new IllegalArgumentException(new StringBuilder(23).append("Found invalid header: ").append(error.errors()).append(".").toString());
                }
                HttpHeader.ParsingResult$.Ok ok = (HttpHeader.ParsingResult$.Ok)parsingResult;
                String string3 = ok.header().lowercaseName();
                String string4 = Content$minusType$.MODULE$.lowercaseName();
                Tuple2 tuple27 = !(string3 != null ? !string3.equals(string4) : string4 != null) ? new Tuple2((Object)new Some((Object)ok.header()), (Object)hdrs) : new Tuple2((Object)ctHeader, hdrs.$colon$plus((Object)ok.header()));
                tuple2 = tuple27;
            }
            return tuple2;
        });
    }

    public ContentType tryCreateCustomContentType(String contentTypeStr) {
        this.logger().debug(new StringBuilder(31).append("Try to parse content type from ").append(contentTypeStr).toString());
        String[] mainAndsubType = StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(contentTypeStr), '/');
        if (mainAndsubType.length != 2) {
            throw new RuntimeException(new StringBuilder(39).append("Could not parse custom content type '").append(contentTypeStr).append("'.").toString());
        }
        return ContentType$.MODULE$.apply(MediaType$.MODULE$.customBinary(mainAndsubType[0], mainAndsubType[1], (MediaType.Compressibility)MediaType.Compressible$.MODULE$, MediaType$.MODULE$.customBinary$default$4(), MediaType$.MODULE$.customBinary$default$5(), MediaType$.MODULE$.customBinary$default$6()));
    }

    public AkkaHttpClient.AkkaHttpClientBuilder builder() {
        return new AkkaHttpClient.AkkaHttpClientBuilder(AkkaHttpClient$AkkaHttpClientBuilder$.MODULE$.apply$default$1(), AkkaHttpClient$AkkaHttpClientBuilder$.MODULE$.apply$default$2(), AkkaHttpClient$AkkaHttpClientBuilder$.MODULE$.apply$default$3());
    }

    private ContentType.Binary xAmzJson$lzycompute() {
        AkkaHttpClient$ akkaHttpClient$ = this;
        synchronized (akkaHttpClient$) {
            if ((byte)(bitmap$0 & 1) == 0) {
                xAmzJson = ContentType$.MODULE$.apply(MediaType$.MODULE$.customBinary("application", "x-amz-json-1.0", (MediaType.Compressibility)MediaType.Compressible$.MODULE$, MediaType$.MODULE$.customBinary$default$4(), MediaType$.MODULE$.customBinary$default$5(), MediaType$.MODULE$.customBinary$default$6()));
                bitmap$0 = (byte)(bitmap$0 | 1);
            }
        }
        return xAmzJson;
    }

    public ContentType.Binary xAmzJson() {
        return (byte)(bitmap$0 & 1) == 0 ? this.xAmzJson$lzycompute() : xAmzJson;
    }

    private ContentType.Binary xAmzJson11$lzycompute() {
        AkkaHttpClient$ akkaHttpClient$ = this;
        synchronized (akkaHttpClient$) {
            if ((byte)(bitmap$0 & 2) == 0) {
                xAmzJson11 = ContentType$.MODULE$.apply(MediaType$.MODULE$.customBinary("application", "x-amz-json-1.1", (MediaType.Compressibility)MediaType.Compressible$.MODULE$, MediaType$.MODULE$.customBinary$default$4(), MediaType$.MODULE$.customBinary$default$5(), MediaType$.MODULE$.customBinary$default$6()));
                bitmap$0 = (byte)(bitmap$0 | 2);
            }
        }
        return xAmzJson11;
    }

    public ContentType.Binary xAmzJson11() {
        return (byte)(bitmap$0 & 2) == 0 ? this.xAmzJson11$lzycompute() : xAmzJson11;
    }

    private ContentType.Binary xAmzCbor11$lzycompute() {
        AkkaHttpClient$ akkaHttpClient$ = this;
        synchronized (akkaHttpClient$) {
            if ((byte)(bitmap$0 & 4) == 0) {
                xAmzCbor11 = ContentType$.MODULE$.apply(MediaType$.MODULE$.customBinary("application", "x-amz-cbor-1.1", (MediaType.Compressibility)MediaType.Compressible$.MODULE$, MediaType$.MODULE$.customBinary$default$4(), MediaType$.MODULE$.customBinary$default$5(), MediaType$.MODULE$.customBinary$default$6()));
                bitmap$0 = (byte)(bitmap$0 | 4);
            }
        }
        return xAmzCbor11;
    }

    public ContentType.Binary xAmzCbor11() {
        return (byte)(bitmap$0 & 4) == 0 ? this.xAmzCbor11$lzycompute() : xAmzCbor11;
    }

    private ContentType.WithCharset formUrlEncoded$lzycompute() {
        AkkaHttpClient$ akkaHttpClient$ = this;
        synchronized (akkaHttpClient$) {
            if ((byte)(bitmap$0 & 8) == 0) {
                formUrlEncoded = ContentType$.MODULE$.apply(MediaType$.MODULE$.applicationWithOpenCharset("x-www-form-urlencoded", (Seq)Nil$.MODULE$), HttpCharset$.MODULE$.custom("utf-8", (Seq)Nil$.MODULE$));
                bitmap$0 = (byte)(bitmap$0 | 8);
            }
        }
        return formUrlEncoded;
    }

    public ContentType.WithCharset formUrlEncoded() {
        return (byte)(bitmap$0 & 8) == 0 ? this.formUrlEncoded$lzycompute() : formUrlEncoded;
    }

    private ContentType.Binary applicationXml$lzycompute() {
        AkkaHttpClient$ akkaHttpClient$ = this;
        synchronized (akkaHttpClient$) {
            if ((byte)(bitmap$0 & 0x10) == 0) {
                applicationXml = ContentType$.MODULE$.apply(MediaType$.MODULE$.customBinary("application", "xml", (MediaType.Compressibility)MediaType.Compressible$.MODULE$, MediaType$.MODULE$.customBinary$default$4(), MediaType$.MODULE$.customBinary$default$5(), MediaType$.MODULE$.customBinary$default$6()));
                bitmap$0 = (byte)(bitmap$0 | 0x10);
            }
        }
        return applicationXml;
    }

    public ContentType.Binary applicationXml() {
        return (byte)(bitmap$0 & 0x10) == 0 ? this.applicationXml$lzycompute() : applicationXml;
    }

    private scala.collection.immutable.Map<String, ContentType> contentTypeMap$lzycompute() {
        AkkaHttpClient$ akkaHttpClient$ = this;
        synchronized (akkaHttpClient$) {
            if ((byte)(bitmap$0 & 0x20) == 0) {
                contentTypeMap = (scala.collection.immutable.Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"application/x-amz-json-1.0"), (Object)this.xAmzJson()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"application/x-amz-json-1.1"), (Object)this.xAmzJson11()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"application/x-amz-cbor-1.1"), (Object)this.xAmzCbor11()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"application/x-www-form-urlencoded; charset-UTF-8"), (Object)this.formUrlEncoded()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"application/x-www-form-urlencoded"), (Object)this.formUrlEncoded()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"application/xml"), (Object)this.applicationXml())}));
                bitmap$0 = (byte)(bitmap$0 | 0x20);
            }
        }
        return contentTypeMap;
    }

    public scala.collection.immutable.Map<String, ContentType> contentTypeMap() {
        return (byte)(bitmap$0 & 0x20) == 0 ? this.contentTypeMap$lzycompute() : contentTypeMap;
    }

    private AkkaHttpClient$() {
    }
}

