/*
 * Decompiled with CFR 0.152.
 */
package com.chinapex.android.monitor;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.provider.Settings;
import android.support.annotation.RequiresApi;
import android.text.TextUtils;
import android.view.View;
import android.widget.Toast;
import com.chinapex.android.monitor.R;
import com.chinapex.android.monitor.bean.ConfigBean;
import com.chinapex.android.monitor.callback.IMonitorCallback;
import com.chinapex.android.monitor.changelistener.IMonitorListenerController;
import com.chinapex.android.monitor.executor.TaskController;
import com.chinapex.android.monitor.global.MonitorCache;
import com.chinapex.android.monitor.utils.MLog;
import com.chinapex.android.monitor.view.FloatingViewManager;
import com.chinapex.android.monitor.view.event.DefineEventView;
import java.util.Map;
import java.util.Stack;

public class MonitorTools {
    private static final String TAG = MonitorTools.class.getSimpleName();
    public static boolean isInit = false;

    private MonitorTools() {
    }

    public static MonitorTools getInstance() {
        return MonitorToolsHolder.MONITOR_TOOLS;
    }

    public static void init() {
        if (isInit) {
            MLog.i(TAG, "init() -> has already been initialized !");
            return;
        }
        TaskController.getInstance().doInit();
        MonitorCache.getInstance().getExistData();
        IMonitorListenerController.getInstance().doInit();
        isInit = true;
    }

    public static void showFloatingWindow(Context context, IMonitorCallback iMonitorCallback, Map<Integer, Stack<Map<String, Boolean>>> tasks, Map<Integer, Integer> top, int[] foregroundTask) {
        MLog.d(TAG, "showFloatingWindow: DEBUG!");
        if (null == context || null == iMonitorCallback) {
            MLog.e(TAG, "context or iMonitorCallback is null!");
            return;
        }
        MonitorCache.getInstance().setContext(context);
        MonitorCache.getInstance().setIMonitorCallback(iMonitorCallback);
        MonitorCache.getInstance().setTasks(tasks);
        MonitorCache.getInstance().setTop(top);
        MonitorCache.getInstance().setForegroundTask(foregroundTask);
        MonitorTools.init();
        MonitorTools.getInstance().showWindow();
    }

    public static void dismissFloatingWindow() {
        MLog.d(TAG, "dismissFloatingWindow: DEBUG!");
        MonitorTools.getInstance().dismissWindow();
    }

    public static void showH5ClickDefinePage(String viewPath, String pageClass, String findPath) {
        Context mContext = MonitorCache.getInstance().getContext();
        if (null == mContext) {
            MLog.e(TAG, "createView()-> error:context=null, create view failed");
            return;
        }
        if (null == viewPath) {
            MLog.e(TAG, "loadClickData()-> viewPath is null!");
            return;
        }
        if (null == pageClass) {
            MLog.e(TAG, "loadClickData()-> pageClass is null!");
            return;
        }
        if (null == findPath) {
            MLog.e(TAG, "loadClickData()-> findPath is null!");
            return;
        }
        Map<String, ConfigBean.PvBean> pvBeans = MonitorCache.getInstance().getPvBeans();
        if (null == pvBeans) {
            MLog.e(TAG, "loadClickData()-> pvBeans is null!");
            return;
        }
        String definedPage = null;
        for (ConfigBean.PvBean pvBean : pvBeans.values()) {
            if (null == pvBean) {
                MLog.e(TAG, "loadClickData()-> pvBean is null!");
                continue;
            }
            if (null == pvBean.getViewPath()) {
                MLog.e(TAG, "loadClickData()-> viewPath of pvBean is null!");
                continue;
            }
            if (!pageClass.equals(pvBean.getViewPath())) continue;
            definedPage = pvBean.getViewPath();
            break;
        }
        if (TextUtils.isEmpty(definedPage)) {
            MLog.e(TAG, "loadClickData()-> no defined page!");
            Toast.makeText((Context)mContext, (CharSequence)mContext.getResources().getText(R.string.defined_page_hint).toString(), (int)1).show();
            return;
        }
        FloatingViewManager.getInstance().showFloatingView(2);
        DefineEventView defineEventView = (DefineEventView)FloatingViewManager.getInstance().getFloatingView(2);
        if (null == defineEventView) {
            MLog.d(TAG, "showDefinePage()-> can not get DefineEventView");
            return;
        }
        defineEventView.loadH5ClickData(viewPath, pageClass, findPath);
    }

    public static void showClickDefinePage(View view, String viewPath, String pageClass, String findPath) {
        Context mContext = MonitorCache.getInstance().getContext();
        if (null == mContext) {
            MLog.e(TAG, "createView()-> error:context=null, create view failed");
            return;
        }
        if (null == viewPath) {
            MLog.e(TAG, "loadClickData()-> viewPath is null!");
            return;
        }
        if (null == pageClass) {
            MLog.e(TAG, "loadClickData()-> pageClass is null!");
            return;
        }
        if (null == findPath) {
            MLog.e(TAG, "loadClickData()-> findPath is null!");
            return;
        }
        Map<String, ConfigBean.PvBean> pvBeans = MonitorCache.getInstance().getPvBeans();
        if (null == pvBeans) {
            MLog.e(TAG, "loadClickData()-> pvBeans is null!");
            return;
        }
        String definedPage = null;
        for (ConfigBean.PvBean pvBean : pvBeans.values()) {
            if (null == pvBean) {
                MLog.e(TAG, "loadClickData()-> pvBean is null!");
                continue;
            }
            if (null == pvBean.getViewPath()) {
                MLog.e(TAG, "loadClickData()-> viewPath of pvBean is null!");
                continue;
            }
            if (!pageClass.equals(pvBean.getViewPath())) continue;
            definedPage = pvBean.getViewPath();
            break;
        }
        if (TextUtils.isEmpty(definedPage)) {
            MLog.e(TAG, "loadClickData()-> no defined page!");
            Toast.makeText((Context)mContext, (CharSequence)mContext.getResources().getText(R.string.defined_page_hint).toString(), (int)1).show();
            return;
        }
        FloatingViewManager.getInstance().showFloatingView(2);
        DefineEventView defineEventView = (DefineEventView)FloatingViewManager.getInstance().getFloatingView(2);
        if (null == defineEventView) {
            MLog.d(TAG, "showDefinePage()-> can not get DefineEventView");
            return;
        }
        defineEventView.loadClickData(view, viewPath, pageClass, findPath);
    }

    public static void showListItemClickDefinePage(View view, String viewPath, String pageClass, String itemPath, String findPath, int listType) {
        Context mContext = MonitorCache.getInstance().getContext();
        if (null == mContext) {
            MLog.e(TAG, "createView()-> error:context=null, create view failed");
            return;
        }
        if (null == viewPath) {
            MLog.e(TAG, "loadClickData()-> viewPath is null!");
            return;
        }
        if (null == pageClass) {
            MLog.e(TAG, "loadClickData()-> pageClass is null!");
            return;
        }
        if (null == findPath) {
            MLog.e(TAG, "loadClickData()-> findPath is null!");
            return;
        }
        Map<String, ConfigBean.PvBean> pvBeans = MonitorCache.getInstance().getPvBeans();
        if (null == pvBeans) {
            MLog.e(TAG, "loadClickData()-> pvBeans is null!");
            return;
        }
        String definedPage = null;
        for (ConfigBean.PvBean pvBean : pvBeans.values()) {
            if (null == pvBean) {
                MLog.e(TAG, "loadClickData()-> pvBean is null!");
                continue;
            }
            if (null == pvBean.getViewPath()) {
                MLog.e(TAG, "loadClickData()-> viewPath of pvBean is null!");
                continue;
            }
            if (!pageClass.equals(pvBean.getViewPath())) continue;
            definedPage = pvBean.getViewPath();
            break;
        }
        if (TextUtils.isEmpty(definedPage)) {
            MLog.e(TAG, "loadClickData()-> no defined page!");
            Toast.makeText((Context)mContext, (CharSequence)mContext.getResources().getText(R.string.defined_page_hint).toString(), (int)1).show();
            return;
        }
        FloatingViewManager.getInstance().showFloatingView(3);
        DefineEventView defineEventView = (DefineEventView)FloatingViewManager.getInstance().getFloatingView(3);
        if (null == defineEventView) {
            MLog.e(TAG, "showListItemClickDefinePage()-> can not get DefineEventView");
            return;
        }
        defineEventView.loadListItemClickData(view, viewPath, pageClass, itemPath, findPath, listType);
    }

    public static boolean addContrastItem(String viewPath, String pageClassName) {
        return MonitorCache.getInstance().addContrastItem(viewPath, pageClassName);
    }

    public static void setHostnameVerifier(String hostnameVerifier) {
        MonitorCache.getInstance().setHostnameVerifier(hostnameVerifier);
    }

    public static void setServerRoot(String serverRoot) {
        MonitorCache.getInstance().setServerRoot(serverRoot);
    }

    private boolean showWindow() {
        if (Build.VERSION.SDK_INT >= 23 && !Settings.canDrawOverlays((Context)MonitorCache.getInstance().getContext())) {
            this.requestPermission(MonitorCache.getInstance().getContext());
            MLog.w(TAG, "showWindow() -> unauthorized");
            return false;
        }
        FloatingViewManager.getInstance().showFloatingView(0);
        FloatingViewManager.getInstance().showAll();
        return true;
    }

    @RequiresApi(value=23)
    private void requestPermission(Context context) {
        if (null == context) {
            MLog.e(TAG, "requestPermission() -> context is null!");
            return;
        }
        Intent intent = new Intent("android.settings.action.MANAGE_OVERLAY_PERMISSION", Uri.parse((String)("package:" + context.getPackageName())));
        intent.setFlags(0x10000000);
        context.startActivity(intent);
    }

    private void dismissWindow() {
        FloatingViewManager.getInstance().hideAll();
    }

    public static void putH5Url(String pagePath, String url) {
        MonitorCache.getInstance().putH5Url(pagePath, url);
    }

    public static String getH5Url(String pagePath) {
        return MonitorCache.getInstance().getH5Url(pagePath);
    }

    public static void clearH5Map() {
        MonitorCache.getInstance().clearH5Map();
    }

    private static class MonitorToolsHolder {
        private static final MonitorTools MONITOR_TOOLS = new MonitorTools();

        private MonitorToolsHolder() {
        }
    }
}

