/*
 * Decompiled with CFR 0.152.
 */
package com.chinapex.android.monitor.changelistener;

import com.chinapex.android.monitor.changelistener.IDeleteStatisticsCallback;
import com.chinapex.android.monitor.changelistener.IDownloadConfigCallback;
import com.chinapex.android.monitor.changelistener.IEditPageOrElementNameCallback;
import com.chinapex.android.monitor.changelistener.OnComparisonElementsChangeListener;
import com.chinapex.android.monitor.utils.MLog;
import java.util.ArrayList;
import java.util.List;

public class IMonitorListenerController {
    private static final String TAG = IMonitorListenerController.class.getSimpleName();
    private List<OnComparisonElementsChangeListener> mOnComparisonElementsChangeListeners;
    private List<IDownloadConfigCallback> mIDownloadConfigCallbacks;
    private List<IEditPageOrElementNameCallback> mIEditPageOrElementNameCallbacks;
    private List<IDeleteStatisticsCallback> mIDeleteStatisticsCallbacks;

    private IMonitorListenerController() {
    }

    public static IMonitorListenerController getInstance() {
        return MonitorListenerControllerHolder.MONITOR_LISTENER_CONTROLLER;
    }

    public void doInit() {
        this.mOnComparisonElementsChangeListeners = new ArrayList<OnComparisonElementsChangeListener>();
        this.mIDownloadConfigCallbacks = new ArrayList<IDownloadConfigCallback>();
        this.mIEditPageOrElementNameCallbacks = new ArrayList<IEditPageOrElementNameCallback>();
        this.mIDeleteStatisticsCallbacks = new ArrayList<IDeleteStatisticsCallback>();
    }

    public void onDestroy() {
        if (null == this.mOnComparisonElementsChangeListeners) {
            MLog.e(TAG, "onDestroy() -> mOnComparisonElementsChangeListeners is null!");
            return;
        }
        if (null == this.mIDownloadConfigCallbacks) {
            MLog.e(TAG, "onDestroy() -> mIDownloadConfigCallbacks is null!");
            return;
        }
        this.mOnComparisonElementsChangeListeners.clear();
        this.mIDownloadConfigCallbacks.clear();
        this.mIEditPageOrElementNameCallbacks.clear();
        this.mIDeleteStatisticsCallbacks.clear();
        this.mOnComparisonElementsChangeListeners = null;
        this.mIDownloadConfigCallbacks = null;
        this.mIEditPageOrElementNameCallbacks = null;
        this.mIDeleteStatisticsCallbacks = null;
    }

    public void addDeleteStatisticsListener(IDeleteStatisticsCallback iDeleteStatisticsCallback) {
        if (null == this.mIDeleteStatisticsCallbacks || null == iDeleteStatisticsCallback) {
            MLog.e(TAG, "1: mIDeleteStatisticsCallbacks or iDeleteStatisticsCallback is null!");
            return;
        }
        this.mIDeleteStatisticsCallbacks.add(iDeleteStatisticsCallback);
    }

    public void removeDeleteStatisticsListener(IDeleteStatisticsCallback iDeleteStatisticsCallback) {
        if (null == this.mIDeleteStatisticsCallbacks || null == iDeleteStatisticsCallback) {
            MLog.e(TAG, "1: mIDeleteStatisticsCallbacks or iDeleteStatisticsCallback is null!");
            return;
        }
        this.mIDeleteStatisticsCallbacks.remove(iDeleteStatisticsCallback);
    }

    public void addEditPageorElementNameListener(IEditPageOrElementNameCallback editPageOrElementNameCallback) {
        if (null == this.mIEditPageOrElementNameCallbacks || null == editPageOrElementNameCallback) {
            MLog.e(TAG, "1: mIEditPageOrElementNameCallbacks or editPageOrElementNameCallback is null!");
            return;
        }
        this.mIEditPageOrElementNameCallbacks.add(editPageOrElementNameCallback);
    }

    public void removeEditPageorElementNameListener(IEditPageOrElementNameCallback editPageOrElementNameCallback) {
        if (null == this.mIEditPageOrElementNameCallbacks || null == editPageOrElementNameCallback) {
            MLog.e(TAG, "0: mIEditPageOrElementNameCallbacks or editPageOrElementNameCallback is null!");
            return;
        }
        this.mIEditPageOrElementNameCallbacks.remove(editPageOrElementNameCallback);
    }

    public void addOnComparisonElementsChangeListener(OnComparisonElementsChangeListener onComparisonElementsChangeListener) {
        if (null == this.mOnComparisonElementsChangeListeners || null == onComparisonElementsChangeListener) {
            MLog.e(TAG, "1: mOnComparisonElementsChangeListeners or onComparisonElementsChangeListener is null!");
            return;
        }
        this.mOnComparisonElementsChangeListeners.add(onComparisonElementsChangeListener);
    }

    public void addIDownloadConfigCallback(IDownloadConfigCallback iDownloadConfigCallback) {
        if (null == this.mIDownloadConfigCallbacks || null == iDownloadConfigCallback) {
            MLog.e(TAG, "1: mIDownloadConfigCallbacks or iDownloadConfigCallback is null!");
            return;
        }
        this.mIDownloadConfigCallbacks.add(iDownloadConfigCallback);
    }

    public void removeOnComparisonElementsChangeListener(OnComparisonElementsChangeListener onComparisonElementsChangeListener) {
        if (null == this.mOnComparisonElementsChangeListeners || null == onComparisonElementsChangeListener) {
            MLog.e(TAG, "0: mOnComparisonElementsChangeListeners or onComparisonElementsChangeListener is null!");
            return;
        }
        this.mOnComparisonElementsChangeListeners.remove(onComparisonElementsChangeListener);
    }

    public void removeIDownloadConfigCallback(IDownloadConfigCallback iDownloadConfigCallback) {
        if (null == this.mIDownloadConfigCallbacks || null == iDownloadConfigCallback) {
            MLog.e(TAG, "0: mIDownloadConfigCallbacks or iDownloadConfigCallback is null!");
            return;
        }
        this.mIDownloadConfigCallbacks.remove(iDownloadConfigCallback);
    }

    public void notifyComparisonElementsChange() {
        if (null == this.mOnComparisonElementsChangeListeners) {
            MLog.e(TAG, "notifyComparisonElementsChange() -> mOnComparisonElementsChangeListeners is null!");
            return;
        }
        for (OnComparisonElementsChangeListener onComparisonElementsChangeListener : this.mOnComparisonElementsChangeListeners) {
            if (null == onComparisonElementsChangeListener) {
                MLog.e(TAG, "notifyComparisonElementsChange() -> onComparisonElementsChangeListener is null!");
                continue;
            }
            onComparisonElementsChangeListener.comparisonElementsChange();
        }
    }

    public void notifyDeleteStatistics() {
        if (null == this.mIDeleteStatisticsCallbacks) {
            MLog.e(TAG, "confirmDeleteStatistics()-> mIDeleteStatisticsCallbacks is null!");
            return;
        }
        for (IDeleteStatisticsCallback iDeleteStatisticsCallback : this.mIDeleteStatisticsCallbacks) {
            if (null == iDeleteStatisticsCallback) {
                MLog.e(TAG, "confirmDeleteStatistics()-> mIDeleteStatisticsCallbacks is null!");
                continue;
            }
            iDeleteStatisticsCallback.confirmDeleteStatistics();
        }
    }

    public void notifyPageOrElementNameChange(String nameJson) {
        if (null == this.mIEditPageOrElementNameCallbacks) {
            MLog.e(TAG, "inputPageName(),inputElementName()-> notifyPageOrElementNameChange is null!");
            return;
        }
        for (IEditPageOrElementNameCallback editPageOrElementNameCallback : this.mIEditPageOrElementNameCallbacks) {
            if (null == editPageOrElementNameCallback) {
                MLog.e(TAG, "inputPageName(),inputElementName()-> notifyPageOrElementNameChange is null!");
                continue;
            }
            editPageOrElementNameCallback.nameChange(nameJson);
        }
    }

    public void notifyDownloadConfig(boolean isSuccessful) {
        if (null == this.mIDownloadConfigCallbacks) {
            MLog.e(TAG, "notifyDownloadConfig() -> mIDownloadConfigCallbacks is null!");
            return;
        }
        for (IDownloadConfigCallback iDownloadConfigCallback : this.mIDownloadConfigCallbacks) {
            if (null == iDownloadConfigCallback) {
                MLog.e(TAG, "notifyDownloadConfig() -> iDownloadConfigCallback is null!");
                continue;
            }
            iDownloadConfigCallback.downloadConfig(isSuccessful);
        }
    }

    private static class MonitorListenerControllerHolder {
        private static final IMonitorListenerController MONITOR_LISTENER_CONTROLLER = new IMonitorListenerController();

        private MonitorListenerControllerHolder() {
        }
    }
}

