/*
 * Decompiled with CFR 0.152.
 */
package com.chinapex.android.monitor.executor;

import android.os.Handler;
import android.os.Looper;
import com.chinapex.android.monitor.executor.IController;
import com.chinapex.android.monitor.utils.MLog;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class TaskController
implements IController {
    private static final String TAG = TaskController.class.getSimpleName();
    private ScheduledExecutorService mScheduledExecutorService;
    private Handler mHandler;

    private TaskController() {
    }

    public static TaskController getInstance() {
        return TaskControllerHolder.TASK_CONTROLLER;
    }

    @Override
    public void doInit() {
        this.mScheduledExecutorService = Executors.newSingleThreadScheduledExecutor();
        this.mHandler = new Handler(Looper.getMainLooper());
    }

    @Override
    public void onDestroy() {
        if (null == this.mScheduledExecutorService) {
            MLog.e(TAG, "onDestroy() -> mScheduledExecutorService is null!");
            return;
        }
        this.mScheduledExecutorService.shutdown();
        if (!this.mScheduledExecutorService.isShutdown()) {
            MLog.e(TAG, "onDestroy() -> mScheduledExecutorService did not close!");
            return;
        }
        MLog.i(TAG, "onDestroy() -> mScheduledExecutorService has been closed");
        this.mScheduledExecutorService = null;
    }

    public void submit(Runnable runnable) {
        if (null == this.mScheduledExecutorService || null == runnable) {
            MLog.e(TAG, "submit() -> mScheduledExecutorService or runnable is null!");
            return;
        }
        this.mScheduledExecutorService.submit(runnable);
    }

    public ScheduledFuture scheduleDelay(Runnable runnable, long delay) {
        if (null == this.mScheduledExecutorService || null == runnable) {
            MLog.e(TAG, "scheduleDelay() -> mScheduledExecutorService or runnable is null!");
            return null;
        }
        return this.mScheduledExecutorService.schedule(runnable, delay, TimeUnit.MILLISECONDS);
    }

    public ScheduledFuture schedule(Runnable runnable, long initialDelay, long period) {
        if (null == this.mScheduledExecutorService || null == runnable) {
            MLog.e(TAG, "schedule() -> mScheduledExecutorService or runnable is null!");
            return null;
        }
        return this.mScheduledExecutorService.scheduleAtFixedRate(runnable, initialDelay, period, TimeUnit.MILLISECONDS);
    }

    public void runOnUiThread(Runnable runnable) {
        if (this.mHandler.getLooper() != Looper.getMainLooper()) {
            this.mHandler = new Handler(Looper.getMainLooper());
        }
        if (this.mHandler.getLooper() != Looper.getMainLooper()) {
            return;
        }
        this.mHandler.post(runnable);
    }

    private static class TaskControllerHolder {
        private static final TaskController TASK_CONTROLLER = new TaskController();

        private TaskControllerHolder() {
        }
    }
}

