/*
 * Decompiled with CFR 0.152.
 */
package com.chinapex.android.monitor.executor.runnable;

import android.text.TextUtils;
import com.chinapex.android.monitor.bean.ConfigBean;
import com.chinapex.android.monitor.bean.request.DownloadConfigRequest;
import com.chinapex.android.monitor.bean.response.DownloadConfigResponse;
import com.chinapex.android.monitor.changelistener.IMonitorListenerController;
import com.chinapex.android.monitor.executor.TaskController;
import com.chinapex.android.monitor.executor.runnable.WriteClickToSp;
import com.chinapex.android.monitor.executor.runnable.WriteElemPvToSp;
import com.chinapex.android.monitor.executor.runnable.WriteExpandablePvToSp;
import com.chinapex.android.monitor.executor.runnable.WriteListPvToSp;
import com.chinapex.android.monitor.executor.runnable.WriteListToSp;
import com.chinapex.android.monitor.executor.runnable.WritePvToSp;
import com.chinapex.android.monitor.executor.runnable.WriteRecyclerPvToSp;
import com.chinapex.android.monitor.global.MonitorCache;
import com.chinapex.android.monitor.utils.GsonUtils;
import com.chinapex.android.monitor.utils.MLog;
import com.chinapex.android.monitor.utils.net.INetCallback;
import com.chinapex.android.monitor.utils.net.OkHttpClientManager;
import java.util.Map;

public class DownloadConfig
implements Runnable,
INetCallback {
    private static final String TAG = DownloadConfig.class.getSimpleName();
    private String mConfigVersion;

    public DownloadConfig(String configVersion) {
        this.mConfigVersion = configVersion;
    }

    @Override
    public void run() {
        if (TextUtils.isEmpty((CharSequence)this.mConfigVersion)) {
            MLog.e(TAG, "run() -> mConfigVersion is null or empty!");
            return;
        }
        DownloadConfigRequest downloadConfigRequest = new DownloadConfigRequest();
        downloadConfigRequest.setAppVersion(this.mConfigVersion);
        downloadConfigRequest.setTerminal("ANDROID");
        downloadConfigRequest.setTimeStamp(0L);
        String downloadConfigRequestStr = GsonUtils.toJsonStr(downloadConfigRequest);
        MLog.d(TAG, "run() -> downloadConfigRequestStr:" + downloadConfigRequestStr);
        OkHttpClientManager.getInstance().postJson(MonitorCache.getInstance().getServerRoot() + "app/downConfig", downloadConfigRequestStr, this);
    }

    @Override
    public void onSuccess(int statusCode, String msg, String result) {
        Map<String, Map<String, String>> expandablePv;
        Map<String, Map<String, String>> listPv;
        Map<String, Map<String, String>> recyclerPv;
        Map<String, Map<String, String>> configElemPv;
        Map<String, ConfigBean.ListBean> configList;
        Map<String, ConfigBean.PvBean> configPv;
        MLog.i(TAG, "onSuccess() -> result:" + result);
        if (TextUtils.isEmpty((CharSequence)result)) {
            MLog.e(TAG, "onSuccess() -> result is null or empty!");
            return;
        }
        DownloadConfigResponse downloadConfigResponse = GsonUtils.json2Bean(result, DownloadConfigResponse.class);
        if (null == downloadConfigResponse) {
            MLog.e(TAG, "onSuccess() -> downloadConfigResponse is null!");
            IMonitorListenerController.getInstance().notifyDownloadConfig(false);
            return;
        }
        int status = downloadConfigResponse.getStatus();
        if (200 != status) {
            MLog.e(TAG, "onSuccess() -> status is not 200!");
            IMonitorListenerController.getInstance().notifyDownloadConfig(false);
            return;
        }
        DownloadConfigResponse.DataBean data = downloadConfigResponse.getData();
        if (null == data) {
            MLog.e(TAG, "onSuccess() -> data is null!");
            IMonitorListenerController.getInstance().notifyDownloadConfig(false);
            return;
        }
        ConfigBean config = data.getConfig();
        if (null == config) {
            MLog.e(TAG, "onSuccess() -> config is null!");
            IMonitorListenerController.getInstance().notifyDownloadConfig(false);
            return;
        }
        Map<String, ConfigBean.ClickBean> clickBeans = MonitorCache.getInstance().getClickBeans();
        Map<String, ConfigBean.PvBean> pvBeans = MonitorCache.getInstance().getPvBeans();
        Map<String, ConfigBean.ListBean> listBeans = MonitorCache.getInstance().getListBeans();
        Map<String, Map<String, String>> elemPvBeans = MonitorCache.getInstance().getElemPvBeans();
        Map<String, Map<String, String>> recyclerPvBeans = MonitorCache.getInstance().getRecyclerPvBeans();
        Map<String, Map<String, String>> listPvBeans = MonitorCache.getInstance().getListPvBeans();
        Map<String, Map<String, String>> expandablePvBeans = MonitorCache.getInstance().getExpandablePvBeans();
        if (null == clickBeans || null == pvBeans || null == listBeans || null == elemPvBeans || null == recyclerPvBeans || null == listPvBeans || null == expandablePvBeans) {
            MLog.e(TAG, "onSuccess() -> clickBeans or pvBeans or listBeans or elemPvBeans or recyclerPvBeans or listPvBeans or expandablePvBeans is null!");
            IMonitorListenerController.getInstance().notifyDownloadConfig(false);
            return;
        }
        clickBeans.clear();
        pvBeans.clear();
        listBeans.clear();
        elemPvBeans.clear();
        recyclerPvBeans.clear();
        listPvBeans.clear();
        expandablePvBeans.clear();
        Map<String, ConfigBean.ClickBean> configClick = config.getClick();
        if (null != configClick) {
            clickBeans.putAll(configClick);
        }
        if (null != (configPv = config.getPv())) {
            pvBeans.putAll(configPv);
        }
        if (null != (configList = config.getList())) {
            listBeans.putAll(configList);
        }
        if (null != (configElemPv = config.getElemPv())) {
            elemPvBeans.putAll(configElemPv);
        }
        if (null != (recyclerPv = config.getRecyclerPv())) {
            recyclerPvBeans.putAll(recyclerPv);
        }
        if (null != (listPv = config.getListPv())) {
            listPvBeans.putAll(listPv);
        }
        if (null != (expandablePv = config.getExpandablePv())) {
            expandablePvBeans.putAll(expandablePv);
        }
        IMonitorListenerController.getInstance().notifyDownloadConfig(true);
        TaskController.getInstance().submit(new WriteClickToSp());
        TaskController.getInstance().submit(new WritePvToSp());
        TaskController.getInstance().submit(new WriteListToSp());
        TaskController.getInstance().submit(new WriteElemPvToSp());
        TaskController.getInstance().submit(new WriteRecyclerPvToSp());
        TaskController.getInstance().submit(new WriteListPvToSp());
        TaskController.getInstance().submit(new WriteExpandablePvToSp());
    }

    @Override
    public void onFailed(int failedCode, String msg) {
        MLog.e(TAG, "UpdateConfig onFailed() -> msg:" + msg);
        IMonitorListenerController.getInstance().notifyDownloadConfig(false);
    }
}

