/*
 * Decompiled with CFR 0.152.
 */
package com.chinapex.android.monitor.executor.runnable;

import android.text.TextUtils;
import com.chinapex.android.monitor.bean.request.GetAllConfigVersionsRequest;
import com.chinapex.android.monitor.bean.response.GetAllConfigVersionsResponse;
import com.chinapex.android.monitor.callback.IGetAllConfigVersionsCallback;
import com.chinapex.android.monitor.global.MonitorCache;
import com.chinapex.android.monitor.utils.GsonUtils;
import com.chinapex.android.monitor.utils.MLog;
import com.chinapex.android.monitor.utils.PhoneStateUtils;
import com.chinapex.android.monitor.utils.net.INetCallback;
import com.chinapex.android.monitor.utils.net.OkHttpClientManager;

public class GetAllConfigVersions
implements Runnable,
INetCallback {
    private static final String TAG = GetAllConfigVersions.class.getSimpleName();
    private IGetAllConfigVersionsCallback mIGetAllConfigVersionsCallback;

    public GetAllConfigVersions(IGetAllConfigVersionsCallback iGetAllConfigVersionsCallback) {
        this.mIGetAllConfigVersionsCallback = iGetAllConfigVersionsCallback;
    }

    @Override
    public void run() {
        if (null == this.mIGetAllConfigVersionsCallback) {
            MLog.e(TAG, "run() -> mIGetAllConfigVersionsCallback is null!");
            return;
        }
        String appName = PhoneStateUtils.getAppName(MonitorCache.getInstance().getContext());
        if (TextUtils.isEmpty((CharSequence)appName)) {
            MLog.e(TAG, "run() -> appName is null or empty!");
            return;
        }
        GetAllConfigVersionsRequest getAllConfigVersionsRequest = new GetAllConfigVersionsRequest();
        getAllConfigVersionsRequest.setAppName(appName);
        getAllConfigVersionsRequest.setTerminal("ANDROID");
        String getAllConfigVersionsRequestJson = GsonUtils.toJsonStr(getAllConfigVersionsRequest);
        MLog.i(TAG, "run() -> getAllConfigVersionsRequestJson:" + getAllConfigVersionsRequestJson);
        OkHttpClientManager.getInstance().postJson(MonitorCache.getInstance().getServerRoot() + "app/getAllConfigVersions", getAllConfigVersionsRequestJson, this);
    }

    @Override
    public void onSuccess(int statusCode, String msg, String result) {
        MLog.i(TAG, "onSuccess()-> result:" + result);
        if (TextUtils.isEmpty((CharSequence)result)) {
            MLog.e(TAG, "onSuccess()-> result is null or empty!");
            this.mIGetAllConfigVersionsCallback.getAllConfigVersions(null);
            return;
        }
        GetAllConfigVersionsResponse response = GsonUtils.json2Bean(result, GetAllConfigVersionsResponse.class);
        if (null == response) {
            MLog.e(TAG, "onSuccess()-> response is null!");
            this.mIGetAllConfigVersionsCallback.getAllConfigVersions(null);
            return;
        }
        int status = response.getStatus();
        if (200 != status) {
            MLog.e(TAG, "onSuccess()-> status is not 200!");
            this.mIGetAllConfigVersionsCallback.getAllConfigVersions(null);
            return;
        }
        this.mIGetAllConfigVersionsCallback.getAllConfigVersions(response.getData());
    }

    @Override
    public void onFailed(int failedCode, String msg) {
        MLog.e(TAG, "onFailed()-> failedCode:" + failedCode + " msg:" + msg);
        this.mIGetAllConfigVersionsCallback.getAllConfigVersions(null);
    }
}

