/*
 * Decompiled with CFR 0.152.
 */
package com.chinapex.android.monitor.executor.runnable;

import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.chinapex.android.monitor.bean.request.EventDataRequest;
import com.chinapex.android.monitor.executor.runnable.IUpdateUI;
import com.chinapex.android.monitor.global.MonitorCache;
import com.chinapex.android.monitor.utils.GsonUtils;
import com.chinapex.android.monitor.utils.MLog;
import com.chinapex.android.monitor.utils.net.INetCallback;
import com.chinapex.android.monitor.utils.net.OkHttpClientManager;

public class PullEventData
implements Runnable,
INetCallback {
    private static final String TAG = PullEventData.class.getSimpleName();
    private EventDataRequest mEventDataRequest;
    private IUpdateUI iUpdateUI;

    public PullEventData(EventDataRequest eventDataRequest, @NonNull IUpdateUI iUpdateUI) {
        this.mEventDataRequest = eventDataRequest;
        this.iUpdateUI = iUpdateUI;
    }

    @Override
    public void run() {
        String requestStr = GsonUtils.toJsonStr(this.mEventDataRequest);
        if (TextUtils.isEmpty((CharSequence)requestStr)) {
            MLog.e(TAG, "run()-> requestStr is null or empty");
            return;
        }
        MLog.d(TAG, "requestStr:" + requestStr);
        OkHttpClientManager.getInstance().postJson(MonitorCache.getInstance().getServerRoot() + "app/getPageStatistics", requestStr, this);
    }

    @Override
    public void onSuccess(int statusCode, String msg, String result) {
        MLog.i(TAG, "onSuccess()-> result:" + result);
        if (TextUtils.isEmpty((CharSequence)result)) {
            MLog.e(TAG, "onSuccess()-> reuslt is null or empty");
            return;
        }
        this.iUpdateUI.updateUI(true, result);
    }

    @Override
    public void onFailed(int failedCode, String msg) {
        MLog.e(TAG, "onFailed()-> failedCode:" + failedCode + " msg:" + msg);
        this.iUpdateUI.updateUI(false, msg);
    }
}

