/*
 * Decompiled with CFR 0.152.
 */
package com.chinapex.android.monitor.executor.runnable;

import android.text.TextUtils;
import com.chinapex.android.monitor.bean.UploadViewBean;
import com.chinapex.android.monitor.executor.runnable.IUpdateUI;
import com.chinapex.android.monitor.global.MonitorCache;
import com.chinapex.android.monitor.utils.BitmapStorageUtil;
import com.chinapex.android.monitor.utils.MLog;
import com.chinapex.android.monitor.utils.net.INetCallback;
import com.chinapex.android.monitor.utils.net.OkHttpClientManager;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class UploadSnapshots
implements Runnable,
INetCallback {
    private static final String TAG = UploadSnapshots.class.getSimpleName();
    private List<UploadViewBean> mUploadViewBeans;
    private IUpdateUI iUpdateUI;

    public UploadSnapshots(List<UploadViewBean> uploadViewBeans, IUpdateUI iUpdateUI) {
        this.iUpdateUI = iUpdateUI;
        this.mUploadViewBeans = new ArrayList<UploadViewBean>();
        this.mUploadViewBeans.clear();
        this.mUploadViewBeans.addAll(uploadViewBeans);
    }

    @Override
    public void run() {
        if (this.mUploadViewBeans.isEmpty()) {
            MLog.e(TAG, "uploadViewBeans is empty");
            return;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (UploadViewBean uploadViewBean : this.mUploadViewBeans) {
            String viewMD5 = uploadViewBean.getMd5();
            String fileName = viewMD5 + ".png";
            String filePath = BitmapStorageUtil.getBitmapStoragePath(viewMD5);
            File file = new File(filePath);
            if (!file.exists()) continue;
            map.put(fileName, filePath);
        }
        OkHttpClientManager.getInstance().postMultipartSnapshotRequest(MonitorCache.getInstance().getServerRoot() + "app/uploadSnapshot", map, this);
    }

    @Override
    public void onSuccess(int statusCode, String msg, String result) {
        MLog.i(TAG, "onSuccess()-> result:" + result);
        if (TextUtils.isEmpty((CharSequence)result)) {
            MLog.e(TAG, "onSuccess()-> reuslt is null or empty");
            return;
        }
        this.iUpdateUI.updateUI(true, result);
    }

    @Override
    public void onFailed(int failedCode, String msg) {
        MLog.e(TAG, "onFailed()-> failedCode:" + failedCode + " msg:" + msg);
        this.iUpdateUI.updateUI(false, msg);
    }
}

