/*
 * Decompiled with CFR 0.152.
 */
package com.chinapex.android.monitor.executor.runnable;

import android.text.TextUtils;
import com.chinapex.android.monitor.bean.ConfigBean;
import com.chinapex.android.monitor.bean.request.UploadConfigRequest;
import com.chinapex.android.monitor.callback.IWriteConfigToSpCallback;
import com.chinapex.android.monitor.global.MonitorCache;
import com.chinapex.android.monitor.utils.FileOpUtils;
import com.chinapex.android.monitor.utils.GsonUtils;
import com.chinapex.android.monitor.utils.MLog;
import com.chinapex.android.monitor.utils.PhoneStateUtils;
import com.chinapex.android.monitor.utils.SpUtils;
import com.chinapex.android.monitor.utils.net.INetCallback;
import com.chinapex.android.monitor.utils.net.OkHttpClientManager;

public class WriteConfigToSp
implements Runnable,
INetCallback {
    private static final String TAG = WriteConfigToSp.class.getSimpleName();
    private IWriteConfigToSpCallback mIWriteConfigToSpCallback;

    public WriteConfigToSp(IWriteConfigToSpCallback iWriteConfigToSpCallback) {
        this.mIWriteConfigToSpCallback = iWriteConfigToSpCallback;
    }

    @Override
    public void run() {
        if (null == this.mIWriteConfigToSpCallback) {
            MLog.e(TAG, "run() -> mIWriteConfigToSpCallback is null!");
            return;
        }
        UploadConfigRequest uploadConfigRequest = new UploadConfigRequest();
        uploadConfigRequest.setAppVersion(PhoneStateUtils.getVersionName());
        uploadConfigRequest.setTerminal("ANDROID");
        uploadConfigRequest.setTimeStamp(System.currentTimeMillis());
        ConfigBean config = new ConfigBean();
        config.setClick(MonitorCache.getInstance().getClickBeans());
        config.setPv(MonitorCache.getInstance().getPvBeans());
        config.setList(MonitorCache.getInstance().getListBeans());
        config.setElemPv(MonitorCache.getInstance().getElemPvBeans());
        config.setRecyclerPv(MonitorCache.getInstance().getRecyclerPvBeans());
        config.setListPv(MonitorCache.getInstance().getListPvBeans());
        config.setExpandablePv(MonitorCache.getInstance().getExpandablePvBeans());
        uploadConfigRequest.setConfig(config);
        String uploadConfigRequestStr = GsonUtils.toJsonStr(uploadConfigRequest);
        if (TextUtils.isEmpty((CharSequence)uploadConfigRequestStr)) {
            MLog.i(TAG, "run() ->  uploadConfigRequestStr is null or empty !");
            return;
        }
        MLog.i(TAG, "run() -> uploadConfigRequestStr:" + uploadConfigRequestStr);
        SpUtils.putParam(MonitorCache.getInstance().getContext(), "event_config", uploadConfigRequestStr);
        OkHttpClientManager.getInstance().postJson(MonitorCache.getInstance().getServerRoot() + "app/uploadConfig", uploadConfigRequestStr, this);
        boolean isSuccess = FileOpUtils.write2ExternalFile("apex_config_", uploadConfigRequestStr, false);
        MLog.i(TAG, "run() -> write2ExternalFile isSuccess:" + isSuccess);
    }

    @Override
    public void onSuccess(int statusCode, String msg, String result) {
        MLog.i(TAG, "onSuccess() -> result:" + result);
        this.mIWriteConfigToSpCallback.writeConfigToSp(true);
    }

    @Override
    public void onFailed(int failedCode, String msg) {
        MLog.e(TAG, "onFailed() -> failedCode:" + failedCode + ", msg:" + msg);
        this.mIWriteConfigToSpCallback.writeConfigToSp(false);
    }
}

