/*
 * Decompiled with CFR 0.152.
 */
package com.chinapex.android.monitor.executor.runnable;

import android.text.TextUtils;
import com.chinapex.android.monitor.bean.ConfigBean;
import com.chinapex.android.monitor.global.MonitorCache;
import com.chinapex.android.monitor.utils.GsonUtils;
import com.chinapex.android.monitor.utils.MLog;
import com.chinapex.android.monitor.utils.SpUtils;
import java.util.Iterator;
import java.util.Map;

public class WriteListToSp
implements Runnable {
    private static final String TAG = WriteListToSp.class.getSimpleName();

    @Override
    public void run() {
        Map<String, ConfigBean.ListBean> listBeans = MonitorCache.getInstance().getListBeans();
        if (null == listBeans) {
            MLog.e(TAG, "run() -> listBeans is null!");
            return;
        }
        Iterator<Map.Entry<String, ConfigBean.ListBean>> iterator = listBeans.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ConfigBean.ListBean> listBeanEntry = iterator.next();
            if (null == listBeanEntry) {
                MLog.e(TAG, "run() -> listBeanEntry is null!");
                continue;
            }
            ConfigBean.ListBean listBean = listBeanEntry.getValue();
            if (null != listBean && null != listBean.getItemAliases() && !listBean.getItemAliases().isEmpty()) continue;
            iterator.remove();
        }
        String listBeansJsonStr = GsonUtils.toJsonStr(listBeans);
        if (TextUtils.isEmpty((CharSequence)listBeansJsonStr)) {
            MLog.e(TAG, "run() -> listBeansJsonStr is null or empty !");
            return;
        }
        SpUtils.putParam(MonitorCache.getInstance().getContext(), "event_list", listBeansJsonStr);
    }
}

