/*
 * Decompiled with CFR 0.152.
 */
package com.chinapex.android.monitor.global;

import android.content.Context;
import android.text.TextUtils;
import com.chinapex.android.monitor.bean.ConfigBean;
import com.chinapex.android.monitor.bean.ContrastItem;
import com.chinapex.android.monitor.bean.StatisticsBean;
import com.chinapex.android.monitor.callback.IMonitorCallback;
import com.chinapex.android.monitor.changelistener.IMonitorListenerController;
import com.chinapex.android.monitor.utils.GsonUtils;
import com.chinapex.android.monitor.utils.MD5Utils;
import com.chinapex.android.monitor.utils.MLog;
import com.chinapex.android.monitor.utils.SpUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

public class MonitorCache {
    private static final String TAG = MonitorCache.class.getSimpleName();
    private Map<String, ConfigBean.ClickBean> mClickBeans = new LinkedHashMap<String, ConfigBean.ClickBean>();
    private Map<String, ConfigBean.PvBean> mPvBeans = new LinkedHashMap<String, ConfigBean.PvBean>();
    private Map<String, ConfigBean.ListBean> mListBeans = new LinkedHashMap<String, ConfigBean.ListBean>();
    private Map<String, Map<String, String>> mElemPvBeans = new LinkedHashMap<String, Map<String, String>>();
    private Map<String, Map<String, String>> mRecyclerPvBeans = new LinkedHashMap<String, Map<String, String>>();
    private Map<String, Map<String, String>> mListPvBeans = new LinkedHashMap<String, Map<String, String>>();
    private Map<String, Map<String, String>> mExpandablePvBeans = new LinkedHashMap<String, Map<String, String>>();
    private Map<String, String> mH5Urls = new HashMap<String, String>();
    private Set<ContrastItem> mContrastItemList = new HashSet<ContrastItem>();
    private Context mContext;
    private IMonitorCallback mIMonitorCallback;
    private Map<Integer, Stack<Map<String, Boolean>>> mTasks;
    private Map<Integer, Integer> mTop;
    private int[] mForegroundTask;
    private String mServerRoot = "http://42.159.94.97:8086/";
    private String hostnameVerifier = "42.159.94.97";
    public List<StatisticsBean> mStatisticsBeans = new ArrayList<StatisticsBean>();

    private MonitorCache() {
    }

    public static MonitorCache getInstance() {
        return MonitorCacheHolder.MONITOR_CACHE;
    }

    public Map<Integer, Stack<Map<String, Boolean>>> getTasks() {
        return this.mTasks;
    }

    public void setTasks(Map<Integer, Stack<Map<String, Boolean>>> mTasks) {
        this.mTasks = mTasks;
    }

    public Map<Integer, Integer> getTop() {
        return this.mTop;
    }

    public void setTop(Map<Integer, Integer> mTop) {
        this.mTop = mTop;
    }

    public int[] getForegroundTask() {
        return this.mForegroundTask;
    }

    public void setForegroundTask(int[] mForegroundTask) {
        this.mForegroundTask = mForegroundTask;
    }

    public List<StatisticsBean> getStatisticsBeans() {
        return this.mStatisticsBeans;
    }

    public void setStatisticsBeans(List<StatisticsBean> statisticsBeans) {
        this.mStatisticsBeans = statisticsBeans;
    }

    public Context getContext() {
        return this.mContext;
    }

    public void setContext(Context context) {
        this.mContext = context;
    }

    public IMonitorCallback getIMonitorCallback() {
        return this.mIMonitorCallback;
    }

    public void setIMonitorCallback(IMonitorCallback iMonitorCallback) {
        this.mIMonitorCallback = iMonitorCallback;
    }

    public String getServerRoot() {
        return this.mServerRoot;
    }

    public void setServerRoot(String serverRoot) {
        this.mServerRoot = serverRoot;
    }

    public String getHostnameVerifier() {
        return this.hostnameVerifier;
    }

    public void setHostnameVerifier(String hostnameVerifier) {
        this.hostnameVerifier = hostnameVerifier;
    }

    public Map<String, ConfigBean.ClickBean> getClickBeans() {
        return this.mClickBeans;
    }

    public void setClickBeans(Map<String, ConfigBean.ClickBean> clickBeans) {
        this.mClickBeans = clickBeans;
    }

    public void putClickBeans(String clickMD5, ConfigBean.ClickBean clickBean) {
        this.mClickBeans.put(clickMD5, clickBean);
    }

    public Map<String, ConfigBean.PvBean> getPvBeans() {
        return this.mPvBeans;
    }

    public void setPvBeans(Map<String, ConfigBean.PvBean> pvBeans) {
        this.mPvBeans = pvBeans;
    }

    public void putPvBeans(String pvMD5, ConfigBean.PvBean pvBean) {
        this.mPvBeans.put(pvMD5, pvBean);
    }

    public Map<String, ConfigBean.ListBean> getListBeans() {
        return this.mListBeans;
    }

    public void setListBeans(Map<String, ConfigBean.ListBean> listBeans) {
        this.mListBeans = listBeans;
    }

    public void putListBeans(String listMD5, ConfigBean.ListBean listBean) {
        this.mListBeans.put(listMD5, listBean);
    }

    public Map<String, Map<String, String>> getElemPvBeans() {
        return this.mElemPvBeans;
    }

    public void setElemPvBeans(Map<String, Map<String, String>> elemPvBeans) {
        this.mElemPvBeans = elemPvBeans;
    }

    public void putElemPvBeans(String pageClassNameMD5, String viewPathMD5, String findPath) {
        if (TextUtils.isEmpty((CharSequence)pageClassNameMD5) || TextUtils.isEmpty((CharSequence)viewPathMD5) || TextUtils.isEmpty((CharSequence)findPath)) {
            MLog.e(TAG, "putElemPvBeans() -> pageClassNameMd5 or viewPathMd5 or findPath is null or empty!");
            return;
        }
        Map<String, String> elemPvBean = this.mElemPvBeans.get(pageClassNameMD5);
        if (null == elemPvBean) {
            MLog.w(TAG, "putElemPvBeans() -> elemPvBean is null!");
            elemPvBean = new HashMap<String, String>();
            elemPvBean.put(viewPathMD5, findPath);
            this.mElemPvBeans.put(pageClassNameMD5, elemPvBean);
            return;
        }
        elemPvBean.put(viewPathMD5, findPath);
    }

    public Map<String, Map<String, String>> getRecyclerPvBeans() {
        return this.mRecyclerPvBeans;
    }

    public void setRecyclerPvBeans(Map<String, Map<String, String>> recyclerPvBeans) {
        this.mRecyclerPvBeans = recyclerPvBeans;
    }

    public void putRecyclerPvBeans(String pageClassNameMD5, String viewPathMD5, String findPath) {
        if (TextUtils.isEmpty((CharSequence)pageClassNameMD5) || TextUtils.isEmpty((CharSequence)viewPathMD5) || TextUtils.isEmpty((CharSequence)findPath)) {
            MLog.e(TAG, "putRecyclerPvBeans() -> pageClassNameMd5 or viewPathMd5 or findPath is null or empty!");
            return;
        }
        Map<String, String> recyclerPvBean = this.mRecyclerPvBeans.get(pageClassNameMD5);
        if (null == recyclerPvBean) {
            MLog.w(TAG, "putRecyclerPvBeans() -> recyclerPvBean is null!");
            recyclerPvBean = new HashMap<String, String>();
            recyclerPvBean.put(viewPathMD5, findPath);
            this.mRecyclerPvBeans.put(pageClassNameMD5, recyclerPvBean);
            return;
        }
        recyclerPvBean.put(viewPathMD5, findPath);
    }

    public Map<String, Map<String, String>> getListPvBeans() {
        return this.mListPvBeans;
    }

    private void setListPvBeans(Map<String, Map<String, String>> listPvBeans) {
        this.mListPvBeans = listPvBeans;
    }

    public void putH5Url(String pagePath, String url) {
        if (TextUtils.isEmpty((CharSequence)pagePath) || TextUtils.isEmpty((CharSequence)url)) {
            MLog.e(TAG, "putH5Url -> pagePath or url is null or empty!");
            return;
        }
        this.mH5Urls.put(pagePath, url);
    }

    public void clearH5Map() {
        this.mH5Urls.clear();
    }

    public String getH5Url(String pagePath) {
        if (TextUtils.isEmpty((CharSequence)pagePath)) {
            MLog.e(TAG, "getH5Url -> pagePath is null or empty!");
            return null;
        }
        return this.mH5Urls.get(pagePath);
    }

    public void putListPvBeans(String pageClassNameMD5, String viewPathMD5, String findPath) {
        if (TextUtils.isEmpty((CharSequence)pageClassNameMD5) || TextUtils.isEmpty((CharSequence)viewPathMD5) || TextUtils.isEmpty((CharSequence)findPath)) {
            MLog.e(TAG, "putListPvBeans() -> pageClassNameMd5 or viewPathMd5 or findPath is null or empty!");
            return;
        }
        Map<String, String> listPvBean = this.mListPvBeans.get(pageClassNameMD5);
        if (null == listPvBean) {
            MLog.w(TAG, "putListPvBeans() -> listPvBean is null!");
            listPvBean = new HashMap<String, String>();
            listPvBean.put(viewPathMD5, findPath);
            this.mListPvBeans.put(pageClassNameMD5, listPvBean);
            return;
        }
        listPvBean.put(viewPathMD5, findPath);
    }

    public Map<String, Map<String, String>> getExpandablePvBeans() {
        return this.mExpandablePvBeans;
    }

    public void setExpandablePvBeans(Map<String, Map<String, String>> expandablePvBeans) {
        this.mExpandablePvBeans = expandablePvBeans;
    }

    public void putExpandablePvBeans(String pageClassNameMD5, String viewPathMD5, String findPath) {
        if (TextUtils.isEmpty((CharSequence)pageClassNameMD5) || TextUtils.isEmpty((CharSequence)viewPathMD5) || TextUtils.isEmpty((CharSequence)findPath)) {
            MLog.e(TAG, "putExpandablePvBeans() -> pageClassNameMd5 or viewPathMd5 or findPath is null or empty!");
            return;
        }
        Map<String, String> expandablePvBean = this.mExpandablePvBeans.get(pageClassNameMD5);
        if (null == expandablePvBean) {
            MLog.w(TAG, "putExpandablePvBeans() -> expandablePvBean is null!");
            expandablePvBean = new HashMap<String, String>();
            expandablePvBean.put(viewPathMD5, findPath);
            this.mExpandablePvBeans.put(pageClassNameMD5, expandablePvBean);
            return;
        }
        expandablePvBean.put(viewPathMD5, findPath);
    }

    public void getExistData() {
        this.getExistClick();
        this.getExistPv();
        this.getExistList();
        this.getExistElemPv();
        this.getExistRecyclerPv();
        this.getExistListPv();
        this.getExistExpandablePv();
    }

    private void getExistClick() {
        String clickBeanStr = (String)SpUtils.getParam(MonitorCache.getInstance().getContext(), "event_click", "");
        if (TextUtils.isEmpty((CharSequence)clickBeanStr)) {
            MLog.i(TAG, "getExistClick -> clickBeanStr is null or empty!");
            return;
        }
        Map<String, ConfigBean.ClickBean> clickBeans = GsonUtils.json2ClickMap(clickBeanStr);
        if (null == clickBeans || clickBeans.isEmpty()) {
            MLog.i(TAG, "getExistClick -> clickBeans is null or empty!");
            return;
        }
        this.mClickBeans.putAll(clickBeans);
    }

    private void getExistPv() {
        String pvBeanStr = (String)SpUtils.getParam(MonitorCache.getInstance().getContext(), "event_pv", "");
        MLog.i(TAG, "getExistPv -> pvBeanStr :" + pvBeanStr);
        if (TextUtils.isEmpty((CharSequence)pvBeanStr)) {
            MLog.i(TAG, "getExistPv -> pvBeanStr is null or empty!");
            return;
        }
        Map<String, ConfigBean.PvBean> pvBeans = GsonUtils.json2PvMap(pvBeanStr);
        if (null == pvBeans || pvBeans.isEmpty()) {
            MLog.i(TAG, "getExistPv -> pvBeans is null or empty!");
            return;
        }
        this.mPvBeans.putAll(pvBeans);
    }

    private void getExistList() {
        String listBeanStr = (String)SpUtils.getParam(MonitorCache.getInstance().getContext(), "event_list", "");
        if (TextUtils.isEmpty((CharSequence)listBeanStr)) {
            MLog.i(TAG, "getExistList -> listBeanStr is null or empty!");
            return;
        }
        Map<String, ConfigBean.ListBean> listBeans = GsonUtils.json2ListMap(listBeanStr);
        if (null == listBeans || listBeans.isEmpty()) {
            MLog.i(TAG, "getExistList -> listBeans is null or empty!");
            return;
        }
        this.mListBeans.putAll(listBeans);
    }

    private void getExistElemPv() {
        String elemPvBeanStr = (String)SpUtils.getParam(MonitorCache.getInstance().getContext(), "event_elem_pv", "");
        MLog.i(TAG, "getExistElemPv -> elemPvBeanStr :" + elemPvBeanStr);
        if (TextUtils.isEmpty((CharSequence)elemPvBeanStr)) {
            MLog.i(TAG, "getExistElemPv -> elemPvBeanStr is null or empty!");
            return;
        }
        Map<String, Map<String, String>> elemPvBeans = GsonUtils.json2WidgetPvMap(elemPvBeanStr);
        if (null == elemPvBeans || elemPvBeans.isEmpty()) {
            MLog.i(TAG, "getExistElemPv -> elemPvBeans is null or empty!");
            return;
        }
        this.mElemPvBeans.putAll(elemPvBeans);
    }

    private void getExistRecyclerPv() {
        String recyclerPvBeanStr = (String)SpUtils.getParam(MonitorCache.getInstance().getContext(), "event_recycler_pv", "");
        if (TextUtils.isEmpty((CharSequence)recyclerPvBeanStr)) {
            MLog.i(TAG, "getExistRecyclerPv -> recyclerPvBeanStr is null or empty!");
            return;
        }
        Map<String, Map<String, String>> recyclerPvBeans = GsonUtils.json2WidgetPvMap(recyclerPvBeanStr);
        if (null == recyclerPvBeans || recyclerPvBeans.isEmpty()) {
            MLog.i(TAG, "getExistRecyclerPv -> recyclerPvBeans is null or empty!");
            return;
        }
        this.mRecyclerPvBeans.putAll(recyclerPvBeans);
    }

    private void getExistListPv() {
        String listPvBeanStr = (String)SpUtils.getParam(MonitorCache.getInstance().getContext(), "event_list_pv", "");
        if (TextUtils.isEmpty((CharSequence)listPvBeanStr)) {
            MLog.i(TAG, "getExistListPv -> listPvBeanStr is null or empty!");
            return;
        }
        Map<String, Map<String, String>> listPvBeans = GsonUtils.json2WidgetPvMap(listPvBeanStr);
        if (null == listPvBeans || listPvBeans.isEmpty()) {
            MLog.i(TAG, "getExistListPv -> listPvBeans is null or empty!");
            return;
        }
        this.mListPvBeans.putAll(listPvBeans);
    }

    private void getExistExpandablePv() {
        String expandablePvBeanStr = (String)SpUtils.getParam(MonitorCache.getInstance().getContext(), "event_expandable_pv", "");
        if (TextUtils.isEmpty((CharSequence)expandablePvBeanStr)) {
            MLog.i(TAG, "getExistExpandablePv -> expandablePvBeanStr is null or empty!");
            return;
        }
        Map<String, Map<String, String>> expandablePvBeans = GsonUtils.json2WidgetPvMap(expandablePvBeanStr);
        if (null == expandablePvBeans || expandablePvBeans.isEmpty()) {
            MLog.i(TAG, "getExistExpandablePv -> expandablePvBeans is null or empty!");
            return;
        }
        this.mExpandablePvBeans.putAll(expandablePvBeans);
    }

    public Set<ContrastItem> getContrastItemList() {
        return this.mContrastItemList;
    }

    public boolean addContrastItem(String viewPath, String pageClassName) {
        String viewPathMD5 = MD5Utils.getMD5(viewPath);
        boolean add = this.mContrastItemList.add(new ContrastItem(viewPathMD5, pageClassName));
        MLog.v(TAG, "addContrastItem()-> add viewPath:" + viewPath + ", pageClassName:" + pageClassName + ", add:" + add);
        IMonitorListenerController.getInstance().notifyComparisonElementsChange();
        return add;
    }

    private static class MonitorCacheHolder {
        private static final MonitorCache MONITOR_CACHE = new MonitorCache();

        private MonitorCacheHolder() {
        }
    }
}

