/*
 * Decompiled with CFR 0.152.
 */
package com.chinapex.android.monitor.utils;

import android.content.Context;
import android.content.pm.PackageManager;
import android.graphics.Bitmap;
import android.os.Build;
import android.os.Environment;
import android.text.TextUtils;
import com.chinapex.android.monitor.global.MonitorCache;
import com.chinapex.android.monitor.utils.MLog;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class BitmapStorageUtil {
    private static final String TAG = BitmapStorageUtil.class.getSimpleName();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveBitmap(String viewMD5, Bitmap bitmap) {
        if (TextUtils.isEmpty((CharSequence)viewMD5)) {
            MLog.e(TAG, "saveBitmap()-> viewMD5 is empty");
            return;
        }
        if (null == bitmap) {
            MLog.e(TAG, "saveBitmap()-> bitmap is null");
            return;
        }
        FileOutputStream fos = null;
        String fileName = viewMD5 + ".png";
        if (Environment.getExternalStorageState().equals("mounted") && BitmapStorageUtil.checkWritePermission()) {
            boolean isSuccess;
            String snapshotFileDirPath = Environment.getExternalStorageDirectory().getPath() + "/.apex/snapshot/";
            File snapshotDir = new File(snapshotFileDirPath);
            if (!snapshotDir.exists() && !(isSuccess = snapshotDir.mkdirs())) {
                MLog.e(TAG, "saveBitmap()-> mkdir failed!");
            }
            File snapshotFile = new File(snapshotFileDirPath + fileName);
            try {
                fos = new FileOutputStream(snapshotFile);
                bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)fos);
            }
            catch (Exception e) {
                MLog.e(TAG, e.getMessage());
            }
            finally {
                try {
                    if (fos != null) {
                        fos.close();
                    }
                }
                catch (IOException e) {
                    MLog.e(TAG, e.getMessage());
                }
            }
        } else {
            Context context = MonitorCache.getInstance().getContext();
            if (null == context) {
                MLog.e(TAG, "saveBitmap()-> context is null!");
                return;
            }
            try {
                fos = context.openFileOutput(fileName, 0);
                bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)fos);
            }
            catch (FileNotFoundException e) {
                MLog.e(TAG, e.getMessage());
            }
            finally {
                if (null != fos) {
                    try {
                        fos.close();
                    }
                    catch (IOException e) {
                        MLog.e(TAG, e.getMessage());
                    }
                }
            }
        }
    }

    public static String getBitmapStoragePath(String viewMD5) {
        String dirPath;
        StringBuilder sb = new StringBuilder();
        String fileName = viewMD5 + ".png";
        if (Environment.getExternalStorageState().equals("mounted") && BitmapStorageUtil.checkWritePermission()) {
            dirPath = Environment.getExternalStorageDirectory().getPath() + "/.apex/snapshot/";
        } else {
            Context context = MonitorCache.getInstance().getContext();
            if (null == context) {
                MLog.e(TAG, "saveBitmap()-> context is null!");
                return sb.toString();
            }
            dirPath = context.getFilesDir().getAbsolutePath() + File.separator;
        }
        sb.append(dirPath).append(fileName);
        return sb.toString();
    }

    public static boolean isBitmapExist(String md5) {
        File file = new File(BitmapStorageUtil.getBitmapStoragePath(md5));
        return file.exists();
    }

    public static boolean checkWritePermission() {
        Context context = MonitorCache.getInstance().getContext();
        if (null == context) {
            MLog.e(TAG, "checkWritePermission()-> can not get context!");
            return false;
        }
        if (Build.VERSION.SDK_INT < 23) {
            PackageManager pm = context.getPackageManager();
            if (null == pm) {
                MLog.e(TAG, "checkWritePermission()-> can not get packageManager!");
                return false;
            }
            return pm.checkPermission("android.permission.WRITE_EXTERNAL_STORAGE", context.getPackageName()) == 0;
        }
        return context.checkSelfPermission("android.permission.WRITE_EXTERNAL_STORAGE") == 0;
    }
}

