/*
 * Decompiled with CFR 0.152.
 */
package com.chinapex.android.monitor.utils;

import android.os.Environment;
import android.text.TextUtils;
import com.chinapex.android.monitor.utils.BitmapStorageUtil;
import com.chinapex.android.monitor.utils.MLog;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class FileOpUtils {
    private static final String TAG = FileOpUtils.class.getSimpleName();
    private static SimpleDateFormat mSimpleDateFormat = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss", Locale.US);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean write2ExternalFile(String fileName, String content, boolean append) {
        if (TextUtils.isEmpty((CharSequence)fileName) || TextUtils.isEmpty((CharSequence)content)) {
            MLog.e(TAG, "write2ExternalFile() -> fileName or content is null or empty!");
            return false;
        }
        if (!"mounted".equals(Environment.getExternalStorageState())) {
            MLog.e(TAG, "write2ExternalFile() -> is not mounted!");
            return false;
        }
        if (!BitmapStorageUtil.checkWritePermission()) {
            MLog.e(TAG, "write2ExternalFile() -> checkWritePermission is false!");
            return false;
        }
        String configFileDirPath = Environment.getExternalStorageDirectory().getPath() + "/ApexData/config/";
        File configFileDir = new File(configFileDirPath);
        if (!configFileDir.exists()) {
            try {
                boolean mkdirs = configFileDir.mkdirs();
                MLog.i(TAG, "write2ExternalFile() -> mkdirs:" + mkdirs);
            }
            catch (Exception e) {
                MLog.e(TAG, "write2ExternalFile() -> mkdirs Exception:" + e.getMessage());
                return false;
            }
        }
        File file = new File(configFileDirPath, fileName + mSimpleDateFormat.format(new Date(System.currentTimeMillis())) + ".txt");
        MLog.i(TAG, "write2ExternalFile() -> file:" + file.toString());
        if (!file.exists()) {
            MLog.i(TAG, "write2ExternalFile() -> file is not exist!");
            try {
                boolean newFile = file.createNewFile();
                MLog.i(TAG, "write2ExternalFile() -> newFile:" + newFile);
            }
            catch (IOException e) {
                MLog.e(TAG, "write2ExternalFile() -> IOException:" + e.getMessage());
                return false;
            }
        }
        BufferedWriter bw = null;
        try {
            FileOutputStream fos = new FileOutputStream(file, append);
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, "UTF-8");
            bw = new BufferedWriter(osw);
            bw.write(content);
        }
        catch (FileNotFoundException e) {
            MLog.e(TAG, "write2ExternalFile() -> FileNotFoundException:" + e.getMessage());
            boolean bl = false;
            return bl;
        }
        catch (UnsupportedEncodingException e) {
            MLog.e(TAG, "write2ExternalFile() -> UnsupportedEncodingException:" + e.getMessage());
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            MLog.e(TAG, "write2ExternalFile() -> IOException:" + e.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (null != bw) {
                    bw.close();
                }
            }
            catch (IOException e) {
                MLog.e(TAG, "write2ExternalFile() -> finally bw IOException:" + e.getMessage());
            }
        }
        return true;
    }
}

