/*
 * Decompiled with CFR 0.152.
 */
package com.chinapex.android.monitor.utils;

import com.chinapex.android.monitor.bean.ConfigBean;
import com.chinapex.android.monitor.utils.MLog;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;

public class GsonUtils {
    private static final String TAG = GsonUtils.class.getSimpleName();
    private static Gson sGson = new Gson();

    private GsonUtils() {
    }

    public static String toJsonStr(Object object) {
        String jsonStr = null;
        if (null != sGson) {
            try {
                jsonStr = sGson.toJson(object);
            }
            catch (Exception e) {
                MLog.e(TAG, "toJsonStr() is exception:" + e.getMessage());
            }
        }
        return jsonStr;
    }

    public static <T> T json2Bean(String jsonStr, Class<T> cls) {
        Object t = null;
        if (null != sGson) {
            try {
                t = sGson.fromJson(jsonStr, cls);
            }
            catch (JsonSyntaxException e) {
                MLog.e(TAG, "json2Bean() is exception:-->jsonStr" + jsonStr + ":cls->" + cls.getSimpleName());
                MLog.e(TAG, "json2Bean() is exception:" + e.getMessage());
            }
        }
        return (T)t;
    }

    public static Map<String, ConfigBean.PvBean> json2PvMap(String stringMapJson) {
        Map map = null;
        try {
            Type type = new TypeToken<Map<String, ConfigBean.PvBean>>(){}.getType();
            map = (Map)sGson.fromJson(stringMapJson, type);
        }
        catch (JsonSyntaxException e) {
            MLog.e(TAG, "json2StringMap JsonSyntaxException:" + e.getMessage());
        }
        return map;
    }

    public static Map<String, ConfigBean.ClickBean> json2ClickMap(String stringMapJson) {
        Map map = null;
        try {
            Type type = new TypeToken<Map<String, ConfigBean.ClickBean>>(){}.getType();
            map = (Map)sGson.fromJson(stringMapJson, type);
        }
        catch (JsonSyntaxException e) {
            MLog.e(TAG, "json2StringMap JsonSyntaxException:" + e.getMessage());
        }
        return map;
    }

    public static Map<String, ConfigBean.ListBean> json2ListMap(String stringMapJson) {
        Map map = null;
        try {
            Type type = new TypeToken<Map<String, ConfigBean.ListBean>>(){}.getType();
            map = (Map)sGson.fromJson(stringMapJson, type);
        }
        catch (JsonSyntaxException e) {
            MLog.e(TAG, "json2StringMap JsonSyntaxException:" + e.getMessage());
        }
        return map;
    }

    public static Map<String, Map<String, String>> json2WidgetPvMap(String stringMapJson) {
        Map map = null;
        try {
            Type type = new TypeToken<Map<String, Map<String, String>>>(){}.getType();
            map = (Map)sGson.fromJson(stringMapJson, type);
        }
        catch (JsonSyntaxException e) {
            MLog.e(TAG, "json2WidgetPvMap JsonSyntaxException:" + e.getMessage());
        }
        return map;
    }

    public static Map<String, String> json2StringMap(String stringMapJson) {
        Map map = null;
        try {
            Type type = new TypeToken<Map<String, String>>(){}.getType();
            map = (Map)sGson.fromJson(stringMapJson, type);
        }
        catch (JsonSyntaxException e) {
            MLog.e(TAG, "json2StringMap JsonSyntaxException:" + e.getMessage());
        }
        return map;
    }

    public static <T> List<T> json2List(String listJson, Class<T> cls) {
        ParameterizedTypeImpl type = new ParameterizedTypeImpl(cls);
        List list = null;
        try {
            list = (List)sGson.fromJson(listJson, (Type)type);
        }
        catch (JsonSyntaxException e) {
            MLog.e(TAG, "json2List() is exception:" + e.getMessage());
        }
        return list;
    }

    private static class ParameterizedTypeImpl
    implements ParameterizedType {
        Class mCls;

        ParameterizedTypeImpl(Class cls) {
            this.mCls = cls;
        }

        @Override
        public Type[] getActualTypeArguments() {
            return new Type[]{this.mCls};
        }

        @Override
        public Type getRawType() {
            return List.class;
        }

        @Override
        public Type getOwnerType() {
            return null;
        }
    }
}

